/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hl7input;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hl7input.HL7Input;
import org.pentaho.di.trans.steps.hl7input.HL7InputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="HL7Input", image="hl7-input.svg", i18nPackageName="org.pentaho.di.trans.steps.hl7input", name="HL7Input.Name", description="HL7Input.TooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Input")
public class HL7InputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = HL7InputMeta.class;
    private String messageField;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getXML() throws KettleException {
        return XMLHandler.addTagValue((String)"message_field", (String)this.messageField);
    }

    private void readData(Node stepnode) {
        this.messageField = XMLHandler.getTagValue((Node)stepnode, (String)"message_field");
    }

    public void setDefault() {
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.messageField = rep.getStepAttributeString(id_step, "message_field");
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "message_field", this.messageField);
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta valueMeta = new ValueMeta("ParentGroup", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("Group", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("HL7Version", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("StructureName", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("StructureNumber", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("FieldName", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("Coordinates", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("HL7DataType", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("FieldDescription", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        valueMeta = new ValueMeta("Value", 2);
        valueMeta.setOrigin(origin);
        rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"HL7InputMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"HL7InputMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"HL7InputMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"HL7InputMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new HL7Input(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new HL7InputData();
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }
}

