/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createParentFolder(Class<?> PKG, String filename, boolean createParentFolder, LogChannelInterface log, VariableSpace vs) {
        FileObject parentfolder = null;
        boolean resultat = true;
        try {
            parentfolder = KettleVFS.getFileObject((String)filename, (VariableSpace)vs).getParent();
            if (!parentfolder.exists()) {
                if (createParentFolder) {
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(PKG, (String)"JobTrans.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(PKG, (String)"JobTrans.Log.ParentLogFolderCreated", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                } else {
                    log.logError(BaseMessages.getString(PKG, (String)"JobTrans.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    resultat = false;
                }
            } else if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"JobTrans.Log.ParentLogFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
            }
        }
        catch (Exception e) {
            resultat = false;
            log.logError(BaseMessages.getString(PKG, (String)"JobTrans.Error.ChekingParentLogFolderTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobTrans.Error.ChekingParentLogFolder", (String[])new String[]{parentfolder.getName().toString()}), e});
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                    parentfolder = null;
                }
                catch (Exception ex) {}
            }
        }
        return resultat;
    }
}

