/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rules;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.BaseImportRule;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.w3c.dom.Node;

public class DatabaseConfigurationImportRule
extends BaseImportRule
implements ImportRuleInterface {
    private DatabaseMeta databaseMeta = null;

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public ImportRuleInterface clone() {
        DatabaseConfigurationImportRule rule = new DatabaseConfigurationImportRule();
        rule.setId(this.getId());
        rule.setEnabled(this.isEnabled());
        if (this.databaseMeta != null) {
            rule.setDatabaseMeta((DatabaseMeta)this.databaseMeta.clone());
        }
        return rule;
    }

    @Override
    public List<ImportValidationFeedback> verifyRule(Object subject) {
        ArrayList<ImportValidationFeedback> feedback = new ArrayList<ImportValidationFeedback>();
        if (!this.isEnabled()) {
            return feedback;
        }
        if (this.databaseMeta == null) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "This rule contains no database to validate against."));
            return feedback;
        }
        DatabaseMeta verify = null;
        if (subject instanceof HasDatabasesInterface) {
            HasDatabasesInterface dbs = (HasDatabasesInterface)subject;
            verify = dbs.findDatabase(this.databaseMeta.getName());
        } else if (subject instanceof DatabaseMeta && this.databaseMeta.getName().equals(((DatabaseMeta)subject).getName())) {
            verify = (DatabaseMeta)subject;
        }
        if (verify == null) {
            return feedback;
        }
        if (!Const.isEmpty((String)this.databaseMeta.getDatabaseName()) && !this.databaseMeta.getDatabaseName().equals(verify.getDatabaseName())) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The name of the database is not set to the expected value '" + this.databaseMeta.getDatabaseName() + "'."));
        }
        if (!Const.isEmpty((String)this.databaseMeta.getHostname()) && !this.databaseMeta.getHostname().equals(verify.getHostname())) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The host name of the database is not set to the expected value '" + this.databaseMeta.getHostname() + "'."));
        }
        if (!Const.isEmpty((String)this.databaseMeta.getDatabasePortNumberString()) && !this.databaseMeta.getDatabasePortNumberString().equals(verify.getDatabasePortNumberString())) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The database port of the database is not set to the expected value '" + this.databaseMeta.getDatabasePortNumberString() + "'."));
        }
        if (!Const.isEmpty((String)this.databaseMeta.getUsername()) && !this.databaseMeta.getUsername().equals(verify.getUsername())) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The username of the database is not set to the expected value '" + this.databaseMeta.getUsername() + "'."));
        }
        if (!Const.isEmpty((String)this.databaseMeta.getPassword()) && !this.databaseMeta.getPassword().equals(verify.getPassword())) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.ERROR, "The password of the database is not set to the expected value."));
        }
        if (feedback.isEmpty()) {
            feedback.add(new ImportValidationFeedback(this, ImportValidationResultType.APPROVAL, "The database connection was found and verified."));
        }
        return feedback;
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(super.getXML());
        if (this.databaseMeta != null) {
            xml.append(this.databaseMeta.getXML());
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    @Override
    public void loadXML(Node ruleNode) throws KettleException {
        super.loadXML(ruleNode);
        Node connectionNode = XMLHandler.getSubNode((Node)ruleNode, (String)"connection");
        if (connectionNode != null) {
            this.databaseMeta = new DatabaseMeta(connectionNode);
        }
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }
}

