/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sftp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySFTP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySFTP.class;
    private static final int DEFAULT_PORT = 22;
    private String serverName = null;
    private String serverPort = "22";
    private String userName;
    private String password;
    private String sftpDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean remove;
    private boolean isaddresult = true;
    private boolean createtargetfolder = false;
    private boolean copyprevious = false;
    private boolean usekeyfilename = false;
    private String keyfilename = null;
    private String keyfilepass = null;
    private String compression = "none";
    private String proxyType = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;

    public JobEntrySFTP(String n) {
        super(n, "");
    }

    public JobEntrySFTP() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySFTP je = (JobEntrySFTP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sftpdirectory", (String)this.sftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createtargetfolder", (boolean)this.createtargetfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usekeyfilename", (boolean)this.usekeyfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compression", (String)this.compression));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyType", (String)this.proxyType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.sftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"sftpdirectory");
            this.targetDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            String addresult = XMLHandler.getTagValue((Node)entrynode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createtargetfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createtargetfolder"));
            this.copyprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.usekeyfilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usekeyfilename"));
            this.keyfilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass"));
            this.compression = XMLHandler.getTagValue((Node)entrynode, (String)"compression");
            this.proxyType = XMLHandler.getTagValue((Node)entrynode, (String)"proxyType");
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxyPort");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxyPassword"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SFTP' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.sftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "sftpdirectory");
            this.targetDirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            String addToResult = rep.getStepAttributeString(id_jobentry, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_jobentry, "add_to_result_filenames");
            this.createtargetfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createtargetfolder");
            this.copyprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "copyprevious");
            this.usekeyfilename = rep.getJobEntryAttributeBoolean(id_jobentry, "usekeyfilename");
            this.keyfilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyfilepass = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "keyfilepass"));
            this.compression = rep.getJobEntryAttributeString(id_jobentry, "compression");
            this.proxyType = rep.getJobEntryAttributeString(id_jobentry, "proxyType");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxyHost");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxyPort");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxyPassword"));
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SFTP' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sftpdirectory", this.sftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetdirectory", this.targetDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isaddresult", this.isaddresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createtargetfolder", this.createtargetfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "copyprevious", this.copyprevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usekeyfilename", this.usekeyfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilename", this.keyfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilepass", Encr.encryptPasswordIfNotUsingVariables((String)this.keyfilepass));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "compression", this.compression);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyType", this.proxyType);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyHost", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyPort", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyUsername", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'SFTP' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getScpDirectory() {
        return this.sftpDirectory;
    }

    public void setScpDirectory(String directory) {
        this.sftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setAddToResult(boolean isaddresultin) {
        this.isaddresult = isaddresultin;
    }

    public boolean isAddToResult() {
        return this.isaddresult;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setcreateTargetFolder(boolean createtargetfolder) {
        this.createtargetfolder = createtargetfolder;
    }

    public boolean iscreateTargetFolder() {
        return this.createtargetfolder;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isUseKeyFile() {
        return this.usekeyfilename;
    }

    public void setUseKeyFile(boolean value) {
        this.usekeyfilename = value;
    }

    public String getKeyFilename() {
        return this.keyfilename;
    }

    public void setKeyFilename(String value) {
        this.keyfilename = value;
    }

    public String getKeyPassPhrase() {
        return this.keyfilepass;
    }

    public void setKeyPassPhrase(String value) {
        this.keyfilepass = value;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String value) {
        this.proxyType = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        result.setResult(false);
        long filesRetrieved = 0L;
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.StartJobEntry", (String[])new String[0]));
        }
        HashSet<String> list_previous_filenames = new HashSet<String>();
        if (this.copyprevious) {
            if (rows.size() == 0) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.ArgsFromPreviousNothing", (String[])new String[0]));
                }
                result.setResult(true);
                return result;
            }
            try {
                for (int iteration = 0; iteration < rows.size(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String file_previous = resultRow.getString(0, null);
                    if (Const.isEmpty((String)file_previous)) continue;
                    list_previous_filenames.add(file_previous);
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobSFTP.Log.FilenameFromResult", (String[])new String[]{file_previous}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobSFTP.Error.ArgFromPrevious", (String[])new String[0]));
                result.setNrErrors(1L);
                return result;
            }
        }
        SFTPClient sftpclient = null;
        String realServerName = this.environmentSubstitute(this.serverName);
        String realServerPort = this.environmentSubstitute(this.serverPort);
        String realUsername = this.environmentSubstitute(this.userName);
        String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
        String realSftpDirString = this.environmentSubstitute(this.sftpDirectory);
        String realWildcard = this.environmentSubstitute(this.wildcard);
        String realTargetDirectory = this.environmentSubstitute(this.targetDirectory);
        String realKeyFilename = null;
        String realPassPhrase = null;
        FileObject TargetFolder = null;
        try {
            if (this.isUseKeyFile()) {
                realKeyFilename = this.environmentSubstitute(this.getKeyFilename());
                if (Const.isEmpty((String)realKeyFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobSFTP.Error.KeyFileMissing", (String[])new String[0]));
                    result.setNrErrors(1L);
                    Result result2 = result;
                    return result2;
                }
                if (!KettleVFS.fileExists((String)realKeyFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobSFTP.Error.KeyFileNotFound", (String[])new String[]{realKeyFilename}));
                    result.setNrErrors(1L);
                    Result result3 = result;
                    return result3;
                }
                realPassPhrase = this.environmentSubstitute(this.getKeyPassPhrase());
            }
            if (!Const.isEmpty((String)realTargetDirectory)) {
                TargetFolder = KettleVFS.getFileObject((String)realTargetDirectory, (VariableSpace)this);
                boolean TargetFolderExists = TargetFolder.exists();
                if (TargetFolderExists) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.TargetFolderExists", (String[])new String[]{realTargetDirectory}));
                    }
                } else {
                    if (!this.createtargetfolder) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobSFTP.Error.TargetFolderNotExists", (String[])new String[]{realTargetDirectory}));
                        result.setNrErrors(1L);
                        Result e = result;
                        return e;
                    }
                    TargetFolder.createFolder();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.TargetFolderCreated", (String[])new String[]{realTargetDirectory}));
                    }
                }
            }
            if (TargetFolder != null) {
                TargetFolder.close();
                TargetFolder = null;
            }
            sftpclient = new SFTPClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername, realKeyFilename, realPassPhrase);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.OpenedConnection", (String[])new String[]{realServerName, realServerPort, realUsername}));
            }
            sftpclient.setCompression(this.getCompression());
            String realProxyHost = this.environmentSubstitute(this.getProxyHost());
            if (!Const.isEmpty((String)realProxyHost)) {
                sftpclient.setProxy(realProxyHost, this.environmentSubstitute(this.getProxyPort()), this.environmentSubstitute(this.getProxyUsername()), this.environmentSubstitute(this.getProxyPassword()), this.getProxyType());
            }
            sftpclient.login(realPassword);
            if (!Const.isEmpty((String)realSftpDirString)) {
                try {
                    sftpclient.chdir(realSftpDirString);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobSFTP.Error.CanNotFindRemoteFolder", (String[])new String[]{realSftpDirString}));
                    throw new Exception(e);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.ChangedDirectory", (String[])new String[]{realSftpDirString}));
                }
            }
            Pattern pattern = null;
            String[] filelist = sftpclient.dir();
            if (filelist == null) {
                result.setResult(true);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.Found", (String[])new String[]{"0"}));
                }
                Result result4 = result;
                return result4;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.Found", (String[])new String[]{"" + filelist.length}));
            }
            if (!this.copyprevious && !Const.isEmpty((String)realWildcard)) {
                pattern = Pattern.compile(realWildcard);
            }
            for (int i = 0; i < filelist.length && !this.parentJob.isStopped(); ++i) {
                boolean getIt = true;
                if (this.copyprevious) {
                    getIt = list_previous_filenames.contains(filelist[i]);
                } else if (pattern != null) {
                    Matcher matcher = pattern.matcher(filelist[i]);
                    getIt = matcher.matches();
                }
                if (!getIt) continue;
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobSFTP.Log.GettingFiles", (String[])new String[]{filelist[i], realTargetDirectory}));
                }
                FileObject targetFile = KettleVFS.getFileObject((String)(realTargetDirectory + Const.FILE_SEPARATOR + filelist[i]), (VariableSpace)this);
                sftpclient.get(targetFile, filelist[i]);
                ++filesRetrieved;
                if (this.isaddresult) {
                    ResultFile resultFile = new ResultFile(0, targetFile, this.parentJob.getJobname(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.FilenameAddedToResultFilenames", (String[])new String[]{filelist[i]}));
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.TransferedFile", (String[])new String[]{filelist[i]}));
                }
                if (!this.remove) continue;
                sftpclient.delete(filelist[i]);
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSFTP.Log.DeletedFile", (String[])new String[]{filelist[i]}));
            }
            result.setResult(true);
            result.setNrFilesRetrieved(filesRetrieved);
            return result;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobSFTP.Error.GettingFiles", (String[])new String[]{e.getMessage()}));
            this.logError(Const.getStackTracker((Throwable)e));
            return result;
        }
        finally {
            try {
                if (sftpclient != null) {
                    sftpclient.disconnect();
                }
            }
            catch (Exception e) {}
            try {
                if (TargetFolder != null) {
                    TargetFolder.close();
                    TargetFolder = null;
                }
                if (list_previous_filenames != null) {
                    list_previous_filenames = null;
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "targetDirectory", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntrySFTP().check(remarks, null, (VariableSpace)new Variables(), null, null);
        System.out.printf("Remarks: %s\n", remarks);
    }
}

