/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.snmptrap;

import java.net.InetAddress;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.w3c.dom.Node;

public class JobEntrySNMPTrap
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySNMPTrap.class;
    private String serverName = null;
    private String port = "" + DEFAULT_PORT;
    private String timeout;
    private String nrretry = "" + DEFAULT_RETRIES;
    private String comString = "public";
    private String message = null;
    private String oid = null;
    private String targettype;
    private String user = null;
    private String passphrase = null;
    private String engineid = null;
    private static int DEFAULT_RETRIES = 1;
    private static int DEFAULT_TIME_OUT = 5000;
    public static int DEFAULT_PORT = 162;
    public static final String[] target_type_Desc = new String[]{BaseMessages.getString(PKG, (String)"JobSNMPTrap.TargetType.Community", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.TargetType.User", (String[])new String[0])};
    public static final String[] target_type_Code = new String[]{"community", "user"};

    public JobEntrySNMPTrap(String n) {
        super(n, "");
        this.timeout = "" + DEFAULT_TIME_OUT;
        this.targettype = target_type_Code[0];
    }

    public JobEntrySNMPTrap() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySNMPTrap je = (JobEntrySNMPTrap)super.clone();
        return je;
    }

    public String getTargetTypeDesc(String tt) {
        if (Const.isEmpty((String)tt)) {
            return target_type_Desc[0];
        }
        if (tt.equalsIgnoreCase(target_type_Code[1])) {
            return target_type_Desc[1];
        }
        return target_type_Desc[0];
    }

    public String getTargetTypeCode(String tt) {
        if (tt == null) {
            return target_type_Code[0];
        }
        if (tt.equals(target_type_Desc[1])) {
            return target_type_Code[1];
        }
        return target_type_Code[0];
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"oid", (String)this.oid));
        retval.append("      ").append(XMLHandler.addTagValue((String)"comstring", (String)this.comString));
        retval.append("      ").append(XMLHandler.addTagValue((String)"message", (String)this.message));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nrretry", (String)this.nrretry));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targettype", (String)this.targettype));
        retval.append("      ").append(XMLHandler.addTagValue((String)"user", (String)this.user));
        retval.append("      ").append(XMLHandler.addTagValue((String)"passphrase", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.passphrase)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"engineid", (String)this.engineid));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.oid = XMLHandler.getTagValue((Node)entrynode, (String)"oid");
            this.message = XMLHandler.getTagValue((Node)entrynode, (String)"message");
            this.comString = XMLHandler.getTagValue((Node)entrynode, (String)"comstring");
            this.timeout = XMLHandler.getTagValue((Node)entrynode, (String)"timeout");
            this.nrretry = XMLHandler.getTagValue((Node)entrynode, (String)"nrretry");
            this.targettype = XMLHandler.getTagValue((Node)entrynode, (String)"targettype");
            this.user = XMLHandler.getTagValue((Node)entrynode, (String)"user");
            this.passphrase = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"passphrase"));
            this.engineid = XMLHandler.getTagValue((Node)entrynode, (String)"engineid");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SNMPTrap' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.oid = rep.getJobEntryAttributeString(id_jobentry, "oid");
            this.message = rep.getJobEntryAttributeString(id_jobentry, "message");
            this.comString = rep.getJobEntryAttributeString(id_jobentry, "comstring");
            this.timeout = rep.getJobEntryAttributeString(id_jobentry, "timeout");
            this.nrretry = rep.getJobEntryAttributeString(id_jobentry, "nrretry");
            this.targettype = rep.getJobEntryAttributeString(id_jobentry, "targettype");
            this.user = rep.getJobEntryAttributeString(id_jobentry, "user");
            this.passphrase = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "passphrase"));
            this.engineid = rep.getJobEntryAttributeString(id_jobentry, "engineid");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SNMPTrap' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "oid", this.oid);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "message", this.message);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "comstring", this.comString);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nrretry", this.nrretry);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targettype", this.targettype);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "user", this.user);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "passphrase", Encr.encryptPasswordIfNotUsingVariables((String)this.passphrase));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "engineid", this.engineid);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'SNMPTrap' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public String getComString() {
        return this.comString;
    }

    public void setComString(String comString) {
        this.comString = comString;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassPhrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getPassPhrase() {
        return this.passphrase;
    }

    public void setEngineID(String engineid) {
        this.engineid = engineid;
    }

    public String getEngineID() {
        return this.engineid;
    }

    public String getTargetType() {
        return this.targettype;
    }

    public void setTargetType(String targettypein) {
        this.targettype = this.getTargetTypeCode(targettypein);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setRetry(String nrretry) {
        this.nrretry = nrretry;
    }

    public String getRetry() {
        return this.nrretry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String servername = this.environmentSubstitute(this.serverName);
        int nrPort = Const.toInt((String)this.environmentSubstitute("" + this.port), (int)DEFAULT_PORT);
        String Oid = this.environmentSubstitute(this.oid);
        int timeOut = Const.toInt((String)this.environmentSubstitute("" + this.timeout), (int)DEFAULT_TIME_OUT);
        int retry = Const.toInt((String)this.environmentSubstitute("" + this.nrretry), (int)1);
        String messageString = this.environmentSubstitute(this.message);
        Snmp snmp = null;
        try {
            DefaultUdpTransportMapping transMap = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transMap);
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(servername), nrPort);
            ResponseEvent response = null;
            if (this.targettype.equals(target_type_Code[0])) {
                String community = this.environmentSubstitute(this.comString);
                CommunityTarget target = new CommunityTarget();
                PDUv1 pdu1 = new PDUv1();
                transMap.listen();
                target.setCommunity(new OctetString(community));
                target.setVersion(0);
                target.setAddress((Address)udpAddress);
                if (target.getAddress().isValid()) {
                    if (this.log.isDebug()) {
                        this.logDebug("Valid IP address");
                    }
                } else {
                    throw new KettleException("Invalid IP address");
                }
                target.setRetries(retry);
                target.setTimeout((long)timeOut);
                pdu1.setGenericTrap(6);
                pdu1.setSpecificTrap(6);
                pdu1.setEnterprise(new OID(Oid));
                pdu1.add(new VariableBinding(new OID(Oid), (Variable)new OctetString(messageString)));
                response = snmp.send((PDU)pdu1, (Target)target);
            } else {
                String userName = this.environmentSubstitute(this.user);
                String passPhrase = this.environmentSubstitute(this.passphrase);
                String engineID = this.environmentSubstitute(this.engineid);
                UserTarget usertarget = new UserTarget();
                transMap.listen();
                usertarget.setAddress((Address)udpAddress);
                if (usertarget.getAddress().isValid()) {
                    if (this.log.isDebug()) {
                        this.logDebug("Valid IP address");
                    }
                } else {
                    throw new KettleException("Invalid IP address");
                }
                usertarget.setRetries(retry);
                usertarget.setTimeout((long)timeOut);
                usertarget.setVersion(3);
                usertarget.setSecurityLevel(3);
                usertarget.setSecurityName(new OctetString("MD5DES"));
                UsmUser uu = new UsmUser(new OctetString(userName), AuthMD5.ID, new OctetString(passPhrase), PrivDES.ID, new OctetString(passPhrase));
                USM usm = snmp.getUSM();
                if (usm == null) {
                    throw new KettleException("Null Usm");
                }
                usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                usm.addUser(new OctetString(userName), uu);
                if (this.log.isDebug()) {
                    this.logDebug("Valid Usm");
                }
                ScopedPDU pdu = new ScopedPDU();
                pdu.add(new VariableBinding(new OID(Oid), (Variable)new OctetString(messageString)));
                pdu.setType(-89);
                if (!Const.isEmpty((String)engineID)) {
                    pdu.setContextEngineID(new OctetString(engineID));
                }
                response = snmp.send((PDU)pdu, (Target)usertarget);
            }
            if (response != null && this.log.isDebug()) {
                this.logDebug("Received response from: " + response.getPeerAddress() + response.toString());
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySNMPTrap.ErrorGetting", (String[])new String[]{e.getMessage()}));
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

