/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.xmlwellformed;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLCheck;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class JobEntryXMLWellFormed
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryXMLWellFormed.class;
    public String SUCCESS_IF_AT_LEAST_X_FILES_WELL_FORMED = "success_when_at_least";
    public String SUCCESS_IF_BAD_FORMED_FILES_LESS = "success_if_bad_formed_files_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    public String ADD_ALL_FILENAMES = "all_filenames";
    public String ADD_WELL_FORMED_FILES_ONLY = "only_well_formed_filenames";
    public String ADD_BAD_FORMED_FILES_ONLY = "only_bad_formed_filenames";
    public boolean arg_from_previous = false;
    public boolean include_subfolders = false;
    public String[] source_filefolder = null;
    public String[] wildcard = null;
    private String nr_errors_less_than = "10";
    private String success_condition;
    private String resultfilenames = this.ADD_ALL_FILENAMES;
    int NrAllErrors = 0;
    int NrBadFormed = 0;
    int NrWellFormed = 0;
    int limitFiles = 0;
    int NrErrors = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;

    public JobEntryXMLWellFormed(String n) {
        super(n, "");
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
    }

    public JobEntryXMLWellFormed() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryXMLWellFormed je = (JobEntryXMLWellFormed)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"resultfilenames", (String)this.resultfilenames));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.resultfilenames = XMLHandler.getTagValue((Node)entrynode, (String)"resultfilenames");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.resultfilenames = rep.getJobEntryAttributeString(id_jobentry, "resultfilenames");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "resultfilenames", this.resultfilenames);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        this.NrErrors = 0;
        this.NrWellFormed = 0;
        this.NrBadFormed = 0;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        String[] vsourcefilefolder = this.source_filefolder;
        String[] vwildcard = this.wildcard;
        if (this.arg_from_previous && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
        }
        if (this.arg_from_previous && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrAllErrors);
                    result.setNrLinesRejected((long)this.NrBadFormed);
                    result.setNrLinesWritten((long)this.NrWellFormed);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vsourcefilefolder_previous = resultRow.getString(0, null);
                String vwildcard_previous = resultRow.getString(1, null);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vwildcard_previous}));
                }
                this.processFileFolder(vsourcefilefolder_previous, vwildcard_previous, this.parentJob, result);
            }
        } else if (vsourcefilefolder != null) {
            for (int i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.NrAllErrors);
                    result.setNrLinesRejected((long)this.NrBadFormed);
                    result.setNrLinesWritten((long)this.NrWellFormed);
                    return result;
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vwildcard[i]}));
                }
                this.processFileFolder(vsourcefilefolder[i], vwildcard[i], this.parentJob, result);
            }
        }
        result.setNrErrors((long)this.NrAllErrors);
        result.setNrLinesRejected((long)this.NrBadFormed);
        result.setNrLinesWritten((long)this.NrWellFormed);
        if (this.getSuccessStatus()) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.log.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.Info.FilesInError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.Info.FilesInBadFormed", (String[])new String[]{"" + this.NrBadFormed}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.Info.FilesInWellFormed", (String[])new String[]{"" + this.NrWellFormed}));
            this.logDetailed("=======================================");
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrAllErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrBadFormed >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_BAD_FORMED_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrAllErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrWellFormed >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_WELL_FORMED) || this.NrBadFormed < this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_BAD_FORMED_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        this.updateAllErrors();
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateAllErrors() {
        this.NrAllErrors = this.NrErrors + this.NrBadFormed;
    }

    private boolean CheckFile(FileObject file) {
        boolean retval = false;
        try {
            retval = XMLCheck.isXMLFileWellFormed((FileObject)file);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.ErrorCheckingFile", (String[])new String[]{file.toString(), e.getMessage()}));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFileFolder(String sourcefilefoldername, String wildcard, Job parentJob, Result result) {
        boolean entrystatus;
        block37: {
            entrystatus = false;
            FileObject sourcefilefolder = null;
            FileObject CurrentFile = null;
            String realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
            if (Const.isEmpty((String)realSourceFilefoldername)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.log.FileFolderEmpty", (String[])new String[]{sourcefilefoldername}));
                this.updateErrors();
                return entrystatus;
            }
            String realWildcard = this.environmentSubstitute(wildcard);
            try {
                sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername, (VariableSpace)this);
                if (sourcefilefolder.exists()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                    }
                    if (sourcefilefolder.getType() == FileType.FILE) {
                        entrystatus = this.checkOneFile(sourcefilefolder, result, parentJob);
                        break block37;
                    }
                    if (sourcefilefolder.getType() == FileType.FOLDER) {
                        FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                            public boolean traverseDescendents(FileSelectInfo info) {
                                return true;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean includeFile(FileSelectInfo info) {
                                block18: {
                                    boolean bl;
                                    FileObject fileObject = info.getFile();
                                    try {
                                        if (fileObject == null) {
                                            boolean bl2 = false;
                                            return bl2;
                                        }
                                        if (fileObject.getType() == FileType.FILE) break block18;
                                        bl = false;
                                    }
                                    catch (Exception ex) {
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                    finally {
                                        if (fileObject != null) {
                                            try {
                                                fileObject.close();
                                            }
                                            catch (IOException ex) {}
                                        }
                                    }
                                    return bl;
                                }
                                return true;
                            }
                        });
                        if (fileObjects == null) break block37;
                        int j = 0;
                        while (true) {
                            if (j < fileObjects.length && !parentJob.isStopped()) {
                                if (this.successConditionBroken) {
                                    if (!this.successConditionBrokenExit) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrAllErrors}));
                                        this.successConditionBrokenExit = true;
                                    }
                                    boolean bl = false;
                                    return bl;
                                }
                                CurrentFile = fileObjects[j];
                                if (!CurrentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                    if (this.include_subfolders && this.GetFileWildcard(CurrentFile.toString(), realWildcard)) {
                                        this.checkOneFile(CurrentFile, result, parentJob);
                                    }
                                } else if (this.GetFileWildcard(CurrentFile.toString(), realWildcard)) {
                                    this.checkOneFile(CurrentFile, result, parentJob);
                                }
                                ++j;
                                continue;
                            }
                            break block37;
                            break;
                        }
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                    this.updateErrors();
                    break block37;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                this.updateErrors();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.Exception.Processing", (Object[])new Object[]{realSourceFilefoldername.toString(), e}));
                this.updateErrors();
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException ex) {}
                }
                if (CurrentFile != null) {
                    try {
                        CurrentFile.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return entrystatus;
    }

    private boolean checkOneFile(FileObject file, Result result, Job parentJob) throws KettleException {
        boolean retval = false;
        try {
            boolean retformed = this.CheckFile(file);
            if (!retformed) {
                this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.FileBadFormed", (String[])new String[]{file.toString()}));
                this.updateBadFormed();
                if (this.resultfilenames.equals(this.ADD_ALL_FILENAMES) || this.resultfilenames.equals(this.ADD_BAD_FORMED_FILES_ONLY)) {
                    this.addFileToResultFilenames(KettleVFS.getFilename((FileObject)file), result, parentJob);
                }
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed("---------------------------");
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.FileWellFormed", (String[])new String[]{file.toString()}));
                }
                this.updateWellFormed();
                if (this.resultfilenames.equals(this.ADD_ALL_FILENAMES) || this.resultfilenames.equals(this.ADD_WELL_FORMED_FILES_ONLY)) {
                    this.addFileToResultFilenames(KettleVFS.getFilename((FileObject)file), result, parentJob);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to verify file '" + file + "'", (Throwable)e);
        }
        return retval;
    }

    private void updateWellFormed() {
        ++this.NrWellFormed;
    }

    private void updateBadFormed() {
        ++this.NrBadFormed;
        this.updateAllErrors();
    }

    private void addFileToResultFilenames(String fileaddentry, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry, (VariableSpace)this), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobXMLWellFormed.Error.AddingToFilenameResult", (String[])new String[]{fileaddentry, e.getMessage()}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setResultFilenames(String resultfilenames) {
        this.resultfilenames = resultfilenames;
    }

    public String getResultFilenames() {
        return this.resultfilenames;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public static class XMLTreeHandler
    extends DefaultHandler {
    }
}

