/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.xsdvalidator;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JobEntryXSDValidator
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryXSDValidator.class;
    private String xmlfilename = null;
    private String xsdfilename = null;

    public JobEntryXSDValidator(String n) {
        super(n, "");
    }

    public JobEntryXSDValidator() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryXSDValidator je = (JobEntryXSDValidator)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xsdfilename", (String)this.xsdfilename));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.xmlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.xsdfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xsdfilename");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'xsdvalidator' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.xmlfilename = rep.getJobEntryAttributeString(id_jobentry, "xmlfilename");
            this.xsdfilename = rep.getJobEntryAttributeString(id_jobentry, "xsdfilename");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'xsdvalidator' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "xmlfilename", this.xmlfilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "xsdfilename", this.xsdfilename);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'xsdvalidator' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getRealxmlfilename() {
        return this.environmentSubstitute(this.getxmlFilename());
    }

    public String getRealxsdfilename() {
        return this.environmentSubstitute(this.getxsdFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        String realxmlfilename = this.getRealxmlfilename();
        String realxsdfilename = this.getRealxsdfilename();
        FileObject xmlfile = null;
        FileObject xsdfile = null;
        try {
            if (this.xmlfilename != null && this.xsdfilename != null) {
                xmlfile = KettleVFS.getFileObject((String)realxmlfilename, (VariableSpace)this);
                xsdfile = KettleVFS.getFileObject((String)realxsdfilename, (VariableSpace)this);
                if (xmlfile.exists() && xsdfile.exists()) {
                    SchemaFactory factorytXSDValidator_1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    File XSDFile = new File(KettleVFS.getFilename((FileObject)xsdfile));
                    Schema SchematXSD = factorytXSDValidator_1.newSchema(XSDFile);
                    Validator XSDValidator = SchematXSD.newValidator();
                    File xmlfiletXSDValidator_1 = new File(KettleVFS.getFilename((FileObject)xmlfile));
                    StreamSource sourcetXSDValidator_1 = new StreamSource(xmlfiletXSDValidator_1);
                    XSDValidator.validate(sourcetXSDValidator_1);
                    result.setResult(true);
                } else {
                    if (!xmlfile.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.FileDoesNotExist1.Label", (String[])new String[0]) + realxmlfilename + BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.FileDoesNotExist2.Label", (String[])new String[0]));
                    }
                    if (!xsdfile.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.FileDoesNotExist1.Label", (String[])new String[0]) + realxsdfilename + BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.FileDoesNotExist2.Label", (String[])new String[0]));
                    }
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.AllFilesNotNull.Label", (String[])new String[0]));
                result.setResult(false);
                result.setNrErrors(1L);
            }
        }
        catch (SAXException ex) {
            this.logError("Error :" + ex.getMessage());
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.ErrorXSDValidator.Label", (String[])new String[0]) + BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.ErrorXML1.Label", (String[])new String[0]) + realxmlfilename + BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.ErrorXML2.Label", (String[])new String[0]) + BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.ErrorXSD1.Label", (String[])new String[0]) + realxsdfilename + BaseMessages.getString(PKG, (String)"JobEntryXSDValidator.ErrorXSD2.Label", (String[])new String[0]) + e.getMessage());
            result.setResult(false);
            result.setNrErrors(1L);
        }
        finally {
            try {
                if (xmlfile != null) {
                    xmlfile.close();
                }
                if (xsdfile != null) {
                    xsdfile.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public void setxsdFilename(String filename) {
        this.xsdfilename = filename;
    }

    public String getxsdFilename() {
        return this.xsdfilename;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.xsdfilename) && !Const.isEmpty((String)this.xmlfilename)) {
            String realXmlFileName = jobMeta.environmentSubstitute(this.xmlfilename);
            String realXsdFileName = jobMeta.environmentSubstitute(this.xsdfilename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "xsdFilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "xmlFilename", remarks, ctx);
    }
}

