/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionEntryInterface;

public class StepInjectionUtil {
    public static StepInjectionMetaEntry getEntry(StepMetaInjectionEntryInterface entryInterface) {
        return StepInjectionUtil.getEntry(entryInterface, null);
    }

    public static StepInjectionMetaEntry getEntry(StepMetaInjectionEntryInterface entryInterface, Object value) {
        StepInjectionMetaEntry entry = new StepInjectionMetaEntry(entryInterface.name(), entryInterface.getValueType(), entryInterface.getDescription());
        if (value == null) {
            return entry;
        }
        switch (entryInterface.getValueType()) {
            case 2: {
                if (value instanceof Boolean) {
                    entry.setValue((Boolean)value != false ? "Y" : "N");
                    break;
                }
                entry.setValue(value.toString());
                break;
            }
            case 5: {
                entry.setValue(Long.valueOf(value.toString()));
                break;
            }
            case 4: {
                entry.setValue("Y".equalsIgnoreCase(value.toString()) || "TRUE".equalsIgnoreCase(value.toString()));
                break;
            }
            case 0: {
                break;
            }
            default: {
                entry.setValue(value);
            }
        }
        return entry;
    }

    public static StepInjectionMetaEntry findEntry(List<StepInjectionMetaEntry> entries, StepMetaInjectionEntryInterface match) {
        return StepInjectionUtil.findEntry(entries, match.name());
    }

    public static StepInjectionMetaEntry findEntry(List<StepInjectionMetaEntry> entries, String key) {
        for (StepInjectionMetaEntry entry : entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public static void compareEntryValues(List<StepInjectionMetaEntry> refEntries, List<StepInjectionMetaEntry> cmpEntries) throws KettleException {
        if (refEntries.size() != cmpEntries.size()) {
            throw new KettleException("The number of reference entries (" + refEntries.size() + ") is not the same as the number of compare entries(" + cmpEntries.size() + ")");
        }
        for (int i = 0; i < refEntries.size(); ++i) {
            StepInjectionMetaEntry refEntry = refEntries.get(i);
            StepInjectionMetaEntry cmpEntry = cmpEntries.get(i);
            if (cmpEntry.getValueType() == 0) {
                StepInjectionUtil.compareEntryValues(refEntry.getDetails(), cmpEntry.getDetails());
                continue;
            }
            Object ref = refEntry.getValue();
            Object cmp = cmpEntry.getValue();
            if (ref != null && cmp == null) {
                throw new KettleException("Reference key '" + refEntry.getKey() + "': value is not null while the compare value is null");
            }
            if (ref == null && cmp != null) {
                throw new KettleException("Reference key '" + refEntry.getKey() + "': value is null while the compare value is not null");
            }
            if (ref == null || cmp == null || ref.equals(cmp)) continue;
            throw new KettleException("Reference key '" + refEntry.getKey() + "': reference value '" + ref + "' is not equal to '" + cmp + "'");
        }
    }
}

