/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.calculator.CalculatorData;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;

public class Calculator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CalculatorMeta.class;
    private CalculatorMeta meta;
    private CalculatorData data;

    public Calculator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CalculatorMeta)smi;
        this.data = (CalculatorData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            this.data.clearValuesMetaMapping();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            this.data.setOutputRowMeta(this.getInputRowMeta().clone());
            this.meta.getFields(this.data.getOutputRowMeta(), this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.setCalcRowMeta(this.meta.getAllFields(this.getInputRowMeta()));
            this.data.setFieldIndexes(new FieldIndexes[this.meta.getCalculation().length]);
            ArrayList<Integer> tempIndexes = new ArrayList<Integer>();
            for (i = 0; i < this.meta.getCalculation().length; ++i) {
                CalculatorMetaFunction function = this.meta.getCalculation()[i];
                this.data.getFieldIndexes()[i] = new FieldIndexes();
                if (!Const.isEmpty((String)function.getFieldName())) {
                    this.data.getFieldIndexes()[i].indexName = this.data.getCalcRowMeta().indexOfValue(function.getFieldName());
                    if (this.data.getFieldIndexes()[i].indexName < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Calculator.Error.UnableFindField", (String[])new String[]{function.getFieldName(), "" + (i + 1)}));
                    }
                } else {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"Calculator.Error.NoNameField", (String[])new String[]{"" + (i + 1)}));
                }
                if (!Const.isEmpty((String)function.getFieldA())) {
                    if (function.getCalcType() != 1) {
                        this.data.getFieldIndexes()[i].indexA = this.data.getCalcRowMeta().indexOfValue(function.getFieldA());
                        if (this.data.getFieldIndexes()[i].indexA < 0) {
                            throw new KettleStepException("Unable to find the first argument field '" + function.getFieldName() + " for calculation #" + (i + 1));
                        }
                    } else {
                        this.data.getFieldIndexes()[i].indexA = -1;
                    }
                } else {
                    throw new KettleStepException("There is no first argument specified for calculated field #" + (i + 1));
                }
                if (!Const.isEmpty((String)function.getFieldB())) {
                    this.data.getFieldIndexes()[i].indexB = this.data.getCalcRowMeta().indexOfValue(function.getFieldB());
                    if (this.data.getFieldIndexes()[i].indexB < 0) {
                        throw new KettleStepException("Unable to find the second argument field '" + function.getFieldName() + " for calculation #" + (i + 1));
                    }
                }
                this.data.getFieldIndexes()[i].indexC = -1;
                if (!Const.isEmpty((String)function.getFieldC())) {
                    this.data.getFieldIndexes()[i].indexC = this.data.getCalcRowMeta().indexOfValue(function.getFieldC());
                    if (this.data.getFieldIndexes()[i].indexC < 0) {
                        throw new KettleStepException("Unable to find the third argument field '" + function.getFieldName() + " for calculation #" + (i + 1));
                    }
                }
                if (!function.isRemovedFromResult()) continue;
                tempIndexes.add(this.getInputRowMeta().size() + i);
            }
            this.data.setTempIndexes(new int[tempIndexes.size()]);
            for (i = 0; i < this.data.getTempIndexes().length; ++i) {
                this.data.getTempIndexes()[i] = (Integer)tempIndexes.get(i);
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"Calculator.Log.ReadRow", (String[])new String[0]) + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] row = this.calcFields(this.getInputRowMeta(), r);
            this.putRow(this.data.getOutputRowMeta(), row);
            if (this.log.isRowLevel()) {
                this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"Calculator.Log.Linenr", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (KettleException e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.toString(), null, "CALC001");
            }
            this.logError(BaseMessages.getString(PKG, (String)("Calculator.ErrorInStepRunning : " + e.getMessage()), (String[])new String[0]));
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"Calculator.ErrorInStepRunning", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private Object[] calcFields(RowMetaInterface inputRowMeta, Object[] r) throws KettleValueException {
        Object[] calcData = RowDataUtil.resizeArray((Object[])r, (int)this.data.getCalcRowMeta().size());
        int i = 0;
        int index = inputRowMeta.size() + i;
        while (i < this.meta.getCalculation().length) {
            CalculatorMetaFunction fn = this.meta.getCalculation()[i];
            if (!Const.isEmpty((String)fn.getFieldName())) {
                ValueMetaInterface targetMeta = this.data.getCalcRowMeta().getValueMeta(index);
                ValueMetaInterface metaA = null;
                Object dataA = null;
                if (this.data.getFieldIndexes()[i].indexA >= 0) {
                    metaA = this.data.getCalcRowMeta().getValueMeta(this.data.getFieldIndexes()[i].indexA);
                    dataA = calcData[this.data.getFieldIndexes()[i].indexA];
                }
                ValueMetaInterface metaB = null;
                Object dataB = null;
                if (this.data.getFieldIndexes()[i].indexB >= 0) {
                    metaB = this.data.getCalcRowMeta().getValueMeta(this.data.getFieldIndexes()[i].indexB);
                    dataB = calcData[this.data.getFieldIndexes()[i].indexB];
                }
                ValueMetaInterface metaC = null;
                Object dataC = null;
                if (this.data.getFieldIndexes()[i].indexC >= 0) {
                    metaC = this.data.getCalcRowMeta().getValueMeta(this.data.getFieldIndexes()[i].indexC);
                    dataC = calcData[this.data.getFieldIndexes()[i].indexC];
                }
                int calcType = fn.getCalcType();
                int resultType = metaA != null ? metaA.getType() : 0;
                switch (calcType) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        calcData[index] = dataA;
                        break;
                    }
                    case 3: {
                        calcData[index] = ValueDataUtil.plus((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        if (!metaA.isString() && !metaB.isString()) break;
                        resultType = 2;
                        break;
                    }
                    case 4: {
                        calcData[index] = ValueDataUtil.minus((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        if (!metaA.isDate()) break;
                        resultType = 5;
                        break;
                    }
                    case 5: {
                        calcData[index] = ValueDataUtil.multiply((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        if (!metaA.isString() && !metaB.isString()) break;
                        resultType = 2;
                        break;
                    }
                    case 6: {
                        calcData[index] = ValueDataUtil.divide((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 7: {
                        calcData[index] = ValueDataUtil.multiply((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 8: {
                        calcData[index] = ValueDataUtil.sqrt((ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 9: {
                        calcData[index] = ValueDataUtil.percent1((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 10: {
                        calcData[index] = ValueDataUtil.percent2((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 11: {
                        calcData[index] = ValueDataUtil.percent3((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 12: {
                        calcData[index] = ValueDataUtil.combination1((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (ValueMetaInterface)metaC, dataC);
                        break;
                    }
                    case 13: {
                        calcData[index] = ValueDataUtil.combination2((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 14: {
                        calcData[index] = ValueDataUtil.round((ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 15: {
                        calcData[index] = ValueDataUtil.round((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 16: {
                        calcData[index] = ValueDataUtil.round((ValueMetaInterface)metaA, (Object)dataA, (int)4);
                        break;
                    }
                    case 17: {
                        calcData[index] = ValueDataUtil.round((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (int)4);
                        break;
                    }
                    case 18: {
                        calcData[index] = ValueDataUtil.ceil((ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 19: {
                        calcData[index] = ValueDataUtil.floor((ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 1: {
                        calcData[index] = fn.getFieldA();
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 20: {
                        calcData[index] = ValueDataUtil.nvl((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        break;
                    }
                    case 21: {
                        calcData[index] = ValueDataUtil.addDays((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 76: {
                        calcData[index] = ValueDataUtil.addHours((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 77: {
                        calcData[index] = ValueDataUtil.addMinutes((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 22: {
                        calcData[index] = ValueDataUtil.yearOfDate((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 23: {
                        calcData[index] = ValueDataUtil.monthOfDate((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 24: {
                        calcData[index] = ValueDataUtil.dayOfYear((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 25: {
                        calcData[index] = ValueDataUtil.dayOfMonth((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 26: {
                        calcData[index] = ValueDataUtil.dayOfWeek((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 27: {
                        calcData[index] = ValueDataUtil.weekOfYear((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 28: {
                        calcData[index] = ValueDataUtil.weekOfYearISO8601((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 29: {
                        calcData[index] = ValueDataUtil.yearOfDateISO8601((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 30: {
                        calcData[index] = ValueDataUtil.byteToHexEncode((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 31: {
                        calcData[index] = ValueDataUtil.hexToByteDecode((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 32: {
                        calcData[index] = ValueDataUtil.charToHexEncode((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 33: {
                        calcData[index] = ValueDataUtil.hexToCharDecode((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 34: {
                        calcData[index] = ValueDataUtil.ChecksumCRC32((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 35: {
                        calcData[index] = ValueDataUtil.ChecksumAdler32((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 36: {
                        calcData[index] = ValueDataUtil.createChecksum((ValueMetaInterface)metaA, (Object)dataA, (String)"MD5");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 37: {
                        calcData[index] = ValueDataUtil.createChecksum((ValueMetaInterface)metaA, (Object)dataA, (String)"SHA-1");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 38: {
                        calcData[index] = ValueDataUtil.getLevenshtein_Distance((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 39: {
                        calcData[index] = ValueDataUtil.get_Metaphone((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 40: {
                        calcData[index] = ValueDataUtil.get_Double_Metaphone((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 41: {
                        calcData[index] = ValueDataUtil.abs((ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 42: {
                        calcData[index] = ValueDataUtil.removeTimeFromDate((ValueMetaInterface)metaA, (Object)dataA);
                        break;
                    }
                    case 43: {
                        calcData[index] = ValueDataUtil.DateDiff((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (String)"d");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 44: {
                        calcData[index] = ValueDataUtil.plus3((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (ValueMetaInterface)metaC, dataC);
                        if (!metaA.isString() && !metaB.isString() && !metaC.isString()) break;
                        resultType = 2;
                        break;
                    }
                    case 45: {
                        calcData[index] = ValueDataUtil.initCap((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 46: {
                        calcData[index] = ValueDataUtil.upperCase((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 47: {
                        calcData[index] = ValueDataUtil.lowerCase((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 48: {
                        calcData[index] = ValueDataUtil.escapeXML((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 49: {
                        calcData[index] = ValueDataUtil.useCDATA((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 50: {
                        calcData[index] = ValueDataUtil.removeCR((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 51: {
                        calcData[index] = ValueDataUtil.removeLF((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 52: {
                        calcData[index] = ValueDataUtil.removeCRLF((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 53: {
                        calcData[index] = ValueDataUtil.removeTAB((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 54: {
                        calcData[index] = ValueDataUtil.getDigits((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 55: {
                        calcData[index] = ValueDataUtil.removeDigits((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 56: {
                        calcData[index] = ValueDataUtil.stringLen((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 57: {
                        calcData[index] = ValueDataUtil.loadFileContentInBinary((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 58: {
                        calcData[index] = ValueDataUtil.addTimeToDate((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (ValueMetaInterface)metaC, dataC);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 59: {
                        calcData[index] = ValueDataUtil.quarterOfDate((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 60: {
                        calcData[index] = this.environmentSubstitute(dataA.toString());
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 61: {
                        calcData[index] = ValueDataUtil.unEscapeXML((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 62: {
                        calcData[index] = ValueDataUtil.escapeHTML((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 63: {
                        calcData[index] = ValueDataUtil.unEscapeHTML((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 64: {
                        calcData[index] = ValueDataUtil.escapeSQL((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 65: {
                        calcData[index] = ValueDataUtil.DateWorkingDiff((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 66: {
                        calcData[index] = ValueDataUtil.addMonths((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 67: {
                        calcData[index] = ValueDataUtil.isXMLFileWellFormed((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 68: {
                        calcData[index] = ValueDataUtil.isXMLWellFormed((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 69: {
                        calcData[index] = ValueDataUtil.getFileEncoding((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 70: {
                        calcData[index] = ValueDataUtil.getDamerauLevenshtein_Distance((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 71: {
                        calcData[index] = ValueDataUtil.getNeedlemanWunsch_Distance((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 72: {
                        calcData[index] = ValueDataUtil.getJaro_Similitude((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 73: {
                        calcData[index] = ValueDataUtil.getJaroWinkler_Similitude((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 74: {
                        calcData[index] = ValueDataUtil.get_SoundEx((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 75: {
                        calcData[index] = ValueDataUtil.get_RefinedSoundEx((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 78: {
                        calcData[index] = ValueDataUtil.DateDiff((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (String)"ms");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 79: {
                        calcData[index] = ValueDataUtil.DateDiff((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (String)"s");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 80: {
                        calcData[index] = ValueDataUtil.DateDiff((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (String)"mn");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 81: {
                        calcData[index] = ValueDataUtil.DateDiff((ValueMetaInterface)metaA, (Object)dataA, (ValueMetaInterface)metaB, (Object)dataB, (String)"h");
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 82: {
                        calcData[index] = ValueDataUtil.hourOfDay((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 83: {
                        calcData[index] = ValueDataUtil.minuteOfHour((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    case 84: {
                        calcData[index] = ValueDataUtil.secondOfMinute((ValueMetaInterface)metaA, (Object)dataA);
                        resultType = CalculatorMetaFunction.calcDefaultResultType[calcType];
                        break;
                    }
                    default: {
                        throw new KettleValueException(BaseMessages.getString(PKG, (String)"Calculator.Log.UnknownCalculationType", (String[])new String[0]) + fn.getCalcType());
                    }
                }
                if (targetMeta.getType() == 0) {
                    throw new KettleValueException(BaseMessages.getString(PKG, (String)"Calculator.Log.NoType", (String[])new String[0]) + (i + 1) + " : " + fn.getFieldName() + " = " + fn.getCalcTypeDesc() + " / " + fn.getCalcTypeLongDesc());
                }
                if (calcData[index] != null && targetMeta.getType() != resultType) {
                    ValueMetaInterface resultMeta;
                    try {
                        resultMeta = this.data.getValueMetaFor(resultType, "result");
                    }
                    catch (Exception exception) {
                        throw new KettleValueException("Error creating value");
                    }
                    resultMeta.setConversionMask(fn.getConversionMask());
                    resultMeta.setGroupingSymbol(fn.getGroupingSymbol());
                    resultMeta.setDecimalSymbol(fn.getDecimalSymbol());
                    resultMeta.setCurrencySymbol(fn.getCurrencySymbol());
                    try {
                        calcData[index] = targetMeta.convertData(resultMeta, calcData[index]);
                    }
                    catch (Exception ex) {
                        throw new KettleValueException("resultType: " + resultType + "; targetMeta: " + targetMeta.getType(), (Throwable)ex);
                    }
                }
            }
            ++i;
            ++index;
        }
        return RowDataUtil.removeItems((Object[])calcData, (int[])this.data.getTempIndexes());
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CalculatorMeta)smi;
        this.data = (CalculatorData)sdi;
        return super.init(smi, sdi);
    }

    public class FieldIndexes {
        public int indexName;
        public int indexA;
        public int indexB;
        public int indexC;
    }
}

