/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.combinationlookup;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseInterfaceExtended;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupData;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupMeta;

public class CombinationLookup
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CombinationLookupMeta.class;
    private static final int CREATION_METHOD_AUTOINC = 1;
    private static final int CREATION_METHOD_SEQUENCE = 2;
    private static final int CREATION_METHOD_TABLEMAX = 3;
    private int techKeyCreation;
    private CombinationLookupMeta meta = (CombinationLookupMeta)this.getStepMeta().getStepMetaInterface();
    private CombinationLookupData data;

    public CombinationLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (CombinationLookupData)stepDataInterface;
    }

    private void setTechKeyCreation(int method) {
        this.techKeyCreation = method;
    }

    private int getTechKeyCreation() {
        return this.techKeyCreation;
    }

    private void determineTechKeyCreation() {
        String keyCreation = this.meta.getTechKeyCreation();
        if (this.meta.getDatabaseMeta().supportsAutoinc() && CombinationLookupMeta.CREATION_METHOD_AUTOINC.equals(keyCreation)) {
            this.setTechKeyCreation(1);
        } else if (this.meta.getDatabaseMeta().supportsSequences() && CombinationLookupMeta.CREATION_METHOD_SEQUENCE.equals(keyCreation)) {
            this.setTechKeyCreation(2);
        } else {
            this.setTechKeyCreation(3);
        }
    }

    private Long lookupInCache(RowMetaInterface rowMeta, Object[] row) {
        if (this.meta.getCacheSize() == -1) {
            return null;
        }
        Long tk = this.data.cache.get(new RowMetaAndData(rowMeta, row));
        return tk;
    }

    private void addToCache(RowMetaInterface rowMeta, Object[] row, Long tk) throws KettleValueException {
        if (this.meta.getCacheSize() == -1) {
            return;
        }
        this.data.cache.put(new RowMetaAndData(rowMeta, row), tk);
        int tenPercent = this.meta.getCacheSize() / 10;
        if (this.meta.getCacheSize() > 0 && this.data.cache.size() > this.meta.getCacheSize() + tenPercent) {
            Long value;
            RowMetaAndData key;
            int i;
            ArrayList<RowMetaAndData> keys = new ArrayList<RowMetaAndData>(this.data.cache.keySet());
            int sizeBefore = keys.size();
            ArrayList<Long> samples = new ArrayList<Long>();
            int stepsize = keys.size() / 5;
            if (stepsize < 1) {
                stepsize = 1;
            }
            for (i = 0; i < keys.size(); i += stepsize) {
                key = (RowMetaAndData)keys.get(i);
                value = this.data.cache.get(key);
                if (value == null) continue;
                samples.add(value);
            }
            Collections.sort(samples);
            this.data.smallestCacheKey = samples.size() > 1 ? ((Long)samples.get(1)).longValue() : ((Long)samples.get(0)).longValue();
            for (i = 0; i < keys.size(); ++i) {
                key = (RowMetaAndData)keys.get(i);
                value = this.data.cache.get(key);
                if (value == null || value > this.data.smallestCacheKey) continue;
                this.data.cache.remove(key);
            }
            int sizeAfter = this.data.cache.size();
            this.logDetailed("Reduced the lookup cache from " + sizeBefore + " to " + sizeAfter + " rows.");
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Cache store: key=" + rowMeta.getString(row) + "    key=" + tk);
        }
    }

    protected boolean isAutoIncrement() {
        return this.techKeyCreation == 1;
    }

    private Object[] lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        int i;
        Long val_key = null;
        Long val_hash = null;
        Object[] hashRow = null;
        Object[] lookupRow = new Object[this.data.lookupRowMeta.size()];
        int lookupIndex = 0;
        if (this.meta.useHash() || this.meta.getCacheSize() >= 0) {
            hashRow = new Object[this.data.hashRowMeta.size()];
            for (i = 0; i < this.meta.getKeyField().length; ++i) {
                hashRow[i] = row[this.data.keynrs[i]];
            }
            if (this.meta.useHash()) {
                val_hash = new Long(this.data.hashRowMeta.oldXORHashCode(hashRow));
                lookupRow[lookupIndex] = val_hash;
                ++lookupIndex;
            }
        }
        for (i = 0; i < this.meta.getKeyField().length; ++i) {
            int rowIndex = this.data.keynrs[i];
            lookupRow[lookupIndex] = row[rowIndex];
            lookupRow[++lookupIndex] = this.meta.getDatabaseMeta().requiresCastToVariousForIsNull() && rowMeta.getValueMeta(rowIndex).getType() == 2 ? (rowMeta.getValueMeta(rowIndex).isNull(row[rowIndex]) ? null : "NotNull") : row[this.data.keynrs[i]];
            ++lookupIndex;
        }
        val_key = this.lookupInCache(this.data.hashRowMeta, hashRow);
        if (val_key == null) {
            this.data.db.setValues(this.data.lookupRowMeta, lookupRow, this.data.prepStatementLookup);
            Object[] add = this.data.db.getLookup(this.data.prepStatementLookup);
            this.incrementLinesInput();
            if (add == null) {
                switch (this.getTechKeyCreation()) {
                    case 3: {
                        val_key = this.data.db.getNextValue(this.getTransMeta().getCounters(), this.data.realSchemaName, this.data.realTableName, this.meta.getTechnicalKeyField());
                        break;
                    }
                    case 1: {
                        val_key = new Long(0L);
                        break;
                    }
                    case 2: {
                        val_key = this.data.db.getNextSequenceValue(this.data.realSchemaName, this.meta.getSequenceFrom(), this.meta.getTechnicalKeyField());
                        if (val_key == null || !this.isRowLevel()) break;
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.FoundNextSequenceValue", (String[])new String[0]) + val_key.toString());
                        break;
                    }
                }
                val_key = this.combiInsert(rowMeta, row, val_key, val_hash);
                this.incrementLinesOutput();
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.AddedDimensionEntry", (String[])new String[0]) + val_key);
                }
                this.addToCache(this.data.hashRowMeta, hashRow, val_key);
            } else {
                val_key = this.data.db.getReturnRowMeta().getInteger(add, 0);
                this.addToCache(this.data.hashRowMeta, hashRow, val_key);
            }
        }
        Object[] outputRow = new Object[this.data.outputRowMeta.size()];
        int outputIndex = 0;
        if (this.meta.replaceFields()) {
            for (int i2 = 0; i2 < rowMeta.size(); ++i2) {
                if (this.data.removeField[i2]) continue;
                outputRow[outputIndex] = row[i2];
                ++outputIndex;
            }
        } else {
            for (outputIndex = 0; outputIndex < rowMeta.size(); ++outputIndex) {
                outputRow[outputIndex] = row[outputIndex];
            }
        }
        outputRow[outputIndex] = val_key;
        return outputRow;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.realSchemaName, this.data.realTableName);
            this.determineTechKeyCreation();
            this.data.keynrs = new int[this.meta.getKeyField().length];
            for (i = 0; i < this.meta.getKeyField().length; ++i) {
                this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyField()[i]);
                if (this.data.keynrs[i] >= 0) continue;
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"CombinationLookup.Exception.FieldNotFound", (String[])new String[]{this.meta.getKeyField()[i]}));
            }
            this.data.removeField = new boolean[this.getInputRowMeta().size()];
            for (i = 0; i < this.getInputRowMeta().size(); ++i) {
                ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(i);
                int idx = Const.indexOfString((String)valueMeta.getName(), (String[])this.meta.getKeyField());
                this.data.removeField[i] = idx >= 0;
            }
            this.data.hashRowMeta = new RowMeta();
            for (i = 0; i < this.meta.getKeyField().length; ++i) {
                this.data.hashRowMeta.addValueMeta(this.getInputRowMeta().getValueMeta(this.data.keynrs[i]));
            }
            this.setCombiLookup(this.getInputRowMeta());
            this.preloadCache(this.data.hashRowMeta);
        }
        try {
            Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
            this.putRow(this.data.outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, Const.getStackTracker((Throwable)e), null, "CBL001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public void setCombiLookup(RowMetaInterface inputRowMeta) throws KettleDatabaseException {
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        String sql = "";
        this.data.lookupRowMeta = new RowMeta();
        sql = sql + "SELECT " + databaseMeta.quoteField(this.meta.getTechnicalKeyField()) + Const.CR;
        sql = sql + "FROM " + this.data.schemaTable + Const.CR;
        sql = sql + "WHERE ";
        boolean comma = false;
        if (this.meta.useHash()) {
            sql = sql + databaseMeta.quoteField(this.meta.getHashField()) + " = ? " + Const.CR;
            comma = true;
            this.data.lookupRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getHashField(), 5));
        } else {
            sql = sql + "( ( ";
        }
        for (int i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (comma) {
                sql = sql + " AND ( ( ";
            } else {
                comma = true;
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ? ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            this.data.lookupRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.keynrs[i]));
            sql = sql + " IS NULL AND ";
            sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
            this.data.lookupRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.keynrs[i]).clone());
            sql = sql + " ) )";
            sql = sql + Const.CR;
        }
        try {
            if (this.log.isDebug()) {
                this.logDebug("preparing combi-lookup statement:" + Const.CR + sql);
            }
            this.data.prepStatementLookup = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
            if (databaseMeta.supportsSetMaxRows()) {
                this.data.prepStatementLookup.setMaxRows(1);
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare combi-lookup statement", (Throwable)ex);
        }
    }

    public Long combiInsert(RowMetaInterface rowMeta, Object[] row, Long val_key, Long val_crc) throws KettleDatabaseException {
        block41: {
            String debug = "Combination insert";
            DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
            try {
                boolean supportsAutoGeneratedKeys;
                if (this.data.prepStatementInsert == null) {
                    int i;
                    debug = "First: construct prepared statement";
                    this.data.insertRowMeta = new RowMeta();
                    String sql = "";
                    sql = sql + "INSERT INTO " + this.data.schemaTable + "( ";
                    boolean comma = false;
                    if (!this.isAutoIncrement()) {
                        sql = sql + databaseMeta.quoteField(this.meta.getTechnicalKeyField());
                        this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getTechnicalKeyField(), 5));
                        comma = true;
                    } else if (databaseMeta.needsPlaceHolder()) {
                        sql = sql + "0";
                        this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getTechnicalKeyField(), 5));
                        comma = true;
                    }
                    if (this.meta.useHash()) {
                        if (comma) {
                            sql = sql + ", ";
                        }
                        sql = sql + databaseMeta.quoteField(this.meta.getHashField());
                        this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getHashField(), 5));
                        comma = true;
                    }
                    if (!Const.isEmpty((String)this.meta.getLastUpdateField())) {
                        if (comma) {
                            sql = sql + ", ";
                        }
                        sql = sql + databaseMeta.quoteField(this.meta.getLastUpdateField());
                        this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getLastUpdateField(), 3));
                        comma = true;
                    }
                    for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                        if (comma) {
                            sql = sql + ", ";
                        }
                        sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
                        this.data.insertRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.keynrs[i]));
                        comma = true;
                    }
                    sql = sql + ") VALUES (";
                    comma = false;
                    if (!this.isAutoIncrement()) {
                        sql = sql + '?';
                        comma = true;
                    }
                    if (this.meta.useHash()) {
                        if (comma) {
                            sql = sql + ',';
                        }
                        sql = sql + '?';
                        comma = true;
                    }
                    if (!Const.isEmpty((String)this.meta.getLastUpdateField())) {
                        if (comma) {
                            sql = sql + ',';
                        }
                        sql = sql + '?';
                        comma = true;
                    }
                    for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                        if (comma) {
                            sql = sql + ',';
                        } else {
                            comma = true;
                        }
                        sql = sql + '?';
                    }
                    String sqlStatement = sql = sql + " )";
                    try {
                        boolean supportsAutoGeneratedKeys2;
                        debug = "First: prepare statement";
                        DatabaseInterface databaseInterface = this.meta.getDatabaseMeta().getDatabaseInterface();
                        boolean bl = supportsAutoGeneratedKeys2 = !(databaseInterface instanceof DatabaseInterfaceExtended) || ((DatabaseInterfaceExtended)databaseInterface).supportsAutoGeneratedKeys();
                        if (this.isAutoIncrement() && supportsAutoGeneratedKeys2) {
                            this.logDetailed("SQL with return keys: " + sqlStatement);
                            this.data.prepStatementInsert = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sqlStatement), 1);
                        } else {
                            this.logDetailed("SQL without return keys: " + sqlStatement);
                            this.data.prepStatementInsert = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sqlStatement));
                        }
                    }
                    catch (SQLException ex) {
                        throw new KettleDatabaseException("Unable to prepare combi insert statement : " + Const.CR + sqlStatement, (Throwable)ex);
                    }
                    catch (Exception ex) {
                        throw new KettleDatabaseException("Unable to prepare combi insert statement : " + Const.CR + sqlStatement, (Throwable)ex);
                    }
                }
                debug = "Create new insert row rins";
                Object[] insertRow = new Object[this.data.insertRowMeta.size()];
                int insertIndex = 0;
                if (!this.isAutoIncrement()) {
                    insertRow[insertIndex] = val_key;
                    ++insertIndex;
                }
                if (this.meta.useHash()) {
                    insertRow[insertIndex] = val_crc;
                    ++insertIndex;
                }
                if (!Const.isEmpty((String)this.meta.getLastUpdateField())) {
                    insertRow[insertIndex] = new Date();
                    ++insertIndex;
                }
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    insertRow[insertIndex] = row[this.data.keynrs[i]];
                    ++insertIndex;
                }
                if (this.isRowLevel()) {
                    this.logRowlevel("rins=" + this.data.insertRowMeta.getString(insertRow));
                }
                debug = "Set values on insert";
                this.data.db.setValues(this.data.insertRowMeta, insertRow, this.data.prepStatementInsert);
                debug = "Insert row";
                this.data.db.insertRow(this.data.prepStatementInsert);
                debug = "Retrieve key";
                DatabaseInterface databaseInterface = this.meta.getDatabaseMeta().getDatabaseInterface();
                boolean bl = supportsAutoGeneratedKeys = !(databaseInterface instanceof DatabaseInterfaceExtended) || ((DatabaseInterfaceExtended)databaseInterface).supportsAutoGeneratedKeys();
                if (!this.isAutoIncrement() || !supportsAutoGeneratedKeys) break block41;
                ResultSet keys = null;
                try {
                    keys = this.data.prepStatementInsert.getGeneratedKeys();
                    if (keys.next()) {
                        val_key = new Long(keys.getLong(1));
                        break block41;
                    }
                    throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField() + ", no fields in resultset");
                }
                catch (SQLException ex) {
                    throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField(), (Throwable)ex);
                }
                finally {
                    try {
                        if (keys != null) {
                            keys.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField(), (Throwable)ex);
                    }
                }
            }
            catch (Exception e) {
                this.logError(Const.getStackTracker((Throwable)e));
                throw new KettleDatabaseException("Unexpected error in combination insert in part [" + debug + "] : " + e.toString(), (Throwable)e);
            }
        }
        return val_key;
    }

    @Override
    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface sii, StepDataInterface sdi) {
        if (super.init(sii, sdi)) {
            this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
            this.data.realTableName = this.environmentSubstitute(this.meta.getTablename());
            this.data.cache = this.meta.getCacheSize() > 0 ? new HashMap<RowMetaAndData, Long>((int)((double)this.meta.getCacheSize() * 1.5)) : new HashMap<RowMetaAndData, Long>();
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.UnableToConnectDB", (String[])new String[0]) + dbe.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CombinationLookupMeta)smi;
        this.data = (CombinationLookupData)sdi;
        if (this.data.db != null) {
            try {
                if (!this.data.db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.db.commit();
                    } else {
                        this.data.db.rollback();
                    }
                }
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.UnexpectedError", (String[])new String[0]) + " : " + e.toString());
            }
            finally {
                this.data.db.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }

    private void preloadCache(RowMetaInterface hashRowMeta) throws KettleDatabaseException, KettleValueException, KettleConfigException {
        if (this.meta.getPreloadCache() && this.meta.getCacheSize() >= 0) {
            if (hashRowMeta == null) {
                throw new KettleConfigException(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.UnexpectedError", (String[])new String[0]));
            }
            DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
            if (databaseMeta == null) {
                throw new KettleConfigException(BaseMessages.getString(PKG, (String)"CombinationLookup.Log.UnexpectedError", (String[])new String[0]));
            }
            String lookupKeys = "";
            String sql = "";
            for (int i = 0; i < this.meta.getKeyLookup().length; ++i) {
                lookupKeys = lookupKeys + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
                if (i >= this.meta.getKeyLookup().length - 1) continue;
                lookupKeys = lookupKeys + "," + Const.CR;
            }
            sql = sql + "SELECT " + Const.CR;
            sql = sql + "MIN(" + databaseMeta.quoteField(this.meta.getTechnicalKeyField()) + ") as " + databaseMeta.quoteField(this.meta.getTechnicalKeyField()) + "," + Const.CR;
            sql = sql + lookupKeys + Const.CR;
            sql = sql + "FROM " + this.data.schemaTable + Const.CR;
            sql = sql + "GROUP BY" + Const.CR;
            sql = sql + lookupKeys + Const.CR;
            if (this.log.isDebug()) {
                this.logDebug("Using preload cache statement:" + Const.CR + sql);
            }
            List cacheValues = this.data.db.getRows(databaseMeta.stripCR(sql), this.meta.getCacheSize());
            for (Object[] cacheRow : cacheValues) {
                Object[] hashRow = new Object[this.data.hashRowMeta.size()];
                System.arraycopy(cacheRow, 1, hashRow, 0, hashRow.length);
                this.addToCache(hashRowMeta, hashRow, (Long)cacheRow[0]);
                this.incrementLinesInput();
            }
        }
    }
}

