/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cubeinput;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cubeinput.CubeInputData;
import org.pentaho.di.trans.steps.cubeinput.CubeInputMeta;

public class CubeInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CubeInputMeta.class;
    private CubeInputMeta meta;
    private CubeInputData data;

    public CubeInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (CubeInputMeta)smi;
        this.data = (CubeInputData)sdi;
        try {
            Object[] r = this.data.meta.readData(this.data.dis);
            this.putRow(this.data.meta, r);
            this.incrementLinesInput();
            if (this.meta.getRowLimit() > 0 && this.getLinesInput() >= (long)this.meta.getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (KettleEOFException eof) {
            this.setOutputDone();
            return false;
        }
        catch (SocketTimeoutException e) {
            throw new KettleException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"CubeInput.Log.LineNumber", (String[])new String[0]) + this.getLinesInput());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CubeInputMeta)smi;
        this.data = (CubeInputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                String filename = this.environmentSubstitute(this.meta.getFilename());
                if (this.meta.isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.toString());
                    resultFile.setComment("File was read by a Cube Input step");
                    this.addResultFile(resultFile);
                }
                this.data.fis = KettleVFS.getInputStream((String)filename, (VariableSpace)this);
                this.data.zip = new GZIPInputStream(this.data.fis);
                this.data.dis = new DataInputStream(this.data.zip);
                try {
                    this.data.meta = new RowMeta(this.data.dis);
                    return true;
                }
                catch (KettleFileException kfe) {
                    this.logError(BaseMessages.getString(PKG, (String)"CubeInput.Log.UnableToReadMetadata", (String[])new String[0]), kfe);
                    return false;
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"CubeInput.Log.ErrorReadingFromDataCube", (String[])new String[0]), e);
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CubeInputMeta)smi;
        this.data = (CubeInputData)sdi;
        try {
            if (this.data.dis != null) {
                this.data.dis.close();
                this.data.dis = null;
            }
            if (this.data.zip != null) {
                this.data.zip.close();
                this.data.zip = null;
            }
            if (this.data.fis != null) {
                this.data.fis.close();
                this.data.fis = null;
            }
        }
        catch (IOException e) {
            this.logError(BaseMessages.getString(PKG, (String)"CubeInput.Log.ErrorClosingCube", (String[])new String[0]) + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        super.dispose(smi, sdi);
    }
}

