/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.staxpoi;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxPoiCell;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxUtil;

public class StaxPoiSheet
implements KSheet {
    private String sheetName;
    private InputStream sheetStream;
    private XMLStreamReader sheetReader;
    private int currentRow;
    private List<String> headerRow;
    private int numRows;
    private int numCols;
    private SharedStringsTable sst;

    public StaxPoiSheet(XSSFReader reader, String sheetName, String sheetID) {
        block7: {
            this.sheetName = sheetName;
            try {
                this.sst = reader.getSharedStringsTable();
                this.sheetStream = reader.getSheet(sheetID);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                this.sheetReader = factory.createXMLStreamReader(this.sheetStream);
                this.headerRow = new ArrayList<String>();
                while (this.sheetReader.hasNext()) {
                    int event = this.sheetReader.next();
                    if (event == 1 && this.sheetReader.getLocalName().equals("dimension")) {
                        String dim = this.sheetReader.getAttributeValue(null, "ref").split(":")[1];
                        this.numRows = StaxUtil.extractRowNumber(dim);
                        this.numCols = StaxUtil.extractColumnNumber(dim);
                    }
                    if (event != 1 || !this.sheetReader.getLocalName().equals("row")) continue;
                    this.currentRow = Integer.parseInt(this.sheetReader.getAttributeValue(null, "r"));
                    block3: while (this.sheetReader.hasNext() && ((event = this.sheetReader.next()) != 2 || !this.sheetReader.getLocalName().equals("row"))) {
                        if (event != 1 || !this.sheetReader.getLocalName().equals("c")) continue;
                        String attributeValue = this.sheetReader.getAttributeValue(null, "t");
                        if (attributeValue != null && attributeValue.equals("s")) {
                            while (this.sheetReader.hasNext()) {
                                event = this.sheetReader.next();
                                if (event != 1 || !this.sheetReader.getLocalName().equals("v")) continue;
                                int idx = Integer.parseInt(this.sheetReader.getElementText());
                                String content = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                                this.headerRow.add(content);
                                continue block3;
                            }
                            continue;
                        }
                        break block7;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public KCell[] getRow(int rownr) {
        ++rownr;
        try {
            while (this.sheetReader.hasNext()) {
                int event = this.sheetReader.next();
                if (event != 1 || !this.sheetReader.getLocalName().equals("row")) continue;
                String rowIndicator = this.sheetReader.getAttributeValue(null, "r");
                this.currentRow = Integer.parseInt(rowIndicator);
                if (this.currentRow < rownr) continue;
                KCell[] cells = new StaxPoiCell[this.numCols];
                for (int i = 0; i < this.numCols; ++i) {
                    while (this.sheetReader.hasNext() && (event != 1 || !this.sheetReader.getLocalName().equals("c"))) {
                        event = this.sheetReader.next();
                    }
                    String cellLocation = this.sheetReader.getAttributeValue(null, "r");
                    int columnIndex = StaxUtil.extractColumnNumber(cellLocation) - 1;
                    String cellType = this.sheetReader.getAttributeValue(null, "t");
                    while (this.sheetReader.hasNext() && ((event = this.sheetReader.next()) != 1 || !this.sheetReader.getLocalName().equals("v"))) {
                        if (event != 2 || !this.sheetReader.getLocalName().equals("c")) continue;
                        this.numRows = this.currentRow;
                        return new KCell[0];
                    }
                    String content = null;
                    if (cellType != null && cellType.equals("s")) {
                        int idx = Integer.parseInt(this.sheetReader.getElementText());
                        content = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                    } else {
                        content = this.sheetReader.getElementText();
                    }
                    cells[columnIndex] = new StaxPoiCell(content, this.currentRow);
                }
                return cells;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.numRows = this.currentRow;
        return new KCell[0];
    }

    public String getName() {
        return this.sheetName;
    }

    public int getRows() {
        return this.numRows;
    }

    public KCell getCell(int colnr, int rownr) {
        if (rownr == 0 && colnr < this.numCols) {
            return new StaxPoiCell(this.headerRow.get(colnr), rownr);
        }
        return null;
    }

    public void close() throws IOException, XMLStreamException {
        this.sheetStream.close();
        this.sheetReader.close();
    }
}

