/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.staxpoi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxPoiSheet;

public class StaxPoiWorkbook
implements KWorkbook {
    private XSSFReader reader;
    private Map<String, String> sheetNameIDMap;
    private Map<String, StaxPoiSheet> openSheetsMap = new HashMap<String, StaxPoiSheet>();

    public StaxPoiWorkbook() {
    }

    public StaxPoiWorkbook(String filename, String encoding) throws KettleException {
        this();
        try {
            OPCPackage pkg = OPCPackage.open((String)filename);
            this.openFile(pkg, encoding);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public StaxPoiWorkbook(InputStream inputStream, String encoding) throws KettleException {
        this();
        try {
            OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
            this.openFile(pkg, encoding);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void openFile(OPCPackage pkg, String encoding) throws KettleException {
        try {
            this.reader = new XSSFReader(pkg);
            this.sheetNameIDMap = new HashMap<String, String>();
            ArrayList<String> sheetList = new ArrayList<String>();
            InputStream workbookData = this.reader.getWorkbookData();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader workbookReader = factory.createXMLStreamReader(workbookData);
            while (workbookReader.hasNext()) {
                if (workbookReader.next() != 1 || !workbookReader.getLocalName().equals("sheet")) continue;
                String sheetName = workbookReader.getAttributeValue(null, "name");
                String sheetID = workbookReader.getAttributeValue("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id");
                sheetList.add(sheetName);
                this.sheetNameIDMap.put(sheetName, sheetID);
            }
            workbookData.close();
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public KSheet getSheet(String sheetName) {
        String sheetID = this.sheetNameIDMap.get(sheetName);
        StaxPoiSheet sheet = this.openSheetsMap.get(sheetID);
        if (this.openSheetsMap.get(sheetID) == null) {
            sheet = new StaxPoiSheet(this.reader, sheetName, sheetID);
            this.openSheetsMap.put(sheetID, sheet);
        }
        return sheet;
    }

    public String[] getSheetNames() {
        String[] sheets = new String[this.sheetNameIDMap.size()];
        return this.sheetNameIDMap.keySet().toArray(sheets);
    }

    public void close() {
        for (StaxPoiSheet sheet : this.openSheetsMap.values()) {
            try {
                sheet.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getNumberOfSheets() {
        return this.sheetNameIDMap.size();
    }

    public KSheet getSheet(int sheetNr) {
        for (Map.Entry<String, String> entry : this.sheetNameIDMap.entrySet()) {
            String sheetName = entry.getKey();
            String sheetID = entry.getValue();
            if (!sheetID.endsWith(Integer.toString(sheetNr + 1))) continue;
            return this.getSheet(sheetName);
        }
        return null;
    }

    public String getSheetName(int sheetNr) {
        for (Map.Entry<String, String> entry : this.sheetNameIDMap.entrySet()) {
            String sheetName = entry.getKey();
            String sheetID = entry.getValue();
            if (!sheetID.endsWith(Integer.toString(sheetNr))) continue;
            return sheetName;
        }
        return null;
    }
}

