/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getfilenames;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getfilenames.GetFileNames;
import org.pentaho.di.trans.steps.getfilenames.GetFileNamesData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class GetFileNamesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetFileNamesMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private FileInputList.FileTypeFilter fileTypeFilter;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String dynamicFilenameField;
    private String dynamicWildcardField;
    private String dynamicExcludeWildcardField;
    private boolean filefield;
    private boolean dynamicIncludeSubFolders;
    private boolean isaddresult;
    private long rowLimit;
    private boolean doNotFailIfNoFile;

    public boolean isdoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    public void setdoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public void setDynamicWildcardField(String dynamicWildcardField) {
        this.dynamicWildcardField = dynamicWildcardField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public String getDynamicWildcardField() {
        return this.dynamicWildcardField;
    }

    public String getDynamicExcludeWildcardField() {
        return this.dynamicExcludeWildcardField;
    }

    public void setDynamicExcludeWildcardField(String dynamicExcludeWildcardField) {
        this.dynamicExcludeWildcardField = dynamicExcludeWildcardField;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public boolean isDynamicIncludeSubFolders() {
        return this.dynamicIncludeSubFolders;
    }

    public void setDynamicIncludeSubFolders(boolean dynamicIncludeSubFolders) {
        this.dynamicIncludeSubFolders = dynamicIncludeSubFolders;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public void setFilterFileType(int filtertypevalue) {
        this.fileTypeFilter = FileInputList.FileTypeFilter.getByOrdinal((int)filtertypevalue);
    }

    public FileInputList.FileTypeFilter getFileTypeFilter() {
        return this.fileTypeFilter;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        GetFileNamesMeta retval = (GetFileNamesMeta)super.clone();
        int nrfiles = this.fileName.length;
        retval.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.excludeFileMask[i] = this.excludeFileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        return retval;
    }

    public void allocate(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    @Override
    public void setDefault() {
        int nrfiles = 0;
        this.doNotFailIfNoFile = false;
        this.fileTypeFilter = FileInputList.FileTypeFilter.FILES_AND_FOLDERS;
        this.isaddresult = true;
        this.filefield = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFilenameField = "";
        this.dynamicWildcardField = "";
        this.dynamicIncludeSubFolders = false;
        this.dynamicExcludeWildcardField = "";
        this.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = NO;
            this.includeSubFolders[i] = NO;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta filename = new ValueMeta("filename", 2);
        filename.setLength(500);
        filename.setPrecision(-1);
        filename.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)filename);
        ValueMeta short_filename = new ValueMeta("short_filename", 2);
        short_filename.setLength(500);
        short_filename.setPrecision(-1);
        short_filename.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)short_filename);
        ValueMeta path = new ValueMeta("path", 2);
        path.setLength(500);
        path.setPrecision(-1);
        path.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)path);
        ValueMeta type = new ValueMeta("type", 2);
        type.setLength(500);
        type.setPrecision(-1);
        type.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)type);
        ValueMeta exists = new ValueMeta("exists", 4);
        exists.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)exists);
        ValueMeta ishidden = new ValueMeta("ishidden", 4);
        ishidden.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)ishidden);
        ValueMeta isreadable = new ValueMeta("isreadable", 4);
        isreadable.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)isreadable);
        ValueMeta iswriteable = new ValueMeta("iswriteable", 4);
        iswriteable.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)iswriteable);
        ValueMeta lastmodifiedtime = new ValueMeta("lastmodifiedtime", 3);
        lastmodifiedtime.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)lastmodifiedtime);
        ValueMeta size = new ValueMeta("size", 5);
        size.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)size);
        ValueMeta extension = new ValueMeta("extension", 2);
        extension.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)extension);
        ValueMeta uri = new ValueMeta("uri", 2);
        uri.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)uri);
        ValueMeta rooturi = new ValueMeta("rooturi", 2);
        rooturi.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)rooturi);
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <filter>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"filterfiletype", (String)this.fileTypeFilter.toString()));
        retval.append("    </filter>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"doNotFailIfNoFile", (boolean)this.doNotFailIfNoFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename_Field", (String)this.dynamicFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"wildcard_Field", (String)this.dynamicWildcardField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"exclude_wildcard_Field", (String)this.dynamicExcludeWildcardField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamic_include_subfolders", (boolean)this.dynamicIncludeSubFolders));
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node filternode = XMLHandler.getSubNode((Node)stepnode, (String)"filter");
            Node filterfiletypenode = XMLHandler.getSubNode((Node)filternode, (String)"filterfiletype");
            this.fileTypeFilter = FileInputList.FileTypeFilter.getByName((String)XMLHandler.getNodeValue((Node)filterfiletypenode));
            this.doNotFailIfNoFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"doNotFailIfNoFile"));
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.isaddresult = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"isaddresult"));
            this.filefield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filefield"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.dynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"filename_Field");
            this.dynamicWildcardField = XMLHandler.getTagValue((Node)stepnode, (String)"wildcard_Field");
            this.dynamicExcludeWildcardField = XMLHandler.getTagValue((Node)stepnode, (String)"exclude_wildcard_Field");
            this.dynamicIncludeSubFolders = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dynamic_include_subfolders"));
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            this.fileTypeFilter = FileInputList.FileTypeFilter.getByName((String)rep.getStepAttributeString(id_step, "filterfiletype"));
            this.doNotFailIfNoFile = rep.getStepAttributeBoolean(id_step, "doNotFailIfNoFile");
            this.dynamicFilenameField = rep.getStepAttributeString(id_step, "filename_Field");
            this.dynamicWildcardField = rep.getStepAttributeString(id_step, "wildcard_Field");
            this.dynamicExcludeWildcardField = rep.getStepAttributeString(id_step, "exclude_wildcard_Field");
            this.dynamicIncludeSubFolders = rep.getStepAttributeBoolean(id_step, "dynamic_include_subfolders");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.isaddresult = rep.getStepAttributeBoolean(id_step, rep.getStepAttributeString(id_step, "isaddresult"));
            this.filefield = rep.getStepAttributeBoolean(id_step, "filefield");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filterfiletype", this.fileTypeFilter.toString());
            rep.saveStepAttribute(id_transformation, id_step, "doNotFailIfNoFile", this.doNotFailIfNoFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "isaddresult", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.filefield);
            rep.saveStepAttribute(id_transformation, id_step, "filename_Field", this.dynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "wildcard_Field", this.dynamicWildcardField);
            rep.saveStepAttribute(id_transformation, id_step, "exclude_wildcard_Field", this.dynamicExcludeWildcardField);
            rep.saveStepAttribute(id_transformation, id_step, "dynamic_include_subfolders", this.dynamicIncludeSubFolders);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (int i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    private FileInputList.FileTypeFilter[] buildFileTypeFiltersArray() {
        FileInputList.FileTypeFilter[] filters = new FileInputList.FileTypeFilter[this.fileName.length];
        for (int i = 0; i < this.fileName.length; ++i) {
            filters[i] = this.getFileTypeFilter();
        }
        return filters;
    }

    public String[] getFilePaths(VariableSpace space) {
        return FileInputList.createFilePathList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean(), (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray());
    }

    public FileInputList getFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean(), (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray());
    }

    public FileInputList getDynamicFileList(VariableSpace space, String[] filename, String[] filemask, String[] excludefilemask, String[] filerequired, boolean[] includesubfolders) {
        return FileInputList.createFileList((VariableSpace)space, (String[])filename, (String[])filemask, (String[])excludefilemask, (String[])filerequired, (boolean[])includesubfolders, (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray());
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.filefield) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.InputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.InputErrorKo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            cr = Const.isEmpty((String)this.dynamicFilenameField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.FolderFieldnameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.FolderFieldnameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            FileInputList fileList = this.getFileList(transMeta);
            cr = fileList.nrOfFiles() == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] files = this.getFilePaths(transMeta);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                reference.getEntries().add(new ResourceEntry(files[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetFileNames(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetFileNamesData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

