/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getsubfolders;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFoldersData;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFoldersMeta;

public class GetSubFolders
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetSubFoldersMeta.class;
    private GetSubFoldersMeta meta;
    private GetSubFoldersData data;

    public GetSubFolders(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block20: {
            if (this.meta.isFoldernameDynamic() && this.data.filenr >= this.data.filessize) {
                this.data.readrow = this.getRow();
            }
            if (this.first) {
                this.first = false;
                if (this.meta.isFoldernameDynamic()) {
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Const.isEmpty((String)this.meta.getDynamicFoldernameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfFoldernameField < 0) {
                        String realDynamicFoldername = this.environmentSubstitute(this.meta.getDynamicFoldernameField());
                        this.data.indexOfFoldernameField = this.data.inputRowMeta.indexOfValue(realDynamicFoldername);
                        if (this.data.indexOfFoldernameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.ErrorFindingField", (String[])new String[0]) + "[" + realDynamicFoldername + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.CouldnotFindField", (String[])new String[]{realDynamicFoldername}));
                        }
                    }
                } else {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.files = this.meta.getFolderList(this);
                    this.data.filessize = this.data.files.nrOfFiles();
                    this.handleMissingFiles();
                }
                this.data.nrStepFields = this.data.outputRowMeta.size();
            }
            if (this.meta.isFoldernameDynamic()) {
                if (this.data.readrow == null) {
                    this.setOutputDone();
                    return false;
                }
            } else if (this.data.filenr >= this.data.filessize) {
                this.setOutputDone();
                return false;
            }
            try {
                Object[] outputRow = this.buildEmptyRow();
                int outputIndex = 0;
                Object[] extraData = new Object[this.data.nrStepFields];
                if (this.meta.isFoldernameDynamic()) {
                    if (this.data.filenr >= this.data.filessize) {
                        String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFoldernameField);
                        String[] filesname = new String[]{filename};
                        String[] filesrequired = new String[]{"N"};
                        this.data.files = this.meta.getDynamicFolderList(this.getTransMeta(), filesname, filesrequired);
                        this.data.filessize = this.data.files.nrOfFiles();
                        this.data.filenr = 0;
                    }
                    outputRow = (Object[])this.data.readrow.clone();
                }
                if (this.data.filessize <= 0) break block20;
                this.data.file = this.data.files.getFile(this.data.filenr);
                extraData[outputIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
                extraData[outputIndex++] = this.data.file.getName().getBaseName();
                try {
                    extraData[outputIndex++] = KettleVFS.getFilename((FileObject)this.data.file.getParent());
                    extraData[outputIndex++] = this.data.file.isHidden();
                    extraData[outputIndex++] = this.data.file.isReadable();
                    extraData[outputIndex++] = this.data.file.isWriteable();
                    extraData[outputIndex++] = new Date(this.data.file.getContent().getLastModifiedTime());
                }
                catch (IOException e) {
                    throw new KettleException((Throwable)e);
                }
                extraData[outputIndex++] = this.data.file.getName().getURI();
                extraData[outputIndex++] = this.data.file.getName().getRootURI();
                extraData[outputIndex++] = new Long(this.data.file.getChildren().length);
                if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                    extraData[outputIndex++] = new Long(this.data.rownr);
                }
                ++this.data.rownr;
                outputRow = RowDataUtil.addRowData((Object[])outputRow, (int)this.data.totalpreviousfields, (Object[])extraData);
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.meta.getRowLimit() > 0L && this.data.rownr >= this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        ++this.data.filenr;
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NrLine", (String[])new String[]{"" + this.getLinesInput()}));
        }
        return true;
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Error.MissingFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.MissingFiles", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Error.NoAccessibleFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.NoAccessibleFiles", (String[])new String[]{message}));
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetSubFoldersMeta)smi;
        this.data = (GetSubFoldersData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.filessize = 0;
                this.data.rownr = 1L;
                this.data.filenr = 0;
                this.data.totalpreviousfields = 0;
            }
            catch (Exception e) {
                this.logError("Error initializing step: " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetSubFoldersMeta)smi;
        this.data = (GetSubFoldersData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

