/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.script;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.script.Script;
import org.pentaho.di.trans.steps.script.ScriptAddClasses;
import org.pentaho.di.trans.steps.script.ScriptData;
import org.pentaho.di.trans.steps.script.ScriptDummy;
import org.pentaho.di.trans.steps.script.ScriptValuesScript;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ScriptMeta.class;
    private static final String JSSCRIPT_TAG_TYPE = "jsScript_type";
    private static final String JSSCRIPT_TAG_NAME = "jsScript_name";
    private static final String JSSCRIPT_TAG_SCRIPT = "jsScript_script";
    private ScriptAddClasses[] additionalClasses;
    private ScriptValuesScript[] jsScripts;
    private String[] fieldname;
    private String[] rename;
    private int[] type;
    private int[] length;
    private int[] precision;
    private boolean[] replace;

    public ScriptMeta() {
        try {
            this.parseXmlForAdditionalClasses();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String[] fieldname) {
        this.fieldname = fieldname;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public String[] getRename() {
        return this.rename;
    }

    public void setRename(String[] rename) {
        this.rename = rename;
    }

    public int[] getType() {
        return this.type;
    }

    public void setType(int[] type) {
        this.type = type;
    }

    public int getNumberOfJSScripts() {
        return this.jsScripts.length;
    }

    public String[] getJSScriptNames() {
        String[] strJSNames = new String[this.jsScripts.length];
        for (int i = 0; i < this.jsScripts.length; ++i) {
            strJSNames[i] = this.jsScripts[i].getScriptName();
        }
        return strJSNames;
    }

    public ScriptValuesScript[] getJSScripts() {
        return this.jsScripts;
    }

    public void setJSScripts(ScriptValuesScript[] jsScripts) {
        this.jsScripts = jsScripts;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldname = new String[nrfields];
        this.rename = new String[nrfields];
        this.type = new int[nrfields];
        this.length = new int[nrfields];
        this.precision = new int[nrfields];
        this.replace = new boolean[nrfields];
    }

    @Override
    public Object clone() {
        ScriptMeta retval = (ScriptMeta)super.clone();
        int nrfields = this.fieldname.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldname[i] = this.fieldname[i];
            retval.rename[i] = this.rename[i];
            retval.type[i] = this.type[i];
            retval.length[i] = this.length[i];
            retval.precision[i] = this.precision[i];
            retval.replace[i] = this.replace[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node scripts = XMLHandler.getSubNode((Node)stepnode, (String)"jsScripts");
            int nrscripts = XMLHandler.countNodes((Node)scripts, (String)"jsScript");
            this.jsScripts = new ScriptValuesScript[nrscripts];
            for (int i = 0; i < nrscripts; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)scripts, (String)"jsScript", (int)i);
                this.jsScripts[i] = new ScriptValuesScript(Integer.parseInt(XMLHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_TYPE)), XMLHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_NAME), XMLHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_SCRIPT));
            }
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldname[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.rename[i] = XMLHandler.getTagValue((Node)fnode, (String)"rename");
                this.type[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type"));
                String slen = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.length[i] = Const.toInt((String)slen, (int)-1);
                this.precision[i] = Const.toInt((String)sprc, (int)-1);
                this.replace[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"replace"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.jsScripts = new ScriptValuesScript[1];
        this.jsScripts[0] = new ScriptValuesScript(0, BaseMessages.getString(PKG, (String)"Script.Script1", (String[])new String[0]), "//" + BaseMessages.getString(PKG, (String)"Script.ScriptHere", (String[])new String[0]) + Const.CR + Const.CR);
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldname[i] = "newvalue";
            this.rename[i] = "newvalue";
            this.type[i] = 1;
            this.length[i] = -1;
            this.precision[i] = -1;
            this.replace[i] = false;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String originStepname, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldname.length; ++i) {
            String fieldName;
            int fieldType;
            int replaceIndex;
            if (Const.isEmpty((String)this.fieldname[i])) continue;
            if (this.replace[i]) {
                if (row.searchValueMeta(this.fieldname[i]) == null && Const.isEmpty((String)this.rename[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.FieldToReplaceNotFound", (String[])new String[]{this.fieldname[i]}));
                }
                replaceIndex = row.indexOfValue(this.rename[i]);
                fieldType = this.type[i];
                fieldName = this.rename[i];
            } else {
                replaceIndex = -1;
                fieldType = this.type[i];
                fieldName = this.rename[i] != null && this.rename[i].length() != 0 ? this.rename[i] : this.fieldname[i];
            }
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)fieldName, (int)fieldType);
                v.setLength(this.length[i]);
                v.setPrecision(this.precision[i]);
                v.setOrigin(originStepname);
                if (this.replace[i] && replaceIndex >= 0) {
                    row.setValueMeta(replaceIndex, v);
                    continue;
                }
                row.addValueMeta(v);
                continue;
            }
            catch (KettlePluginException e) {
                // empty catch block
            }
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <jsScripts>");
        for (i = 0; i < this.jsScripts.length; ++i) {
            retval.append("      <jsScript>");
            retval.append("        ").append(XMLHandler.addTagValue((String)JSSCRIPT_TAG_TYPE, (int)this.jsScripts[i].getScriptType()));
            retval.append("        ").append(XMLHandler.addTagValue((String)JSSCRIPT_TAG_NAME, (String)this.jsScripts[i].getScriptName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)JSSCRIPT_TAG_SCRIPT, (String)this.jsScripts[i].getScript()));
            retval.append("      </jsScript>");
        }
        retval.append("    </jsScripts>");
        retval.append("    <fields>");
        for (i = 0; i < this.fieldname.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldname[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.rename[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.type[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.length[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.precision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"replace", (boolean)this.replace[i]));
            retval.append("      </field>");
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            String script = rep.getStepAttributeString(id_step, "script");
            if (!Const.isEmpty((String)script)) {
                this.jsScripts = new ScriptValuesScript[1];
                this.jsScripts[0] = new ScriptValuesScript(0, "ScriptValue", script);
            } else {
                int nrScripts = rep.countNrStepAttributes(id_step, JSSCRIPT_TAG_NAME);
                this.jsScripts = new ScriptValuesScript[nrScripts];
                for (i = 0; i < nrScripts; ++i) {
                    this.jsScripts[i] = new ScriptValuesScript((int)rep.getStepAttributeInteger(id_step, i, JSSCRIPT_TAG_TYPE), rep.getStepAttributeString(id_step, i, JSSCRIPT_TAG_NAME), rep.getStepAttributeString(id_step, i, JSSCRIPT_TAG_SCRIPT));
                }
            }
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (i = 0; i < nrfields; ++i) {
                this.fieldname[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.rename[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.type[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.length[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.precision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.replace[i] = rep.getStepAttributeBoolean(id_step, i, "field_replace");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < this.jsScripts.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, JSSCRIPT_TAG_NAME, this.jsScripts[i].getScriptName());
                rep.saveStepAttribute(id_transformation, id_step, i, JSSCRIPT_TAG_SCRIPT, this.jsScripts[i].getScript());
                rep.saveStepAttribute(id_transformation, id_step, i, JSSCRIPT_TAG_TYPE, this.jsScripts[i].getScriptType());
            }
            for (i = 0; i < this.fieldname.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldname[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_rename", this.rename[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.type[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.length[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.precision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_replace", this.replace[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        int i;
        boolean error_found = false;
        String error_message = "";
        ScriptEngine jscx = ScriptMeta.createNewScriptEngine(stepMeta.getName());
        Bindings jsscope = jscx.getBindings(100);
        String strActiveStartScriptName = "";
        String strActiveEndScriptName = "";
        String strActiveScript = "";
        String strActiveStartScript = "";
        String strActiveEndScript = "";
        if (this.jsScripts.length > 0) {
            for (i = 0; i < this.jsScripts.length; ++i) {
                if (this.jsScripts[i].isTransformScript()) {
                    strActiveScript = this.jsScripts[i].getScript();
                    continue;
                }
                if (this.jsScripts[i].isStartScript()) {
                    strActiveStartScriptName = this.jsScripts[i].getScriptName();
                    strActiveStartScript = this.jsScripts[i].getScript();
                    continue;
                }
                if (!this.jsScripts[i].isEndScript()) continue;
                strActiveEndScriptName = this.jsScripts[i].getScriptName();
                strActiveEndScript = this.jsScripts[i].getScript();
            }
        }
        if (prev != null && strActiveScript.length() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.ConnectedStepOK", (String[])new String[]{String.valueOf(prev.size())}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            for (i = 0; i < this.getNumberOfJSScripts(); ++i) {
                jsscope.put(this.jsScripts[i].getScriptName(), (Object)this.jsScripts[i].getScript());
            }
            try {
                if (this.getAddClasses() != null) {
                    for (i = 0; i < this.getAddClasses().length; ++i) {
                        jsscope.put(this.getAddClasses()[i].getJSName(), this.getAddClasses()[i].getAddObject());
                    }
                }
            }
            catch (Exception e) {
                error_message = "Couldn't add JavaClasses to Context! Error:";
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                jsscope.put("SKIP_TRANSFORMATION", (Object)1);
                jsscope.put("ABORT_TRANSFORMATION", (Object)-1);
                jsscope.put("ERROR_TRANSFORMATION", (Object)-2);
                jsscope.put("CONTINUE_TRANSFORMATION", (Object)0);
            }
            catch (Exception ex) {
                error_message = "Couldn't add Transformation Constants! Error:" + Const.CR + ex.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                ScriptDummy dummyStep = new ScriptDummy(prev, transMeta.getStepFields(stepMeta));
                jsscope.put("_step_", (Object)dummyStep);
                Object[] row = new Object[prev.size()];
                jsscope.put("rowMeta", (Object)prev);
                for (int i2 = 0; i2 < prev.size(); ++i2) {
                    ValueMetaInterface valueMeta = prev.getValueMeta(i2);
                    Object valueData = null;
                    if (valueMeta.isDate()) {
                        valueData = new Date();
                    }
                    if (valueMeta.isString()) {
                        valueData = "test value test value test value test value test value test value test value test value test value test value";
                    }
                    if (valueMeta.isInteger()) {
                        valueData = 0L;
                    }
                    if (valueMeta.isNumber()) {
                        valueData = new Double(0.0);
                    }
                    if (valueMeta.isBigNumber()) {
                        valueData = BigDecimal.ZERO;
                    }
                    if (valueMeta.isBoolean()) {
                        valueData = Boolean.TRUE;
                    }
                    if (valueMeta.isBinary()) {
                        valueData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
                    }
                    row[i2] = valueData;
                    jsscope.put(valueMeta.getName(), valueData);
                }
                jsscope.put("Value", (Object)Value.class);
                jsscope.put("row", (Object)row);
            }
            catch (Exception ev) {
                error_message = "Couldn't add Input fields to Script! Error:" + Const.CR + ev.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                if (strActiveStartScript != null && strActiveStartScript.length() > 0) {
                    jscx.eval(strActiveStartScript, jsscope);
                    error_message = "Found Start Script. " + strActiveStartScriptName + " Processing OK";
                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (Exception e) {
                error_message = "Couldn't process Start Script! Error:" + Const.CR + e.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            try {
                CompiledScript jsscript = ((Compilable)((Object)jscx)).compile(strActiveScript);
                try {
                    jsscript.eval(jsscope);
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.ScriptCompiledOK2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    if (this.fieldname.length > 0) {
                        StringBuffer message = new StringBuffer(BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.FailedToGetValues", (String[])new String[]{String.valueOf(this.fieldname.length)}) + Const.CR + Const.CR);
                        cr = error_found ? new CheckResult(4, message.toString(), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, message.toString(), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                catch (ScriptException jse) {
                    error_message = BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.CouldNotExecuteScript", (String[])new String[0]) + Const.CR + jse.toString();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                catch (Exception e) {
                    error_message = BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.CouldNotExecuteScript2", (String[])new String[0]) + Const.CR + e.toString();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                try {
                    if (strActiveEndScript != null && strActiveEndScript.length() > 0) {
                        jscx.eval(strActiveEndScript, jsscope);
                        error_message = "Found End Script. " + strActiveEndScriptName + " Processing OK";
                        cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                catch (Exception e) {
                    error_message = "Couldn't process End Script! Error:" + Const.CR + e.toString();
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (Exception e) {
                error_message = BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.CouldNotCompileScript", (String[])new String[0]) + Const.CR + e.toString();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.CouldNotGetFieldsFromPreviousStep", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.ConnectedStepOK2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ScriptMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getFunctionFromScript(String strFunction, String strScript) {
        String sRC = "";
        int iStartPos = strScript.indexOf(strFunction);
        if (iStartPos > 0) {
            iStartPos = strScript.indexOf(123, iStartPos);
            int iCounter = 1;
            while (iCounter != 0) {
                if (strScript.charAt(iStartPos++) == '{') {
                    ++iCounter;
                } else if (strScript.charAt(iStartPos++) == '}') {
                    --iCounter;
                }
                sRC = sRC + strScript.charAt(iStartPos);
            }
        }
        return sRC;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getValue(Bindings scope, int i, Value res, StringBuffer message) {
        block26: {
            block24: {
                block23: {
                    error_found = false;
                    if (this.fieldname[i] == null || this.fieldname[i].length() <= 0) break block24;
                    res.setName(this.rename[i]);
                    res.setType(this.type[i]);
                    try {
                        block25: {
                            result = scope.get(this.fieldname[i]);
                            if (result == null) break block25;
                            classname = result.getClass().getName();
                            switch (this.type[i]) {
                                case 1: {
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                                        v = (Value)result;
                                        res.setValue(v.getNumber());
                                        break;
                                    }
                                    res.setValue(((Double)result).doubleValue());
                                    break;
                                }
                                case 5: {
                                    if (classname.equalsIgnoreCase("java.lang.Byte")) {
                                        res.setValue(((Byte)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Short")) {
                                        res.setValue(((Short)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Integer")) {
                                        res.setValue(((Integer)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("java.lang.Long")) {
                                        res.setValue(((Long)result).longValue());
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) {
                                        v = (Value)result;
                                        res.setValue(v.getInteger());
                                        break;
                                    }
                                    res.setValue(Math.round((Double)result));
                                    break;
                                }
                                case 2: {
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject") || classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        try {
                                            v = (Value)result;
                                            res.setValue(v.getString());
                                        }
                                        catch (Exception ev) {
                                            s = (String)result;
                                            res.setValue(s);
                                        }
                                        break;
                                    }
                                    res.setValue((String)result);
                                    break;
                                }
                                case 3: {
                                    dbl = 0.0;
                                    if (classname.equalsIgnoreCase("org.mozilla.javascript.Undefined")) {
                                        res.setNull();
                                        break;
                                    }
                                    if (!classname.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) ** GOTO lbl62
                                    dbl = (Double)result;
                                    ** GOTO lbl76
lbl62:
                                    // 1 sources

                                    if (!classname.equalsIgnoreCase("org.mozilla.javascript.NativeJavaObject")) ** GOTO lbl75
                                    try {
                                        dat = (Date)result;
                                        dbl = dat.getTime();
                                    }
                                    catch (Exception e) {
                                        v = (Value)result;
                                        dat = v.getDate();
                                        if (dat == null) ** GOTO lbl73
                                        dbl = dat.getTime();
                                        ** GOTO lbl76
lbl73:
                                        // 1 sources

                                        res.setNull();
                                    }
                                    ** GOTO lbl76
lbl75:
                                    // 1 sources

                                    dbl = (Double)result;
lbl76:
                                    // 5 sources

                                    lng = Math.round(dbl);
                                    dat = new Date(lng);
                                    res.setValue(dat);
                                    break;
                                }
                                case 4: {
                                    res.setValue(((Boolean)result).booleanValue());
                                    break;
                                }
                                default: {
                                    res.setNull();
                                    break;
                                }
                            }
                            break block23;
                        }
                        res.setNull();
                    }
                    catch (Exception e) {
                        message.append(BaseMessages.getString(ScriptMeta.PKG, (String)"ScriptMeta.CheckResult.ErrorRetrievingValue", (String[])new String[]{this.fieldname[i]}) + " : " + e.toString());
                        error_found = true;
                    }
                }
                res.setLength(this.length[i], this.precision[i]);
                message.append(BaseMessages.getString(ScriptMeta.PKG, (String)"ScriptMeta.CheckResult.RetrievedValue", (String[])new String[]{this.fieldname[i], res.toStringMeta()}));
                break block26;
            }
            message.append(BaseMessages.getString(ScriptMeta.PKG, (String)"ScriptMeta.CheckResult.ValueIsEmpty", (String[])new String[]{String.valueOf(i)}));
            error_found = true;
        }
        return error_found;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Script(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ScriptData();
    }

    public void parseXmlForAdditionalClasses() throws KettleException {
        try {
            Properties sysprops = System.getProperties();
            String strActPath = sysprops.getProperty("user.dir");
            Document dom = XMLHandler.loadXMLFile((String)(strActPath + "/plugins/steps/ScriptValues_mod/plugin.xml"));
            Element stepnode = dom.getDocumentElement();
            Node libraries = XMLHandler.getSubNode((Node)stepnode, (String)"js_libraries");
            int nbOfLibs = XMLHandler.countNodes((Node)libraries, (String)"js_lib");
            this.additionalClasses = new ScriptAddClasses[nbOfLibs];
            for (int i = 0; i < nbOfLibs; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)libraries, (String)"js_lib", (int)i);
                String strJarName = XMLHandler.getTagAttribute((Node)fnode, (String)"name");
                String strClassName = XMLHandler.getTagAttribute((Node)fnode, (String)"classname");
                String strJSName = XMLHandler.getTagAttribute((Node)fnode, (String)"js_name");
                Class<?> addClass = ScriptMeta.LoadAdditionalClass(strActPath + "/plugins/steps/ScriptValues_mod/" + strJarName, strClassName);
                Object addObject = addClass.newInstance();
                this.additionalClasses[i] = new ScriptAddClasses(addClass, addObject, strJSName);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.UnableToParseXMLforAdditionalClasses", (String[])new String[0]), (Throwable)e);
        }
    }

    private static Class<?> LoadAdditionalClass(String strJar, String strClassName) throws KettleException {
        try {
            Thread t = Thread.currentThread();
            ClassLoader cl = t.getContextClassLoader();
            URL u = new URL("jar:file:" + strJar + "!/");
            KettleURLClassLoader kl = new KettleURLClassLoader(new URL[]{u}, cl);
            Class toRun = kl.loadClass(strClassName);
            return toRun;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.UnableToLoadAdditionalClass", (String[])new String[0]), (Throwable)e);
        }
    }

    public ScriptAddClasses[] getAddClasses() {
        return this.additionalClasses;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean[] getReplace() {
        return this.replace;
    }

    public void setReplace(boolean[] replace) {
        this.replace = replace;
    }

    public static ScriptEngine createNewScriptEngine(String stepName) {
        System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
        ScriptEngineManager manager = new ScriptEngineManager();
        String[] strings = stepName.split("\\.");
        String extension = strings[strings.length > 0 ? 1 : 0];
        ScriptEngine scriptEngine = manager.getEngineByName(extension);
        if (scriptEngine == null) {
            scriptEngine = manager.getEngineByName("javascript");
        }
        return scriptEngine;
    }
}

