/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputsax;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxData;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxDataRetriever;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxMeta;

public class XMLInputSax
extends BaseStep
implements StepInterface {
    private XMLInputSaxMeta meta;
    private XMLInputSaxData data;

    public XMLInputSax(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
        }
        if ((outputRowData = this.getRowFromXML()) == null) {
            this.setOutputDone();
            return false;
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row: " + this.data.outputRowMeta.getString(outputRowData));
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.meta.getRowLimit() > 0L && this.data.rownr >= this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getRowFromXML() throws KettleValueException {
        if (this.data.document == null) {
            this.data.filename = null;
        } else if (!this.data.document.hasNext()) {
            this.data.filename = null;
        }
        if (this.data.filename == null && !this.openNextFile()) {
            return null;
        }
        Object[] outputRowData = this.data.document.getNext();
        int outputIndex = this.meta.getInputFields().length;
        if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
            outputRowData[outputIndex++] = this.data.filename;
        }
        if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
            outputRowData[outputIndex] = new Long(this.data.rownr);
        }
        ++this.data.rownr;
        return outputRowData;
    }

    private boolean openNextFile() {
        try {
            if (this.data.filenr >= this.data.files.length) {
                if (this.log.isDetailed()) {
                    this.logDetailed("Finished processing files.");
                }
                return false;
            }
            this.data.last_file = this.data.filenr == this.data.files.length - 1;
            this.data.filename = this.environmentSubstitute(this.data.files[this.data.filenr]);
            if (this.log.isBasic()) {
                this.logBasic("Opening file: " + this.data.filename);
            }
            ++this.data.filenr;
            this.data.document = new XMLInputSaxDataRetriever(this.log, this.data.filename, this.meta, this.data);
            this.data.document.runExample();
        }
        catch (Exception e) {
            this.logError("Couldn't open file #" + this.data.filenr + " : " + this.data.filename, e);
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputSaxMeta)smi;
        this.data = (XMLInputSaxData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getFilePaths(this.getTransMeta());
            if (this.data.files == null || this.data.files.length == 0) {
                this.logError("No file(s) specified! Stop processing.");
                return false;
            }
            if (this.meta.getInputPosition().length == 0) {
                this.logError("No location specified! Stop processing.");
                return false;
            }
            if (this.meta.getInputFields().length == 0) {
                this.logError("No fields specified! Stop processing.");
                return false;
            }
            this.data.rownr = 1L;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputSaxMeta)smi;
        this.data = (XMLInputSaxData)sdi;
        super.dispose(smi, sdi);
    }
}

