/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputsax;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;

public class XMLInputSaxFieldPosition {
    public static final int XML_ELEMENT_POS = 1;
    public static final int XML_ELEMENT_ATT = 2;
    public static final int XML_ATTRIBUTE = 3;
    public static final String NR_MARKER = "/";
    public static final String ATT_MARKER = ":";
    private String name;
    private String attribute;
    private String value;
    private int type;
    private int elementNr;

    public XMLInputSaxFieldPosition(String name, int type) throws KettleValueException {
        if (type == 2) {
            throw new KettleValueException("This constructor is for position defined attributes or elements");
        }
        this.name = name;
        this.type = type;
        this.elementNr = 1;
    }

    public XMLInputSaxFieldPosition(String name, int type, int elementNr) throws KettleValueException {
        if (type == 2) {
            throw new KettleValueException("This constructor is for position defined attributes or elements");
        }
        this.name = name;
        this.type = type;
        this.elementNr = elementNr;
    }

    public XMLInputSaxFieldPosition(String name, String attribute, String value) {
        this.name = name;
        this.type = 2;
        this.attribute = attribute;
        this.value = value;
    }

    public String toString() {
        String enc = "";
        if (this.type == 3) {
            enc = enc + "A=";
            enc = enc + this.name;
            enc = enc + NR_MARKER + (this.elementNr <= 0 ? 1 : this.elementNr);
        } else if (this.type == 2) {
            enc = enc + "Ea=";
            enc = enc + this.name;
            enc = enc + NR_MARKER + this.attribute + ATT_MARKER + this.value;
        } else {
            enc = enc + "Ep=";
            enc = enc + this.name;
            enc = enc + NR_MARKER + (this.elementNr <= 0 ? 1 : this.elementNr);
        }
        return enc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLInputSaxFieldPosition(String encoded) throws KettleValueException {
        String nameAndNumber;
        int equalIndex = encoded.indexOf(61);
        if (equalIndex < 0) {
            throw new KettleValueException("Sorry, this is not a valid XML Field Position (no equal sign in code: '" + encoded + "')");
        }
        String positionType = Const.trim((String)encoded.substring(0, equalIndex));
        String positionName = nameAndNumber = Const.trim((String)encoded.substring(equalIndex + 1));
        int semiIndex = nameAndNumber.indexOf(NR_MARKER);
        int semiIndex2 = nameAndNumber.indexOf(ATT_MARKER);
        if (positionType.equalsIgnoreCase("Ea")) {
            this.type = 2;
        } else if (positionType.equalsIgnoreCase("Ep")) {
            this.type = 1;
            this.name = positionName;
        } else {
            if (!positionType.equalsIgnoreCase("A")) throw new KettleValueException("Sorry, the position type can either be Ep (element defined by position) or Ea (element defined by an attribute value) or A (attribute), you specified " + positionType);
            this.type = 3;
            this.name = positionName;
        }
        if (this.type == 2) {
            if (semiIndex2 < 0) throw new KettleValueException("Sorry, when the position type is Ea, defining attibute and its value must be specified : Ea=element/attribute:value(" + semiIndex2 + ")");
            this.attribute = nameAndNumber.substring(semiIndex + 1, semiIndex2);
            this.value = nameAndNumber.substring(semiIndex2 + 1);
            this.name = nameAndNumber.substring(0, semiIndex);
            return;
        } else if (semiIndex >= 0) {
            this.elementNr = Const.toInt((String)nameAndNumber.substring(semiIndex + 1), (int)1);
            this.name = nameAndNumber.substring(0, semiIndex);
            return;
        } else {
            this.elementNr = 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAttributeValue() {
        return this.value;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getElementNr() {
        return this.elementNr;
    }

    public void setElementNr(int elementNr) {
        this.elementNr = elementNr;
    }

    public static final String encodePath(List<XMLInputSaxFieldPosition> path) {
        String encoded = "";
        for (int p = 0; p < path.size(); ++p) {
            XMLInputSaxFieldPosition pos = path.get(p);
            String elementName = pos.toString();
            if (p > 0) {
                encoded = encoded + ",";
            }
            encoded = encoded + elementName;
        }
        return encoded;
    }
}

