/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Servlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.plus.jaas.JAASUserRealm;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.CartePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.GetRootServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.SslConfiguration;
import org.pentaho.di.www.TransformationMap;

public class WebServer {
    private static Class<?> PKG = WebServer.class;
    private LogChannelInterface log;
    public static final int PORT = 80;
    private Server server;
    private TransformationMap transformationMap;
    private JobMap jobMap;
    private List<SlaveServerDetection> detections;
    private SocketRepository socketRepository;
    private String hostname;
    private int port;
    private Timer slaveMonitoringTimer;
    private String passwordFile;
    private SslConfiguration sslConfig;

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join, String passwordFile) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, detections, hostname, port, join, passwordFile, null);
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join, String passwordFile, SslConfiguration sslConfig) throws Exception {
        this.log = log;
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
        this.detections = detections;
        this.hostname = hostname;
        this.port = port;
        this.passwordFile = passwordFile;
        this.sslConfig = sslConfig;
        this.startServer();
        this.startSlaveMonitoring();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)log, (String)KettleExtensionPoint.CarteStartup.id, (Object)this);
        }
        catch (KettleException e) {
            log.logError("Error calling extension point CarteStartup", (Throwable)e);
        }
        if (join) {
            this.server.join();
        }
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> slaveServers, String hostname, int port) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, slaveServers, hostname, port, true);
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, detections, hostname, port, join, null, null);
    }

    public Server getServer() {
        return this.server;
    }

    public void startServer() throws Exception {
        this.server = new Server();
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"*"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        SecurityHandler securityHandler = new SecurityHandler();
        if (System.getProperty("loginmodulename") != null && System.getProperty("java.security.auth.login.config") != null) {
            JAASUserRealm jaasRealm = new JAASUserRealm("Kettle");
            jaasRealm.setLoginModuleName(System.getProperty("loginmodulename"));
            securityHandler.setUserRealm((UserRealm)jaasRealm);
        } else {
            HashUserRealm hashUserRealm;
            SlaveServer slaveServer = this.transformationMap.getSlaveServerConfig().getSlaveServer();
            if (!Const.isEmpty((String)slaveServer.getPassword())) {
                hashUserRealm = new HashUserRealm("Kettle");
                hashUserRealm.put((Object)slaveServer.getUsername(), (Object)slaveServer.getPassword());
            } else {
                if (Const.isEmpty((String)this.passwordFile)) {
                    File homePwdFile = new File(Const.getKettleCartePasswordFile());
                    this.passwordFile = homePwdFile.exists() ? Const.getKettleCartePasswordFile() : Const.getKettleLocalCartePasswordFile();
                }
                hashUserRealm = new HashUserRealm("Kettle", this.passwordFile);
            }
            securityHandler.setUserRealm((UserRealm)hashUserRealm);
        }
        securityHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        Context root = new Context((HandlerContainer)contexts, "/", 1);
        GetRootServlet rootServlet = new GetRootServlet();
        rootServlet.setJettyMode(true);
        root.addServlet(new ServletHolder((Servlet)rootServlet), "/*");
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List plugins = pluginRegistry.getPlugins(CartePluginType.class);
        for (PluginInterface plugin : plugins) {
            CartePluginInterface servlet = (CartePluginInterface)pluginRegistry.loadClass(plugin);
            servlet.setup(this.transformationMap, this.jobMap, this.socketRepository, this.detections);
            servlet.setJettyMode(true);
            Context servletContext = new Context((HandlerContainer)contexts, servlet.getContextPath(), 1);
            ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
            servletContext.addServlet(servletHolder, "/*");
        }
        ServletHolder jerseyServletHolder = new ServletHolder(ServletContainer.class);
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.packages", "org.pentaho.di.www.jaxrs");
        root.addServlet(jerseyServletHolder, "/api/*");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase("temp");
        this.server.setHandlers(new Handler[]{securityHandler, contexts, resourceHandler});
        this.createListeners();
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stopServer() {
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.CarteShutdown.id, (Object)this);
        }
        catch (KettleException e) {
            this.log.logError("Error calling extension point CarteStartup", (Throwable)e);
        }
        try {
            if (this.server != null) {
                if (this.slaveMonitoringTimer != null) {
                    this.slaveMonitoringTimer.cancel();
                    this.slaveMonitoringTimer = null;
                }
                this.socketRepository.closeAll();
                this.server.stop();
            }
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Msg", (String[])new String[]{"" + e})});
        }
    }

    private void createListeners() {
        SocketConnector connector = this.getConnector();
        this.setupJettyOptions(connector);
        connector.setPort(this.port);
        connector.setHost(this.hostname);
        connector.setName(BaseMessages.getString(PKG, (String)"WebServer.Log.KettleHTTPListener", (String[])new String[]{this.hostname}));
        this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.CreateListener", (String[])new String[]{this.hostname, "" + this.port}));
        this.server.setConnectors(new Connector[]{connector});
    }

    private SocketConnector getConnector() {
        if (this.sslConfig != null) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.SslModeUsing", (String[])new String[0]));
            SslSocketConnector connector = new SslSocketConnector();
            connector.setKeystore(this.sslConfig.getKeyStore());
            connector.setPassword(this.sslConfig.getKeyStorePassword());
            connector.setKeyPassword(this.sslConfig.getKeyPassword());
            connector.setKeystoreType(this.sslConfig.getKeyStoreType());
            return connector;
        }
        return new SocketConnector();
    }

    protected void setupJettyOptions(SocketConnector connector) {
        if (this.validProperty("KETTLE_CARTE_JETTY_ACCEPTORS")) {
            connector.setAcceptors(Integer.parseInt(System.getProperty("KETTLE_CARTE_JETTY_ACCEPTORS")));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"acceptors", connector.getAcceptors()}));
        }
        if (this.validProperty("KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE")) {
            connector.setAcceptQueueSize(Integer.parseInt(System.getProperty("KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE")));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"acceptQueueSize", connector.getAcceptQueueSize()}));
        }
        if (this.validProperty("KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME")) {
            connector.setLowResourceMaxIdleTime(Integer.parseInt(System.getProperty("KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME")));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"lowResourcesMaxIdleTime", connector.getLowResourceMaxIdleTime()}));
        }
    }

    private boolean validProperty(String property) {
        boolean isValid = false;
        if (System.getProperty(property) != null && System.getProperty(property).length() > 0) {
            try {
                Integer.parseInt(System.getProperty(property));
                isValid = true;
            }
            catch (NumberFormatException nmbfExc) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptionsInvalid", (String[])new String[]{property, System.getProperty(property)}));
            }
        }
        return isValid;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public List<SlaveServerDetection> getDetections() {
        return this.detections;
    }

    private void startSlaveMonitoring() {
        this.slaveMonitoringTimer = new Timer("WebServer Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                for (SlaveServerDetection slaveServerDetection : WebServer.this.detections) {
                    SlaveServer slaveServer = slaveServerDetection.getSlaveServer();
                    try {
                        slaveServer.getStatus();
                        slaveServerDetection.setActive(true);
                        slaveServerDetection.setLastActiveDate(new Date());
                    }
                    catch (Exception e) {
                        slaveServerDetection.setActive(false);
                        slaveServerDetection.setLastInactiveDate(new Date());
                    }
                }
            }
        };
        this.slaveMonitoringTimer.schedule(timerTask, 20000L, 20000L);
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public LogChannelInterface getLog() {
        return this.log;
    }

    public void setLog(LogChannelInterface log) {
        this.log = log;
    }

    public TransformationMap getTransformationMap() {
        return this.transformationMap;
    }

    public void setTransformationMap(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    public JobMap getJobMap() {
        return this.jobMap;
    }

    public void setJobMap(JobMap jobMap) {
        this.jobMap = jobMap;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Timer getSlaveMonitoringTimer() {
        return this.slaveMonitoringTimer;
    }

    public void setSlaveMonitoringTimer(Timer slaveMonitoringTimer) {
        this.slaveMonitoringTimer = slaveMonitoringTimer;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setDetections(List<SlaveServerDetection> detections) {
        this.detections = detections;
    }
}

