/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd.loader;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.repository.InMemoryMetadataDomainRepository;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;

public class MetadataModelResourceFactory
implements ResourceFactory {
    public static final FactoryParameterKey DOMAIN_ID = new FactoryParameterKey("domain-id");

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        InputStream stream = data.getResourceAsStream(manager);
        long version = data.getVersion(manager);
        ResourceKey key = data.getKey();
        Object o = key.getFactoryParameters().get(DOMAIN_ID);
        if (o == null) {
            throw new ResourceLoadingException("Your resource-key must have a domain-id factory key defined.");
        }
        try {
            InMemoryMetadataDomainRepository repo = new InMemoryMetadataDomainRepository();
            XmiParser parser = new XmiParser();
            Domain domain = parser.parseXmi(stream);
            domain.setId(String.valueOf(o));
            repo.storeDomain(domain, true);
            SimpleResource simpleResource = new SimpleResource(key, (Object)repo, IMetadataDomainRepository.class, version);
            return simpleResource;
        }
        catch (ResourceCreationException e) {
            throw e;
        }
        catch (ResourceLoadingException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new ResourceLoadingException("IOError", (Exception)ioe);
        }
        catch (Exception e) {
            throw new ResourceCreationException("Generic Error", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    public Class getFactoryType() {
        return IMetadataDomainRepository.class;
    }

    public void initializeDefaults() {
    }
}

