/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CoprocessorHConnection
extends ConnectionManager.HConnectionImplementation {
    private final ServerName serverName;
    private final HRegionServer server;

    public static HConnection getConnectionForEnvironment(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment e;
        RegionServerServices services;
        if (env instanceof RegionCoprocessorEnvironment && (services = (e = (RegionCoprocessorEnvironment)env).getRegionServerServices()) instanceof HRegionServer) {
            return new CoprocessorHConnection((HRegionServer)services);
        }
        return HConnectionManager.createConnection((Configuration)env.getConfiguration());
    }

    @Deprecated
    public CoprocessorHConnection(HConnection delegate, HRegionServer server) throws IOException {
        this(server);
    }

    public CoprocessorHConnection(HRegionServer server) throws IOException {
        this(server.getConfiguration(), server);
    }

    public CoprocessorHConnection(Configuration conf, HRegionServer server) throws IOException {
        super(conf, false, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        this.server = server;
        this.serverName = server.getServerName();
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        if (!this.serverName.equals((Object)serverName)) {
            return super.getClient(serverName);
        }
        final BlockingService blocking = ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this.server);
        final RpcServerInterface rpc = this.server.getRpcServer();
        final MonitoredRPCHandler status = TaskMonitor.get().createRPCStatus(Thread.currentThread().getName());
        status.pause("Setting up server-local call");
        final long timestamp = EnvironmentEdgeManager.currentTimeMillis();
        BlockingRpcChannel channel = new BlockingRpcChannel(){

            public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
                try {
                    Pair<Message, CellScanner> ret = rpc.call(blocking, method, request, null, timestamp, status);
                    if (ret.getSecond() != null) {
                        PayloadCarryingRpcController rpcc = (PayloadCarryingRpcController)controller;
                        rpcc.setCellScanner((CellScanner)ret.getSecond());
                    }
                    return (Message)ret.getFirst();
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        };
        return ClientProtos.ClientService.newBlockingStub((BlockingRpcChannel)channel);
    }
}

