/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RWQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class SimpleRpcScheduler
extends RpcScheduler {
    public static final Log LOG = LogFactory.getLog(SimpleRpcScheduler.class);
    public static final String CALL_QUEUE_READ_SHARE_CONF_KEY = "hbase.ipc.server.callqueue.read.share";
    public static final String CALL_QUEUE_HANDLER_FACTOR_CONF_KEY = "hbase.ipc.server.callqueue.handler.factor";
    public static final String CALL_QUEUE_MAX_LENGTH_CONF_KEY = "hbase.ipc.server.max.callqueue.length";
    private int port;
    private final PriorityFunction priority;
    private final RpcExecutor callExecutor;
    private final RpcExecutor priorityExecutor;
    private final RpcExecutor replicationExecutor;
    private final int highPriorityLevel;

    public SimpleRpcScheduler(Configuration conf, int handlerCount, int priorityHandlerCount, int replicationHandlerCount, PriorityFunction priority, int highPriorityLevel) {
        int maxQueueLength = conf.getInt(CALL_QUEUE_MAX_LENGTH_CONF_KEY, conf.getInt("ipc.server.max.callqueue.length", handlerCount * 10));
        this.priority = priority;
        this.highPriorityLevel = highPriorityLevel;
        float callqReadShare = conf.getFloat(CALL_QUEUE_READ_SHARE_CONF_KEY, conf.getFloat("ipc.server.callqueue.read.share", 0.0f));
        float callQueuesHandlersFactor = conf.getFloat(CALL_QUEUE_HANDLER_FACTOR_CONF_KEY, conf.getFloat("ipc.server.callqueue.handler.factor", 0.0f));
        int numCallQueues = Math.max(1, Math.round((float)handlerCount * callQueuesHandlersFactor));
        LOG.info((Object)("Using default user call queue, count=" + numCallQueues));
        this.callExecutor = numCallQueues > 1 && callqReadShare > 0.0f ? new RWQueueRpcExecutor("RW.Default", handlerCount, numCallQueues, callqReadShare, maxQueueLength) : new BalancedQueueRpcExecutor("B.Default", handlerCount, numCallQueues, maxQueueLength);
        this.priorityExecutor = priorityHandlerCount > 0 ? new BalancedQueueRpcExecutor("Priority", priorityHandlerCount, 1, maxQueueLength) : null;
        this.replicationExecutor = replicationHandlerCount > 0 ? new BalancedQueueRpcExecutor("Replication", replicationHandlerCount, 1, maxQueueLength) : null;
    }

    @Override
    public void init(RpcScheduler.Context context) {
        this.port = context.getListenerAddress().getPort();
    }

    @Override
    public void start() {
        this.callExecutor.start(this.port);
        if (this.priorityExecutor != null) {
            this.priorityExecutor.start(this.port);
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.start(this.port);
        }
    }

    @Override
    public void stop() {
        this.callExecutor.stop();
        if (this.priorityExecutor != null) {
            this.priorityExecutor.stop();
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.stop();
        }
    }

    @Override
    public void dispatch(CallRunner callTask) throws InterruptedException {
        RpcServer.Call call = callTask.getCall();
        int level = this.priority.getPriority(call.getHeader(), call.param);
        if (this.priorityExecutor != null && level > this.highPriorityLevel) {
            this.priorityExecutor.dispatch(callTask);
        } else if (this.replicationExecutor != null && level == 5) {
            this.replicationExecutor.dispatch(callTask);
        } else {
            this.callExecutor.dispatch(callTask);
        }
    }

    @Override
    public int getGeneralQueueLength() {
        return this.callExecutor.getQueueLength();
    }

    @Override
    public int getPriorityQueueLength() {
        return this.priorityExecutor == null ? 0 : this.priorityExecutor.getQueueLength();
    }

    @Override
    public int getReplicationQueueLength() {
        return this.replicationExecutor == null ? 0 : this.replicationExecutor.getQueueLength();
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.callExecutor.getActiveHandlerCount() + (this.priorityExecutor == null ? 0 : this.priorityExecutor.getActiveHandlerCount()) + (this.replicationExecutor == null ? 0 : this.replicationExecutor.getActiveHandlerCount());
    }
}

