/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.coprocessor.SecureBulkLoadClient;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LoadIncrementalHFiles
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(LoadIncrementalHFiles.class);
    private HBaseAdmin hbAdmin;
    public static final String NAME = "completebulkload";
    public static final String MAX_FILES_PER_REGION_PER_FAMILY = "hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily";
    private static final String ASSIGN_SEQ_IDS = "hbase.mapreduce.bulkload.assign.sequenceNumbers";
    private int maxFilesPerRegionPerFamily;
    private boolean assignSeqIds;
    private FileSystem fs;
    private FsDelegationToken fsDelegationToken;
    private String bulkToken;
    private UserProvider userProvider;

    public LoadIncrementalHFiles(Configuration conf) throws Exception {
        super(conf);
        this.setConf(HBaseConfiguration.create((Configuration)this.getConf()));
        this.getConf().setFloat("hfile.block.cache.size", 0.0f);
        this.hbAdmin = new HBaseAdmin(conf);
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
        this.assignSeqIds = conf.getBoolean(ASSIGN_SEQ_IDS, true);
        this.maxFilesPerRegionPerFamily = conf.getInt(MAX_FILES_PER_REGION_PER_FAMILY, 32);
    }

    private void usage() {
        System.err.println("usage: completebulkload /path/to/hfileoutputformat-output tablename");
    }

    private void discoverLoadQueue(Deque<LoadQueueItem> ret, Path hfofDir) throws IOException {
        this.fs = hfofDir.getFileSystem(this.getConf());
        if (!this.fs.exists(hfofDir)) {
            throw new FileNotFoundException("HFileOutputFormat dir " + hfofDir + " not found");
        }
        FileStatus[] familyDirStatuses = this.fs.listStatus(hfofDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + hfofDir);
        }
        for (FileStatus stat : familyDirStatuses) {
            Path[] hfiles;
            if (!stat.isDir()) {
                LOG.warn((Object)("Skipping non-directory " + stat.getPath()));
                continue;
            }
            Path familyDir = stat.getPath();
            if (familyDir.getName().startsWith("_")) continue;
            byte[] family = familyDir.getName().getBytes();
            for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])this.fs.listStatus(familyDir))) {
                if (hfile.getName().startsWith("_")) continue;
                ret.add(new LoadQueueItem(family, hfile));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void doBulkLoad(Path hfofDir, HTable table) throws TableNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void bulkLoadPhase(final HTable table, final HConnection conn, ExecutorService pool, Deque<LoadQueueItem> queue, Multimap<ByteBuffer, LoadQueueItem> regionGroups) throws IOException {
        HashSet<Future<List<LoadQueueItem>>> loadingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        for (Map.Entry entry : regionGroups.asMap().entrySet()) {
            final byte[] first = ((ByteBuffer)entry.getKey()).array();
            final Collection lqis = (Collection)entry.getValue();
            Callable<List<LoadQueueItem>> call = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> toRetry = LoadIncrementalHFiles.this.tryAtomicRegionLoad(conn, table.getName(), first, (Collection<LoadQueueItem>)lqis);
                    return toRetry;
                }
            };
            loadingFutures.add(pool.submit(call));
        }
        for (Future future : loadingFutures) {
            try {
                List toRetry = (List)future.get();
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error((Object)"Unexpected execution exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error((Object)"Unexpected interrupted exception during bulk load", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
    }

    private boolean checkHFilesCountPerRegionPerFamily(Multimap<ByteBuffer, LoadQueueItem> regionGroups) {
        for (Map.Entry e : regionGroups.asMap().entrySet()) {
            Collection lqis = (Collection)e.getValue();
            HashMap<byte[], MutableInt> filesMap = new HashMap<byte[], MutableInt>();
            for (LoadQueueItem lqi : lqis) {
                MutableInt count = (MutableInt)filesMap.get(lqi.family);
                if (count == null) {
                    count = new MutableInt();
                    filesMap.put(lqi.family, count);
                }
                count.increment();
                if (count.intValue() <= this.maxFilesPerRegionPerFamily) continue;
                LOG.error((Object)("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to family " + Bytes.toStringBinary((byte[])lqi.family) + " of region with start key " + Bytes.toStringBinary((ByteBuffer)((ByteBuffer)e.getKey()))));
                return false;
            }
        }
        return true;
    }

    private Multimap<ByteBuffer, LoadQueueItem> groupOrSplitPhase(final HTable table, ExecutorService pool, Deque<LoadQueueItem> queue, final Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        final Multimap regionGroups = Multimaps.synchronizedMultimap((Multimap)rgs);
        HashSet<Future<List<LoadQueueItem>>> splittingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        while (!queue.isEmpty()) {
            final LoadQueueItem item = queue.remove();
            Callable<List<LoadQueueItem>> callable = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    List<LoadQueueItem> splits = LoadIncrementalHFiles.this.groupOrSplit((Multimap<ByteBuffer, LoadQueueItem>)regionGroups, item, table, (Pair<byte[][], byte[][]>)startEndKeys);
                    return splits;
                }
            };
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                List splits = (List)future.get();
                if (splits == null) continue;
                queue.addAll(splits);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error((Object)"IOException during splitting", (Throwable)e1);
                    throw (IOException)t;
                }
                LOG.error((Object)"Unexpected execution exception during splitting", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error((Object)"Unexpected interrupted exception during splitting", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
        return regionGroups;
    }

    private String getUniqueName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected List<LoadQueueItem> splitStoreFile(LoadQueueItem item, HTable table, byte[] startKey, byte[] splitKey) throws IOException {
        Path hfilePath = item.hfilePath;
        Path tmpDir = new Path(item.hfilePath.getParent(), "_tmp");
        LOG.info((Object)("HFile at " + hfilePath + " no longer fits inside a single " + "region. Splitting..."));
        String uniqueName = this.getUniqueName();
        HColumnDescriptor familyDesc = table.getTableDescriptor().getFamily(item.family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        LoadIncrementalHFiles.splitStoreFile(this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        FileSystem fs = tmpDir.getFileSystem(this.getConf());
        fs.setPermission(tmpDir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(botOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        ArrayList<LoadQueueItem> lqis = new ArrayList<LoadQueueItem>(2);
        lqis.add(new LoadQueueItem(item.family, botOut));
        lqis.add(new LoadQueueItem(item.family, topOut));
        LOG.info((Object)("Successfully split into new HFiles " + botOut + " and " + topOut));
        return lqis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadQueueItem> regionGroups, LoadQueueItem item, HTable table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        int indexForCallable;
        byte[] last;
        byte[] first;
        Path hfilePath = item.hfilePath;
        HFile.Reader hfr = HFile.createReader(this.fs, hfilePath, new CacheConfig(this.getConf()), this.getConf());
        try {
            hfr.loadFileInfo();
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        finally {
            hfr.close();
        }
        LOG.info((Object)("Trying to load hfile=" + hfilePath + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last)));
        if (first == null || last == null) {
            assert (first == null && last == null);
            LOG.info((Object)("hfile " + hfilePath + " has no entries, skipping"));
            return null;
        }
        if (Bytes.compareTo((byte[])first, (byte[])last) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])first) + " > " + Bytes.toStringBinary((byte[])last));
        }
        int idx = Arrays.binarySearch((Object[])startEndKeys.getFirst(), first, Bytes.BYTES_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        if ((indexForCallable = idx) < 0) {
            throw new IOException("The first region info for table " + Bytes.toString((byte[])table.getTableName()) + " cann't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable == ((byte[][])startEndKeys.getFirst()).length - 1 && !Bytes.equals((byte[])((byte[][])startEndKeys.getSecond())[indexForCallable], (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IOException("The last region info for table " + Bytes.toString((byte[])table.getTableName()) + " cann't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable + 1 < ((byte[][])startEndKeys.getFirst()).length && Bytes.compareTo((byte[])((byte[][])startEndKeys.getSecond())[indexForCallable], (byte[])((byte[][])startEndKeys.getFirst())[indexForCallable + 1]) != 0) {
            throw new IOException("The endkey of one region for table " + Bytes.toString((byte[])table.getTableName()) + " is not equal to the startkey of the next region in hbase:meta." + "Please use hbck tool to fix it first.");
        }
        boolean bl = lastKeyInRange = Bytes.compareTo((byte[])last, (byte[])((byte[][])startEndKeys.getSecond())[idx]) < 0 || Bytes.equals((byte[])((byte[][])startEndKeys.getSecond())[idx], (byte[])HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            List<LoadQueueItem> lqis = this.splitStoreFile(item, table, ((byte[][])startEndKeys.getFirst())[indexForCallable], ((byte[][])startEndKeys.getSecond())[indexForCallable]);
            return lqis;
        }
        regionGroups.put((Object)ByteBuffer.wrap(((byte[][])startEndKeys.getFirst())[idx]), (Object)item);
        return null;
    }

    @Deprecated
    protected List<LoadQueueItem> tryAtomicRegionLoad(HConnection conn, byte[] tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        return this.tryAtomicRegionLoad(conn, TableName.valueOf((byte[])tableName), first, lqis);
    }

    protected List<LoadQueueItem> tryAtomicRegionLoad(final HConnection conn, TableName tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        final ArrayList<Pair> famPaths = new ArrayList<Pair>(lqis.size());
        for (LoadQueueItem lqi : lqis) {
            famPaths.add(Pair.newPair((Object)lqi.family, (Object)lqi.hfilePath.toString()));
        }
        RegionServerCallable<Boolean> svrCallable = new RegionServerCallable<Boolean>(conn, tableName, first){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean call() throws Exception {
                SecureBulkLoadClient secureClient = null;
                boolean success = false;
                try {
                    LOG.debug((Object)("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary((byte[])this.getRow()) + " with hfile group " + famPaths));
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    if (!LoadIncrementalHFiles.this.isSecureBulkLoadEndpointAvailable()) {
                        success = ProtobufUtil.bulkLoadHFile((ClientProtos.ClientService.BlockingInterface)this.getStub(), (List)famPaths, (byte[])regionName, (boolean)LoadIncrementalHFiles.this.assignSeqIds);
                    } else {
                        HTable table = new HTable(conn.getConfiguration(), this.getTableName());
                        secureClient = new SecureBulkLoadClient(table);
                        success = secureClient.bulkLoadHFiles(famPaths, LoadIncrementalHFiles.this.fsDelegationToken.getUserToken(), LoadIncrementalHFiles.this.bulkToken, this.getLocation().getRegionInfo().getStartKey());
                    }
                    Boolean bl = success;
                    return bl;
                }
                finally {
                    if (secureClient != null && !success) {
                        FileSystem targetFs = FileSystem.get((Configuration)LoadIncrementalHFiles.this.getConf());
                        if (FSHDFSUtils.isSameHdfs(LoadIncrementalHFiles.this.getConf(), LoadIncrementalHFiles.this.fs, targetFs)) {
                            for (Pair el : famPaths) {
                                Path hfileStagingPath = null;
                                Path hfileOrigPath = new Path((String)el.getSecond());
                                try {
                                    hfileStagingPath = new Path(secureClient.getStagingPath(LoadIncrementalHFiles.this.bulkToken, (byte[])el.getFirst()), hfileOrigPath.getName());
                                    if (targetFs.rename(hfileStagingPath, hfileOrigPath)) {
                                        LOG.debug((Object)("Moved back file " + hfileOrigPath + " from " + hfileStagingPath));
                                        continue;
                                    }
                                    if (!targetFs.exists(hfileStagingPath)) continue;
                                    LOG.debug((Object)("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath));
                                }
                                catch (Exception ex) {
                                    LOG.debug((Object)("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath), (Throwable)ex);
                                }
                            }
                        }
                    }
                }
            }
        };
        try {
            ArrayList<LoadQueueItem> toRetry = new ArrayList<LoadQueueItem>();
            Configuration conf = this.getConf();
            boolean success = (Boolean)RpcRetryingCallerFactory.instantiate((Configuration)conf).newCaller().callWithRetries((RetryingCallable)svrCallable);
            if (!success) {
                LOG.warn((Object)("Attempt to bulk load region containing " + Bytes.toStringBinary((byte[])first) + " into table " + tableName + " with files " + lqis + " failed.  This is recoverable and they will be retried."));
                toRetry.addAll(lqis);
            }
            return toRetry;
        }
        catch (IOException e) {
            LOG.error((Object)"Encountered unrecoverable error from region server", (Throwable)e);
            throw e;
        }
    }

    private boolean isSecureBulkLoadEndpointAvailable() {
        String classes = this.getConf().get("hbase.coprocessor.region.classes", "");
        return classes.contains("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
    }

    static void splitStoreFile(Configuration conf, Path inFile, HColumnDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = Reference.createTopReference(splitKey);
        Reference bottomReference = Reference.createBottomReference(splitKey);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, HColumnDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HalfStoreFileReader halfReader = null;
        StoreFile.Writer halfWriter = null;
        try {
            halfReader = new HalfStoreFileReader(fs, inFile, cacheConf, reference, conf);
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompression();
            BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType(conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf)).withBlockSize(blocksize).withDataBlockEncoding(familyDescriptor.getDataBlockEncoding()).build();
            halfWriter = new StoreFile.WriterBuilder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
            HFileScanner scanner = halfReader.getScanner(false, false, false);
            scanner.seekTo();
            do {
                KeyValue kv = scanner.getKeyValue();
                halfWriter.append(kv);
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfWriter != null) {
                halfWriter.close();
            }
            if (halfReader != null) {
                halfReader.close(cacheConf.shouldEvictOnClose());
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        return !HFile.isReservedFileInfoKey(key);
    }

    private boolean doesTableExist(TableName tableName) throws Exception {
        return this.hbAdmin.tableExists(tableName);
    }

    public static byte[][] inferBoundaries(TreeMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(TableName tableName, String dirPath) throws Exception {
        Path hfofDir = new Path(dirPath);
        FileSystem fs = hfofDir.getFileSystem(this.getConf());
        if (!fs.exists(hfofDir)) {
            throw new FileNotFoundException("HFileOutputFormat dir " + hfofDir + " not found");
        }
        FileStatus[] familyDirStatuses = fs.listStatus(hfofDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + hfofDir);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (FileStatus stat : familyDirStatuses) {
            Path[] hfiles;
            if (!stat.isDir()) {
                LOG.warn((Object)("Skipping non-directory " + stat.getPath()));
                continue;
            }
            Path familyDir = stat.getPath();
            if (familyDir.getName().startsWith("_")) continue;
            byte[] family = familyDir.getName().getBytes();
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
            for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(familyDir))) {
                if (hfile.getName().startsWith("_")) continue;
                HFile.Reader reader = HFile.createReader(fs, hfile, new CacheConfig(this.getConf()), this.getConf());
                try {
                    if (hcd.getCompressionType() != reader.getFileContext().getCompression()) {
                        hcd.setCompressionType(reader.getFileContext().getCompression());
                        LOG.info((Object)("Setting compression " + hcd.getCompressionType().name() + " for family " + hcd.toString()));
                    }
                    reader.loadFileInfo();
                    byte[] first = reader.getFirstRowKey();
                    byte[] last = reader.getLastRowKey();
                    LOG.info((Object)("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last)));
                    Integer value = map.containsKey(first) ? map.get(first) : 0;
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? map.get(last) : 0;
                    map.put(last, value - 1);
                }
                finally {
                    reader.close();
                }
            }
        }
        byte[][] keys = LoadIncrementalHFiles.inferBoundaries(map);
        this.hbAdmin.createTable(htd, keys);
        LOG.info((Object)("Table " + tableName + " is available!!"));
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.usage();
            return -1;
        }
        String dirPath = args[0];
        TableName tableName = TableName.valueOf((String)args[1]);
        boolean tableExists = this.doesTableExist(tableName);
        if (!tableExists) {
            this.createTable(tableName, dirPath);
        }
        Path hfofDir = new Path(dirPath);
        HTable table = new HTable(this.getConf(), tableName);
        this.doBulkLoad(hfofDir, table);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Tool)new LoadIncrementalHFiles(conf), (String[])args);
        System.exit(ret);
    }

    static class LoadQueueItem {
        final byte[] family;
        final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }

        public String toString() {
            return "family:" + Bytes.toString((byte[])this.family) + " path:" + this.hfilePath.toString();
        }
    }
}

