/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class MasterStatusServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(MasterStatusServlet.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MasterStatusTmpl tmpl;
        HMaster master = (HMaster)this.getServletContext().getAttribute("master");
        assert (master != null) : "No Master in context!";
        Configuration conf = master.getConfiguration();
        HBaseAdmin admin = new HBaseAdmin(conf);
        Map<String, Integer> frags = this.getFragmentationInfo(master, conf);
        ServerName metaLocation = null;
        List<ServerName> servers = null;
        Set<ServerName> deadServers = null;
        if (master.isActiveMaster()) {
            if (master.getServerManager() == null) {
                response.sendError(503, "Master not ready");
                admin.close();
                return;
            }
            metaLocation = this.getMetaLocationOrNull(master);
            servers = master.getServerManager().getOnlineServersList();
            deadServers = master.getServerManager().getDeadServers().copyServerNames();
        }
        response.setContentType("text/html");
        try {
            tmpl = new MasterStatusTmpl().setFrags(frags).setMetaLocation(metaLocation).setServers(servers).setDeadServers(deadServers).setCatalogJanitorEnabled(master.isCatalogJanitorEnabled(null, RequestConverter.buildIsCatalogJanitorEnabledRequest()).getValue());
        }
        catch (ServiceException s) {
            admin.close();
            throw new IOException(s);
        }
        if (request.getParameter("filter") != null) {
            tmpl.setFilter(request.getParameter("filter"));
        }
        if (request.getParameter("format") != null) {
            tmpl.setFormat(request.getParameter("format"));
        }
        tmpl.render(response.getWriter(), master, admin);
    }

    private ServerName getMetaLocationOrNull(HMaster master) {
        try {
            return master.getCatalogTracker(0) == null ? null : master.getCatalogTracker(0).getMetaLocation();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Unable to get meta location", (Throwable)e);
            return null;
        }
    }

    private Map<String, Integer> getFragmentationInfo(HMaster master, Configuration conf) throws IOException {
        boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
        if (showFragmentation) {
            return FSUtils.getTableFragmentation(master);
        }
        return null;
    }
}

