/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;

@InterfaceAudience.Private
public class ClosedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(ClosedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo regionInfo;
    private final ClosedPriority priority;

    public ClosedRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo) {
        super(server, EventType.RS_ZK_REGION_CLOSED);
        this.assignmentManager = assignmentManager;
        this.regionInfo = regionInfo;
        this.priority = regionInfo.isMetaRegion() ? ClosedPriority.META : ClosedPriority.USER;
    }

    @Override
    public int getPriority() {
        return this.priority.getValue();
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }

    @Override
    public void process() {
        LOG.debug((Object)("Handling CLOSED event for " + this.regionInfo.getEncodedName()));
        if (this.assignmentManager.getZKTable().isDisablingOrDisabledTable(this.regionInfo.getTable()) || this.assignmentManager.getReplicasToClose().contains(this.regionInfo)) {
            this.assignmentManager.offlineDisabledRegion(this.regionInfo);
            return;
        }
        this.assignmentManager.getRegionStates().updateRegionState(this.regionInfo, RegionState.State.CLOSED);
        this.assignmentManager.removeClosedRegion(this.regionInfo);
        this.assignmentManager.assign(this.regionInfo, true);
    }

    private static enum ClosedPriority {
        META(1),
        USER(2);

        private final int value;

        private ClosedPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

