/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MasterSnapshotVerifier {
    private static final Log LOG = LogFactory.getLog(MasterSnapshotVerifier.class);
    private HBaseProtos.SnapshotDescription snapshot;
    private FileSystem fs;
    private Path rootDir;
    private TableName tableName;
    private MasterServices services;

    public MasterSnapshotVerifier(MasterServices services, HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        this.fs = services.getMasterFileSystem().getFileSystem();
        this.services = services;
        this.snapshot = snapshot;
        this.rootDir = rootDir;
        this.tableName = TableName.valueOf((String)snapshot.getTable());
    }

    public void verifySnapshot(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        this.verifySnapshotDescription(snapshotDir);
        this.verifyTableInfo(snapshotDir);
        this.verifyRegions(snapshotDir);
    }

    private void verifySnapshotDescription(Path snapshotDir) throws CorruptedSnapshotException {
        HBaseProtos.SnapshotDescription found = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        if (!this.snapshot.equals((Object)found)) {
            throw new CorruptedSnapshotException("Snapshot read (" + found + ") doesn't equal snapshot we ran (" + this.snapshot + ").", this.snapshot);
        }
    }

    private void verifyTableInfo(Path snapshotDir) throws IOException {
        FSTableDescriptors.getTableDescriptorFromFs(this.fs, snapshotDir);
    }

    private void verifyRegions(Path snapshotDir) throws IOException {
        List regions = MetaReader.getTableRegions((CatalogTracker)this.services.getCatalogTracker(0), (TableName)this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regions);
        Set<String> snapshotRegions = SnapshotReferenceUtil.getSnapshotRegionNames(this.fs, snapshotDir);
        if (snapshotRegions == null) {
            String msg = "Snapshot " + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + " looks empty";
            LOG.error((Object)msg);
            throw new CorruptedSnapshotException(msg);
        }
        String errorMsg = "";
        if (snapshotRegions.size() != regions.size()) {
            errorMsg = "Regions moved during the snapshot '" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + "'. expected=" + regions.size() + " snapshotted=" + snapshotRegions.size() + ".";
            LOG.error((Object)errorMsg);
        }
        for (HRegionInfo region : regions) {
            if (!snapshotRegions.contains(region.getEncodedName())) {
                String mesg = " No snapshot region directory found for region:" + region;
                if (errorMsg.isEmpty()) {
                    errorMsg = mesg;
                }
                LOG.error((Object)mesg);
            }
            this.verifyRegion(this.fs, snapshotDir, region);
        }
        if (!errorMsg.isEmpty()) {
            throw new CorruptedSnapshotException(errorMsg);
        }
    }

    private void verifyRegion(FileSystem fs, final Path snapshotDir, final HRegionInfo region) throws IOException {
        Path regionDir = new Path(snapshotDir, region.getEncodedName());
        Path regionInfo = new Path(regionDir, ".regioninfo");
        if (!fs.exists(regionInfo)) {
            throw new CorruptedSnapshotException("No region info found for region:" + region, this.snapshot);
        }
        HRegionInfo found = HRegionFileSystem.loadRegionInfoFileContent(fs, regionDir);
        if (!region.equals((Object)found)) {
            throw new CorruptedSnapshotException("Found region info (" + found + ") doesn't match expected region:" + region, this.snapshot);
        }
        TakeSnapshotUtils.verifyRecoveredEdits(fs, snapshotDir, found, this.snapshot);
        SnapshotReferenceUtil.visitRegionStoreFiles(fs, regionDir, new FSVisitor.StoreFileVisitor(){

            @Override
            public void storeFile(String regionNameSuffix, String family, String hfileName) throws IOException {
                MasterSnapshotVerifier.this.verifyStoreFile(snapshotDir, region, family, hfileName);
            }
        });
    }

    private void verifyStoreFile(Path snapshotDir, HRegionInfo regionInfo, String family, String fileName) throws IOException {
        Path snapshotHFilePath;
        Path refPath = null;
        if (StoreFileInfo.isReference(fileName) && !this.fs.exists(refPath = StoreFileInfo.getReferredToFile(snapshotHFilePath = new Path(new Path(new Path(snapshotDir, regionInfo.getEncodedName()), family), fileName)))) {
            throw new CorruptedSnapshotException("Missing parent hfile for: " + fileName, this.snapshot);
        }
        Path linkPath = refPath != null && HFileLink.isHFileLink(refPath) ? new Path(family, refPath.getName()) : (HFileLink.isHFileLink(fileName) ? new Path(family, fileName) : new Path(family, HFileLink.createHFileLinkName(this.tableName, regionInfo.getEncodedName(), fileName)));
        HFileLink link = new HFileLink(this.services.getConfiguration(), linkPath);
        if (!link.exists(this.fs)) {
            throw new CorruptedSnapshotException("Can't find hfile: " + fileName + " in the real (" + link.getOriginPath() + ") or archive (" + link.getArchivePath() + ") directory for the primary table.", this.snapshot);
        }
    }
}

