/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class RegionMergeTransaction {
    private static final Log LOG = LogFactory.getLog(RegionMergeTransaction.class);
    private HRegionInfo mergedRegionInfo;
    private final HRegion region_a;
    private final HRegion region_b;
    private final Path mergesdir;
    private int znodeVersion = -1;
    private final boolean forcible;
    private final List<JournalEntry> journal = new ArrayList<JournalEntry>();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");
    private RegionServerCoprocessorHost rsCoprocessorHost = null;

    public RegionMergeTransaction(HRegion a, HRegion b, boolean forcible) {
        if (a.getRegionInfo().compareTo(b.getRegionInfo()) <= 0) {
            this.region_a = a;
            this.region_b = b;
        } else {
            this.region_a = b;
            this.region_b = a;
        }
        this.forcible = forcible;
        this.mergesdir = this.region_a.getRegionFileSystem().getMergesDir();
    }

    public boolean prepare(RegionServerServices services) {
        if (!this.region_a.getTableDesc().getTableName().equals((Object)this.region_b.getTableDesc().getTableName())) {
            LOG.info((Object)("Can't merge regions " + this.region_a + "," + this.region_b + " because they do not belong to the same table"));
            return false;
        }
        if (this.region_a.getRegionInfo().equals((Object)this.region_b.getRegionInfo())) {
            LOG.info((Object)("Can't merge the same region " + this.region_a));
            return false;
        }
        if (!this.forcible && !HRegionInfo.areAdjacent((HRegionInfo)this.region_a.getRegionInfo(), (HRegionInfo)this.region_b.getRegionInfo())) {
            String msg = "Skip merging " + this.region_a.getRegionNameAsString() + " and " + this.region_b.getRegionNameAsString() + ", because they are not adjacent.";
            LOG.info((Object)msg);
            return false;
        }
        if (!this.region_a.isMergeable() || !this.region_b.isMergeable()) {
            return false;
        }
        try {
            boolean regionAHasMergeQualifier = this.hasMergeQualifierInMeta(services, this.region_a.getRegionName());
            if (regionAHasMergeQualifier || this.hasMergeQualifierInMeta(services, this.region_b.getRegionName())) {
                LOG.debug((Object)("Region " + (regionAHasMergeQualifier ? this.region_a.getRegionNameAsString() : this.region_b.getRegionNameAsString()) + " is not mergeable because it has merge qualifier in META"));
                return false;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed judging whether merge transaction is available for " + this.region_a.getRegionNameAsString() + " and " + this.region_b.getRegionNameAsString()), (Throwable)e);
            return false;
        }
        this.mergedRegionInfo = RegionMergeTransaction.getMergedRegionInfo(this.region_a.getRegionInfo(), this.region_b.getRegionInfo());
        return true;
    }

    public HRegion execute(Server server, RegionServerServices services) throws IOException {
        if (this.rsCoprocessorHost == null) {
            this.rsCoprocessorHost = server != null ? ((HRegionServer)server).getCoprocessorHost() : null;
        }
        HRegion mergedRegion = this.createMergedRegion(server, services);
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.postMergeCommit(this.region_a, this.region_b, mergedRegion);
        }
        return this.stepsAfterPONR(server, services, mergedRegion);
    }

    public HRegion stepsAfterPONR(Server server, RegionServerServices services, HRegion mergedRegion) throws IOException {
        this.openMergedRegion(server, services, mergedRegion);
        this.transitionZKNode(server, services, mergedRegion);
        return mergedRegion;
    }

    HRegion createMergedRegion(Server server, RegionServerServices services) throws IOException {
        LOG.info((Object)("Starting merge of " + this.region_a + " and " + this.region_b.getRegionNameAsString() + ", forcible=" + this.forcible));
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        if (this.rsCoprocessorHost != null && this.rsCoprocessorHost.preMerge(this.region_a, this.region_b)) {
            throw new IOException("Coprocessor bypassing regions " + this.region_a + " " + this.region_b + " merge.");
        }
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        HRegion mergedRegion = this.stepsBeforePONR(server, services, testing);
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        if (this.rsCoprocessorHost != null) {
            if (this.rsCoprocessorHost.preMergeCommit(this.region_a, this.region_b, metaEntries)) {
                throw new IOException("Coprocessor bypassing regions " + this.region_a + " " + this.region_b + " merge.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Row key of mutation from coprocessor is not parsable as region name.Mutations from coprocessor should only be for hbase:meta table.", (Throwable)e);
                throw e;
            }
        }
        this.journal.add(JournalEntry.PONR);
        if (!testing) {
            if (metaEntries.isEmpty()) {
                MetaEditor.mergeRegions(server.getCatalogTracker(0), mergedRegion.getRegionInfo(), this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), this.region_a.getTableDesc().getRegionReplication());
            } else {
                this.mergeRegionsAndPutMetaEntries(server.getCatalogTracker(0), mergedRegion.getRegionInfo(), this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), metaEntries, this.region_a.getTableDesc().getRegionReplication());
            }
        }
        return mergedRegion;
    }

    private void mergeRegionsAndPutMetaEntries(CatalogTracker catalogTracker, HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName serverName, List<Mutation> metaEntries, int regionReplication) throws IOException {
        this.prepareMutationsForMerge(mergedRegion, regionA, regionB, serverName, metaEntries, regionReplication);
        MetaEditor.mutateMetaTable(catalogTracker, metaEntries);
    }

    public void prepareMutationsForMerge(HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName serverName, List<Mutation> mutations, int regionReplication) throws IOException {
        HRegionInfo copyOfMerged = new HRegionInfo(mergedRegion);
        Put putOfMerged = MetaEditor.makePutFromRegionInfo(copyOfMerged);
        putOfMerged.add(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER, regionA.toByteArray());
        putOfMerged.add(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER, regionB.toByteArray());
        mutations.add((Mutation)putOfMerged);
        Delete deleteA = MetaEditor.makeDeleteFromRegionInfo(regionA);
        Delete deleteB = MetaEditor.makeDeleteFromRegionInfo(regionB);
        mutations.add((Mutation)deleteA);
        mutations.add((Mutation)deleteB);
        for (int i = 1; i < regionReplication; ++i) {
            RegionMergeTransaction.addEmptyLocation(putOfMerged, i);
        }
        this.addLocation(putOfMerged, serverName, 1L);
    }

    public Put addLocation(Put p, ServerName sn, long openSeqNum) {
        p.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
        p.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
        p.add(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes((long)openSeqNum));
        return p;
    }

    private static Put addEmptyLocation(Put p, int replicaId) {
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaReader.getServerColumn((int)replicaId), null);
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaReader.getStartCodeColumn((int)replicaId), null);
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaReader.getSeqNumColumn((int)replicaId), null);
        return p;
    }

    public HRegion stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
        if (server != null && server.getZooKeeper() != null) {
            try {
                RegionMergeTransaction.createNodeMerging(server.getZooKeeper(), this.mergedRegionInfo, server.getServerName(), this.region_a.getRegionInfo(), this.region_b.getRegionInfo());
            }
            catch (KeeperException e) {
                throw new IOException("Failed creating PENDING_MERGE znode on " + this.mergedRegionInfo.getRegionNameAsString(), e);
            }
        }
        this.journal.add(JournalEntry.SET_MERGING_IN_ZK);
        if (server != null && server.getZooKeeper() != null) {
            this.znodeVersion = this.getZKNode(server, services);
        }
        this.region_a.getRegionFileSystem().createMergesDir();
        this.journal.add(JournalEntry.CREATED_MERGE_DIR);
        Map<byte[], List<StoreFile>> hstoreFilesOfRegionA = this.closeAndOfflineRegion(services, this.region_a, true, testing);
        Map<byte[], List<StoreFile>> hstoreFilesOfRegionB = this.closeAndOfflineRegion(services, this.region_b, false, testing);
        assert (hstoreFilesOfRegionA != null && hstoreFilesOfRegionB != null);
        this.mergeStoreFiles(hstoreFilesOfRegionA, hstoreFilesOfRegionB);
        if (server != null && server.getZooKeeper() != null) {
            try {
                this.znodeVersion = RegionMergeTransaction.transitionMergingNode(server.getZooKeeper(), this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_MERGING, EventType.RS_ZK_REGION_MERGING);
            }
            catch (KeeperException e) {
                throw new IOException("Failed setting MERGING znode on " + this.mergedRegionInfo.getRegionNameAsString(), e);
            }
        }
        this.journal.add(JournalEntry.STARTED_MERGED_REGION_CREATION);
        HRegion mergedRegion = this.createMergedRegionFromMerges(this.region_a, this.region_b, this.mergedRegionInfo);
        return mergedRegion;
    }

    HRegion createMergedRegionFromMerges(HRegion a, HRegion b, HRegionInfo mergedRegion) throws IOException {
        return a.createMergedRegionFromMerges(mergedRegion, b);
    }

    private Map<byte[], List<StoreFile>> closeAndOfflineRegion(RegionServerServices services, HRegion region, boolean isRegionA, boolean testing) throws IOException {
        Map<byte[], List<StoreFile>> hstoreFilesToMerge = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToMerge = region.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToMerge == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.journal.add(isRegionA ? JournalEntry.CLOSED_REGION_A : JournalEntry.CLOSED_REGION_B);
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(region, null);
        }
        this.journal.add(isRegionA ? JournalEntry.OFFLINED_REGION_A : JournalEntry.OFFLINED_REGION_B);
        return hstoreFilesToMerge;
    }

    public static HRegionInfo getMergedRegionInfo(HRegionInfo a, HRegionInfo b) {
        long rid = EnvironmentEdgeManager.currentTimeMillis();
        if (rid < a.getRegionId() || rid < b.getRegionId()) {
            LOG.warn((Object)("Clock skew; merging regions id are " + a.getRegionId() + " and " + b.getRegionId() + ", but current time here is " + rid));
            rid = Math.max(a.getRegionId(), b.getRegionId()) + 1L;
        }
        byte[] startKey = null;
        byte[] endKey = null;
        startKey = a.compareTo(b) <= 0 ? a.getStartKey() : b.getStartKey();
        endKey = Bytes.equals((byte[])a.getEndKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) || !Bytes.equals((byte[])b.getEndKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) && Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getEndKey()) > 0 ? a.getEndKey() : b.getEndKey();
        HRegionInfo mergedRegionInfo = new HRegionInfo(a.getTable(), startKey, endKey, false, rid);
        return mergedRegionInfo;
    }

    void openMergedRegion(Server server, RegionServerServices services, HRegion merged) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info((Object)("Not opening merged region  " + merged.getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped));
            return;
        }
        HRegionInfo hri = merged.getRegionInfo();
        SplitTransaction.LoggingProgressable reporter = server == null ? null : new SplitTransaction.LoggingProgressable(hri, server.getConfiguration().getLong("hbase.regionserver.regionmerge.open.log.interval", 10000L));
        merged.openHRegion(reporter);
        if (services != null) {
            try {
                services.postOpenDeployTasks(merged, server.getCatalogTracker(0));
                services.addToOnlineRegions(merged);
            }
            catch (KeeperException ke) {
                throw new IOException(ke);
            }
        }
    }

    void transitionZKNode(Server server, RegionServerServices services, HRegion mergedRegion) throws IOException {
        if (server == null || server.getZooKeeper() == null) {
            return;
        }
        try {
            this.znodeVersion = RegionMergeTransaction.transitionMergingNode(server.getZooKeeper(), this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_MERGING, EventType.RS_ZK_REGION_MERGED);
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            int spins = 0;
            do {
                if (spins % 10 == 0) {
                    LOG.debug((Object)("Still waiting on the master to process the merge for " + this.mergedRegionInfo.getEncodedName() + ", waited " + (EnvironmentEdgeManager.currentTimeMillis() - startTime) + "ms"));
                }
                Thread.sleep(100L);
                this.znodeVersion = RegionMergeTransaction.transitionMergingNode(server.getZooKeeper(), this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_MERGED, EventType.RS_ZK_REGION_MERGED);
                ++spins;
            } while (this.znodeVersion != -1 && !server.isStopped() && !services.isStopping());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed telling master about merge " + this.mergedRegionInfo.getEncodedName(), e);
        }
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.postMerge(this.region_a, this.region_b, mergedRegion);
        }
    }

    private int getZKNode(Server server, RegionServerServices services) throws IOException {
        try {
            int spins = 0;
            Stat stat = new Stat();
            ZooKeeperWatcher zkw = server.getZooKeeper();
            ServerName expectedServer = server.getServerName();
            String node = this.mergedRegionInfo.getEncodedName();
            while (!server.isStopped() && !services.isStopping()) {
                if (spins % 5 == 0) {
                    LOG.debug((Object)("Still waiting for master to process the pending_merge for " + node));
                    RegionMergeTransaction.transitionMergingNode(zkw, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), expectedServer, -1, EventType.RS_ZK_REQUEST_REGION_MERGE, EventType.RS_ZK_REQUEST_REGION_MERGE);
                }
                Thread.sleep(100L);
                ++spins;
                byte[] data = ZKAssign.getDataNoWatch((ZooKeeperWatcher)zkw, (String)node, (Stat)stat);
                if (data == null) {
                    throw new IOException("Data is null, merging node " + node + " no longer exists");
                }
                RegionTransition rt = RegionTransition.parseFrom((byte[])data);
                EventType et = rt.getEventType();
                if (et == EventType.RS_ZK_REGION_MERGING) {
                    ServerName serverName = rt.getServerName();
                    if (!serverName.equals((Object)expectedServer)) {
                        throw new IOException("Merging node " + node + " is for " + serverName + ", not us " + expectedServer);
                    }
                    byte[] payloadOfMerging = rt.getPayload();
                    List mergingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfMerging, (int)0, (int)payloadOfMerging.length);
                    assert (mergingRegions.size() == 3);
                    HRegionInfo a = (HRegionInfo)mergingRegions.get(1);
                    HRegionInfo b = (HRegionInfo)mergingRegions.get(2);
                    HRegionInfo hri_a = this.region_a.getRegionInfo();
                    HRegionInfo hri_b = this.region_b.getRegionInfo();
                    if (!hri_a.equals((Object)a) || !hri_b.equals((Object)b)) {
                        throw new IOException("Merging node " + node + " is for " + a + ", " + b + ", not expected regions: " + hri_a + ", " + hri_b);
                    }
                    return stat.getVersion();
                }
                if (et == EventType.RS_ZK_REQUEST_REGION_MERGE) continue;
                throw new IOException("Merging node " + node + " moved out of merging to " + et);
            }
            throw new IOException("Server is " + (services.isStopping() ? "stopping" : "stopped"));
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed getting MERGING znode on " + this.mergedRegionInfo.getRegionNameAsString(), e);
        }
    }

    private void mergeStoreFiles(Map<byte[], List<StoreFile>> hstoreFilesOfRegionA, Map<byte[], List<StoreFile>> hstoreFilesOfRegionB) throws IOException {
        HRegionFileSystem fs_a = this.region_a.getRegionFileSystem();
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesOfRegionA.entrySet()) {
            String familyName = Bytes.toString((byte[])entry.getKey());
            for (StoreFile storeFile : entry.getValue()) {
                fs_a.mergeStoreFile(this.mergedRegionInfo, familyName, storeFile, this.mergesdir);
            }
        }
        HRegionFileSystem fs_b = this.region_b.getRegionFileSystem();
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesOfRegionB.entrySet()) {
            String familyName = Bytes.toString((byte[])entry.getKey());
            for (StoreFile storeFile : entry.getValue()) {
                fs_b.mergeStoreFile(this.mergedRegionInfo, familyName, storeFile, this.mergesdir);
            }
        }
    }

    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        assert (this.mergedRegionInfo != null);
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.preRollBackMerge(this.region_a, this.region_b);
        }
        boolean result = true;
        ListIterator<JournalEntry> iterator = this.journal.listIterator(this.journal.size());
        block14: while (iterator.hasPrevious()) {
            JournalEntry je = iterator.previous();
            switch (je) {
                case SET_MERGING_IN_ZK: {
                    if (server == null || server.getZooKeeper() == null) continue block14;
                    RegionMergeTransaction.cleanZK(server, this.mergedRegionInfo);
                    continue block14;
                }
                case CREATED_MERGE_DIR: {
                    this.region_a.writestate.writesEnabled = true;
                    this.region_b.writestate.writesEnabled = true;
                    this.region_a.getRegionFileSystem().cleanupMergesDir();
                    continue block14;
                }
                case CLOSED_REGION_A: {
                    try {
                        this.region_a.initialize();
                        continue block14;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_REGION_A of region " + this.region_a.getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case OFFLINED_REGION_A: {
                    if (services == null) continue block14;
                    services.addToOnlineRegions(this.region_a);
                    continue block14;
                }
                case CLOSED_REGION_B: {
                    try {
                        this.region_b.initialize();
                        continue block14;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_REGION_A of region " + this.region_b.getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case OFFLINED_REGION_B: {
                    if (services == null) continue block14;
                    services.addToOnlineRegions(this.region_b);
                    continue block14;
                }
                case STARTED_MERGED_REGION_CREATION: {
                    this.region_a.getRegionFileSystem().cleanupMergedRegion(this.mergedRegionInfo);
                    continue block14;
                }
                case PONR: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + (Object)((Object)je));
        }
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.postRollBackMerge(this.region_a, this.region_b);
        }
        return result;
    }

    HRegionInfo getMergedRegionInfo() {
        return this.mergedRegionInfo;
    }

    Path getMergesDir() {
        return this.mergesdir;
    }

    private static void cleanZK(Server server, HRegionInfo hri) {
        try {
            if (!ZKAssign.deleteNode((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REQUEST_REGION_MERGE, (ServerName)server.getServerName())) {
                ZKAssign.deleteNode((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REGION_MERGING, (ServerName)server.getServerName());
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info((Object)("Failed cleanup zk node of " + hri.getRegionNameAsString()), (Throwable)e);
        }
        catch (KeeperException e) {
            server.abort("Failed cleanup zk node of " + hri.getRegionNameAsString(), (Throwable)e);
        }
    }

    public static void createNodeMerging(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, HRegionInfo a, HRegionInfo b) throws KeeperException, IOException {
        LOG.debug((Object)zkw.prefix("Creating ephemeral node for " + region.getEncodedName() + " in PENDING_MERGE state"));
        byte[] payload = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{region, a, b});
        RegionTransition rt = RegionTransition.createRegionTransition((EventType)EventType.RS_ZK_REQUEST_REGION_MERGE, (byte[])region.getRegionName(), (ServerName)serverName, (byte[])payload);
        String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)region.getEncodedName());
        if (!ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)zkw, (String)node, (byte[])rt.toByteArray())) {
            throw new IOException("Failed create of ephemeral " + node);
        }
    }

    public static int transitionMergingNode(ZooKeeperWatcher zkw, HRegionInfo merged, HRegionInfo a, HRegionInfo b, ServerName serverName, int znodeVersion, EventType beginState, EventType endState) throws KeeperException, IOException {
        byte[] payload = HRegionInfo.toDelimitedByteArray((HRegionInfo[])new HRegionInfo[]{merged, a, b});
        return ZKAssign.transitionNode((ZooKeeperWatcher)zkw, (HRegionInfo)merged, (ServerName)serverName, (EventType)beginState, (EventType)endState, (int)znodeVersion, (byte[])payload);
    }

    boolean hasMergeQualifierInMeta(RegionServerServices services, byte[] regionName) throws IOException {
        if (services == null) {
            return false;
        }
        Pair mergeRegions = MetaReader.getRegionsFromMergeQualifier((CatalogTracker)services.getCatalogTracker(0), (byte[])regionName);
        return mergeRegions != null && (mergeRegions.getFirst() != null || mergeRegions.getSecond() != null);
    }

    static enum JournalEntry {
        SET_MERGING_IN_ZK,
        CREATED_MERGE_DIR,
        CLOSED_REGION_A,
        OFFLINED_REGION_A,
        CLOSED_REGION_B,
        OFFLINED_REGION_B,
        STARTED_MERGED_REGION_CREATION,
        PONR;

    }
}

