/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.snapshot;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.RegionServerProcedureManager;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.SubprocedureFactory;
import org.apache.hadoop.hbase.procedure.ZKProcedureMemberRpcs;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.snapshot.FlushSnapshotSubprocedure;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RegionServerSnapshotManager
extends RegionServerProcedureManager {
    private static final Log LOG = LogFactory.getLog(RegionServerSnapshotManager.class);
    private static final String CONCURENT_SNAPSHOT_TASKS_KEY = "hbase.snapshot.region.concurrentTasks";
    private static final int DEFAULT_CONCURRENT_SNAPSHOT_TASKS = 3;
    public static final String SNAPSHOT_REQUEST_THREADS_KEY = "hbase.snapshot.region.pool.threads";
    public static final int SNAPSHOT_REQUEST_THREADS_DEFAULT = 10;
    public static final String SNAPSHOT_TIMEOUT_MILLIS_KEY = "hbase.snapshot.region.timeout";
    public static final long SNAPSHOT_TIMEOUT_MILLIS_DEFAULT = 60000L;
    public static final String SNAPSHOT_REQUEST_WAKE_MILLIS_KEY = "hbase.snapshot.region.wakefrequency";
    private static final long SNAPSHOT_REQUEST_WAKE_MILLIS_DEFAULT = 500L;
    private RegionServerServices rss;
    private ProcedureMemberRpcs memberRpcs;
    private ProcedureMember member;

    RegionServerSnapshotManager(Configuration conf, HRegionServer parent, ProcedureMemberRpcs memberRpc, ProcedureMember procMember) {
        this.rss = parent;
        this.memberRpcs = memberRpc;
        this.member = procMember;
    }

    public RegionServerSnapshotManager() {
    }

    @Override
    public void start() {
        LOG.debug((Object)("Start Snapshot Manager " + this.rss.getServerName().toString()));
        this.memberRpcs.start(this.rss.getServerName().toString(), this.member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean force) throws IOException {
        String mode = force ? "abruptly" : "gracefully";
        LOG.info((Object)("Stopping RegionServerSnapshotManager " + mode + "."));
        try {
            this.member.close();
        }
        finally {
            this.memberRpcs.close();
        }
    }

    public Subprocedure buildSubprocedure(HBaseProtos.SnapshotDescription snapshot) {
        List<HRegion> involvedRegions;
        if (this.rss.isStopping() || this.rss.isStopped()) {
            throw new IllegalStateException("Can't start snapshot on RS: " + this.rss.getServerName() + ", because stopping/stopped!");
        }
        try {
            involvedRegions = this.getRegionsToSnapshot(snapshot);
        }
        catch (IOException e1) {
            throw new IllegalStateException("Failed to figure out if we should handle a snapshot - something has gone awry with the online regions.", e1);
        }
        LOG.debug((Object)("Launching subprocedure for snapshot " + snapshot.getName() + " from table " + snapshot.getTable()));
        ForeignExceptionDispatcher exnDispatcher = new ForeignExceptionDispatcher(snapshot.getName());
        Configuration conf = this.rss.getConfiguration();
        long timeoutMillis = conf.getLong(SNAPSHOT_TIMEOUT_MILLIS_KEY, 60000L);
        long wakeMillis = conf.getLong(SNAPSHOT_REQUEST_WAKE_MILLIS_KEY, 500L);
        switch (snapshot.getType()) {
            case FLUSH: {
                SnapshotSubprocedurePool taskManager = new SnapshotSubprocedurePool(this.rss.getServerName().toString(), conf);
                return new FlushSnapshotSubprocedure(this.member, exnDispatcher, wakeMillis, timeoutMillis, involvedRegions, snapshot, taskManager);
            }
            case SKIPFLUSH: {
                SnapshotSubprocedurePool taskManager2 = new SnapshotSubprocedurePool(this.rss.getServerName().toString(), conf);
                return new FlushSnapshotSubprocedure(this.member, exnDispatcher, wakeMillis, timeoutMillis, involvedRegions, snapshot, taskManager2);
            }
        }
        throw new UnsupportedOperationException("Unrecognized snapshot type:" + snapshot.getType());
    }

    private List<HRegion> getRegionsToSnapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        List<HRegion> onlineRegions = this.rss.getOnlineRegions(TableName.valueOf((String)snapshot.getTable()));
        Iterator<HRegion> iterator = onlineRegions.iterator();
        while (iterator.hasNext()) {
            HRegion r = iterator.next();
            if (RegionReplicaUtil.isDefaultReplica((HRegionInfo)r.getRegionInfo())) continue;
            iterator.remove();
        }
        return onlineRegions;
    }

    @Override
    public void initialize(RegionServerServices rss) throws KeeperException {
        this.rss = rss;
        ZooKeeperWatcher zkw = rss.getZooKeeper();
        this.memberRpcs = new ZKProcedureMemberRpcs(zkw, "online-snapshot");
        Configuration conf = rss.getConfiguration();
        long keepAlive = conf.getLong(SNAPSHOT_TIMEOUT_MILLIS_KEY, 60000L);
        int opThreads = conf.getInt(SNAPSHOT_REQUEST_THREADS_KEY, 10);
        ThreadPoolExecutor pool = ProcedureMember.defaultPool(rss.getServerName().toString(), opThreads, keepAlive);
        this.member = new ProcedureMember(this.memberRpcs, pool, new SnapshotSubprocedureBuilder());
    }

    @Override
    public String getProcedureSignature() {
        return "online-snapshot";
    }

    static class SnapshotSubprocedurePool {
        private final ExecutorCompletionService<Void> taskPool;
        private final ThreadPoolExecutor executor;
        private volatile boolean stopped;
        private final List<Future<Void>> futures = new ArrayList<Future<Void>>();
        private final String name;

        SnapshotSubprocedurePool(String name, Configuration conf) {
            long keepAlive = conf.getLong(RegionServerSnapshotManager.SNAPSHOT_TIMEOUT_MILLIS_KEY, 60000L);
            int threads = conf.getInt(RegionServerSnapshotManager.CONCURENT_SNAPSHOT_TASKS_KEY, 3);
            this.name = name;
            this.executor = new ThreadPoolExecutor(1, threads, keepAlive, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("rs(" + name + ")-snapshot-pool"));
            this.taskPool = new ExecutorCompletionService(this.executor);
        }

        boolean hasTasks() {
            return this.futures.size() != 0;
        }

        void submitTask(Callable<Void> task) {
            Future<Void> f = this.taskPool.submit(task);
            this.futures.add(f);
        }

        boolean waitForOutstandingTasks() throws ForeignException, InterruptedException {
            LOG.debug((Object)"Waiting for local region snapshots to finish.");
            int sz = this.futures.size();
            try {
                int i;
                for (i = 0; i < sz; ++i) {
                    Future<Void> f = this.taskPool.take();
                    f.get();
                    if (!this.futures.remove(f)) {
                        LOG.warn((Object)("unexpected future" + f));
                    }
                    LOG.debug((Object)("Completed " + (i + 1) + "/" + sz + " local region snapshots."));
                }
                LOG.debug((Object)("Completed " + sz + " local region snapshots."));
                i = 1;
                return i != 0;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Got InterruptedException in SnapshotSubprocedurePool", (Throwable)e);
                if (!this.stopped) {
                    Thread.currentThread().interrupt();
                    throw new ForeignException("SnapshotSubprocedurePool", e);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ForeignException) {
                    LOG.warn((Object)"Rethrowing ForeignException from SnapshotSubprocedurePool", (Throwable)e);
                    throw (ForeignException)e.getCause();
                }
                LOG.warn((Object)"Got Exception in SnapshotSubprocedurePool", (Throwable)e);
                throw new ForeignException(this.name, e.getCause());
            }
            finally {
                this.cancelTasks();
            }
            return false;
        }

        void cancelTasks() throws InterruptedException {
            List<Future<Void>> tasks = this.futures;
            LOG.debug((Object)("cancelling " + tasks.size() + " tasks for snapshot " + this.name));
            for (Future future : tasks) {
                future.cancel(false);
            }
            this.futures.clear();
            while (this.taskPool.poll() != null) {
            }
            this.stop();
        }

        void stop() {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            this.executor.shutdownNow();
        }
    }

    public class SnapshotSubprocedureBuilder
    implements SubprocedureFactory {
        @Override
        public Subprocedure buildSubprocedure(String name, byte[] data) {
            try {
                HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.parseFrom((byte[])data);
                return RegionServerSnapshotManager.this.buildSubprocedure(snapshot);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Could not read snapshot information from request.");
            }
        }
    }
}

