/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public class WALCellCodec
implements Codec {
    public static final String WAL_CELL_CODEC_CLASS_KEY = "hbase.regionserver.wal.codec";
    protected final CompressionContext compression;
    protected final ByteStringUncompressor statelessUncompressor = new ByteStringUncompressor(){

        @Override
        public byte[] uncompress(ByteString data, Dictionary dict) throws IOException {
            return WALCellCodec.uncompressByteString(data, dict);
        }
    };

    public WALCellCodec() {
        this.compression = null;
    }

    public WALCellCodec(Configuration conf, CompressionContext compression) {
        this.compression = compression;
    }

    static String getWALCellCodecClass(Configuration conf) {
        return conf.get(WAL_CELL_CODEC_CLASS_KEY, WALCellCodec.class.getName());
    }

    public static WALCellCodec create(Configuration conf, String cellCodecClsName, CompressionContext compression) throws UnsupportedOperationException {
        if (cellCodecClsName == null) {
            cellCodecClsName = WALCellCodec.getWALCellCodecClass(conf);
        }
        return (WALCellCodec)ReflectionUtils.instantiateWithCustomCtor((String)cellCodecClsName, (Class[])new Class[]{Configuration.class, CompressionContext.class}, (Object[])new Object[]{conf, compression});
    }

    public static WALCellCodec create(Configuration conf, CompressionContext compression) throws UnsupportedOperationException {
        String cellCodecClsName = WALCellCodec.getWALCellCodecClass(conf);
        return (WALCellCodec)ReflectionUtils.instantiateWithCustomCtor((String)cellCodecClsName, (Class[])new Class[]{Configuration.class, CompressionContext.class}, (Object[])new Object[]{conf, compression});
    }

    private static byte[] uncompressByteString(ByteString bs, Dictionary dict) throws IOException {
        InputStream in = bs.newInput();
        byte status = (byte)in.read();
        if (status == -1) {
            byte[] arr = new byte[StreamUtils.readRawVarint32((InputStream)in)];
            int bytesRead = in.read(arr);
            if (bytesRead != arr.length) {
                throw new IOException("Cannot read; wanted " + arr.length + ", but got " + bytesRead);
            }
            if (dict != null) {
                dict.addEntry(arr, 0, arr.length);
            }
            return arr;
        }
        short dictIdx = StreamUtils.toShort((byte)status, (byte)((byte)in.read()));
        byte[] entry = dict.getEntry(dictIdx);
        if (entry == null) {
            throw new IOException("Missing dictionary entry for index " + dictIdx);
        }
        return entry;
    }

    public Codec.Decoder getDecoder(InputStream is) {
        return this.compression == null ? new KeyValueCodec.KeyValueDecoder(is) : new CompressedKvDecoder(is, this.compression);
    }

    public Codec.Encoder getEncoder(OutputStream os) {
        return this.compression == null ? new EnsureKvEncoder(os) : new CompressedKvEncoder(os, this.compression);
    }

    public ByteStringCompressor getByteStringCompressor() {
        return new BaosAndCompressor();
    }

    public ByteStringUncompressor getByteStringUncompressor() {
        return this.statelessUncompressor;
    }

    public class EnsureKvEncoder
    extends BaseEncoder {
        public EnsureKvEncoder(OutputStream out) {
            super(out);
        }

        public void write(Cell cell) throws IOException {
            if (!(cell instanceof KeyValue)) {
                throw new IOException("Cannot write non-KV cells to WAL");
            }
            this.checkFlushed();
            KeyValue.oswrite((KeyValue)((KeyValue)cell), (OutputStream)this.out, (boolean)true);
        }
    }

    static class CompressedKvDecoder
    extends BaseDecoder {
        private final CompressionContext compression;

        public CompressedKvDecoder(InputStream in, CompressionContext compression) {
            super(in);
            this.compression = compression;
        }

        protected Cell parseCell() throws IOException {
            int keylength = StreamUtils.readRawVarint32((InputStream)this.in);
            int vlength = StreamUtils.readRawVarint32((InputStream)this.in);
            int tagsLength = StreamUtils.readRawVarint32((InputStream)this.in);
            int length = 0;
            length = tagsLength == 0 ? 8 + keylength + vlength : 10 + keylength + vlength + tagsLength;
            byte[] backingArray = new byte[length];
            int pos = 0;
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)keylength);
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)vlength);
            int elemLen = this.readIntoArray(backingArray, pos + 2, this.compression.rowDict);
            CompressedKvDecoder.checkLength(elemLen, Short.MAX_VALUE);
            pos = Bytes.putShort((byte[])backingArray, (int)pos, (short)((short)elemLen));
            pos += elemLen;
            elemLen = this.readIntoArray(backingArray, pos + 1, this.compression.familyDict);
            CompressedKvDecoder.checkLength(elemLen, 127);
            pos = Bytes.putByte((byte[])backingArray, (int)pos, (byte)((byte)elemLen));
            pos += elemLen;
            elemLen = this.readIntoArray(backingArray, pos, this.compression.qualifierDict);
            int tsTypeValLen = length - (pos += elemLen);
            if (tagsLength > 0) {
                tsTypeValLen = tsTypeValLen - tagsLength - 2;
            }
            IOUtils.readFully((InputStream)this.in, (byte[])backingArray, (int)pos, (int)tsTypeValLen);
            pos += tsTypeValLen;
            if (tagsLength > 0) {
                pos = Bytes.putAsShort((byte[])backingArray, (int)pos, (int)tagsLength);
                if (this.compression.tagCompressionContext != null) {
                    this.compression.tagCompressionContext.uncompressTags(this.in, backingArray, pos, tagsLength);
                } else {
                    IOUtils.readFully((InputStream)this.in, (byte[])backingArray, (int)pos, (int)tagsLength);
                }
            }
            return new KeyValue(backingArray, 0, length);
        }

        private int readIntoArray(byte[] to, int offset, Dictionary dict) throws IOException {
            byte status = (byte)this.in.read();
            if (status == -1) {
                int length = StreamUtils.readRawVarint32((InputStream)this.in);
                IOUtils.readFully((InputStream)this.in, (byte[])to, (int)offset, (int)length);
                dict.addEntry(to, offset, length);
                return length;
            }
            short dictIdx = StreamUtils.toShort((byte)status, (byte)((byte)this.in.read()));
            byte[] entry = dict.getEntry(dictIdx);
            if (entry == null) {
                throw new IOException("Missing dictionary entry for index " + dictIdx);
            }
            Bytes.putBytes((byte[])to, (int)offset, (byte[])entry, (int)0, (int)entry.length);
            return entry.length;
        }

        private static void checkLength(int len, int max) throws IOException {
            if (len < 0 || len > max) {
                throw new IOException("Invalid length for compresesed portion of keyvalue: " + len);
            }
        }
    }

    static class CompressedKvEncoder
    extends BaseEncoder {
        private final CompressionContext compression;

        public CompressedKvEncoder(OutputStream out, CompressionContext compression) {
            super(out);
            this.compression = compression;
        }

        public void write(Cell cell) throws IOException {
            if (!(cell instanceof KeyValue)) {
                throw new IOException("Cannot write non-KV cells to WAL");
            }
            KeyValue kv = (KeyValue)cell;
            byte[] kvBuffer = kv.getBuffer();
            int offset = kv.getOffset();
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)kv.getKeyLength());
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)kv.getValueLength());
            int tagsLength = kv.getTagsLengthUnsigned();
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)tagsLength);
            this.write(kvBuffer, kv.getRowOffset(), kv.getRowLength(), this.compression.rowDict);
            this.write(kvBuffer, kv.getFamilyOffset(), kv.getFamilyLength(), this.compression.familyDict);
            this.write(kvBuffer, kv.getQualifierOffset(), kv.getQualifierLength(), this.compression.qualifierDict);
            int pos = kv.getTimestampOffset();
            int tsTypeValLen = kv.getLength() + offset - pos;
            if (tagsLength > 0) {
                tsTypeValLen = tsTypeValLen - tagsLength - 2;
            }
            assert (tsTypeValLen > 0);
            this.out.write(kvBuffer, pos, tsTypeValLen);
            if (tagsLength > 0) {
                if (this.compression.tagCompressionContext != null) {
                    this.compression.tagCompressionContext.compressTags(this.out, kvBuffer, kv.getTagsOffset(), tagsLength);
                } else {
                    this.out.write(kvBuffer, kv.getTagsOffset(), tagsLength);
                }
            }
        }

        private void write(byte[] data, int offset, int length, Dictionary dict) throws IOException {
            short dictIdx = -1;
            if (dict != null) {
                dictIdx = dict.findEntry(data, offset, length);
            }
            if (dictIdx == -1) {
                this.out.write(-1);
                StreamUtils.writeRawVInt32((OutputStream)this.out, (int)length);
                this.out.write(data, offset, length);
            } else {
                StreamUtils.writeShort((OutputStream)this.out, (short)dictIdx);
            }
        }
    }

    static class BaosAndCompressor
    extends ByteArrayOutputStream
    implements ByteStringCompressor {
        BaosAndCompressor() {
        }

        public ByteString toByteString() {
            return ByteString.copyFrom((byte[])this.buf, (int)0, (int)this.count);
        }

        @Override
        public ByteString compress(byte[] data, Dictionary dict) throws IOException {
            this.writeCompressed(data, dict);
            ByteString result = ByteString.copyFrom((byte[])this.buf, (int)0, (int)this.count);
            this.reset();
            return result;
        }

        private void writeCompressed(byte[] data, Dictionary dict) throws IOException {
            assert (dict != null);
            short dictIdx = dict.findEntry(data, 0, data.length);
            if (dictIdx == -1) {
                this.write(-1);
                StreamUtils.writeRawVInt32((OutputStream)this, (int)data.length);
                this.write(data, 0, data.length);
            } else {
                StreamUtils.writeShort((OutputStream)this, (short)dictIdx);
            }
        }
    }

    public static interface ByteStringUncompressor {
        public byte[] uncompress(ByteString var1, Dictionary var2) throws IOException;
    }

    public static interface ByteStringCompressor {
        public ByteString compress(byte[] var1, Dictionary var2) throws IOException;
    }
}

