/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ReplicationLogCleaner
extends BaseLogCleanerDelegate
implements Abortable {
    private static final Log LOG = LogFactory.getLog(ReplicationLogCleaner.class);
    private ZooKeeperWatcher zkw;
    private ReplicationQueuesClient replicationQueues;
    private boolean stopped = false;
    private boolean aborted;

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        if (this.getConf() == null) {
            return files;
        }
        final Set<String> hlogs = this.loadHLogsFromQueues();
        return Iterables.filter(files, (Predicate)new Predicate<FileStatus>(){

            public boolean apply(FileStatus file) {
                String hlog = file.getPath().getName();
                boolean logInReplicationQueue = hlogs.contains(hlog);
                if (LOG.isDebugEnabled()) {
                    if (logInReplicationQueue) {
                        LOG.debug((Object)("Found log in ZK, keeping: " + hlog));
                    } else {
                        LOG.debug((Object)("Didn't find this log in ZK, deleting: " + hlog));
                    }
                }
                return !logInReplicationQueue;
            }
        });
    }

    private Set<String> loadHLogsFromQueues() {
        List rss = this.replicationQueues.getListOfReplicators();
        if (rss == null) {
            LOG.debug((Object)"Didn't find any region server that replicates, won't prevent any deletions.");
            return ImmutableSet.of();
        }
        HashSet hlogs = Sets.newHashSet();
        for (String rs : rss) {
            List listOfPeers = this.replicationQueues.getAllQueues(rs);
            if (listOfPeers == null) continue;
            for (String id : listOfPeers) {
                List peersHlogs = this.replicationQueues.getLogsInQueue(rs, id);
                if (peersHlogs == null) continue;
                hlogs.addAll(peersHlogs);
            }
        }
        return hlogs;
    }

    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication", true)) {
            LOG.warn((Object)"Not configured - allowing all hlogs to be deleted");
            return;
        }
        Configuration conf = new Configuration(config);
        super.setConf(conf);
        try {
            this.zkw = new ZooKeeperWatcher(conf, "replicationLogCleaner", null);
            this.replicationQueues = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)this.zkw, (Configuration)conf, (Abortable)this);
            this.replicationQueues.init();
        }
        catch (ReplicationException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkw != null) {
            LOG.info((Object)("Stopping " + this.zkw));
            this.zkw.close();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void abort(String why, Throwable e) {
        LOG.warn((Object)("Aborting ReplicationLogCleaner because " + why), e);
        this.aborted = true;
        this.stop(why);
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

