/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class AccessController
extends BaseRegionObserver
implements MasterObserver,
RegionServerObserver,
AccessControlProtos.AccessControlService.Interface,
CoprocessorService,
EndpointObserver,
BulkLoadObserver {
    public static final Log LOG = LogFactory.getLog(AccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + AccessController.class.getName()));
    private static final String CHECK_COVERING_PERM = "check_covering_perm";
    private static final String TAG_CHECK_PASSED = "tag_check_passed";
    private static final byte[] TRUE = Bytes.toBytes((boolean)true);
    TableAuthManager authManager = null;
    boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private UserProvider userProvider;
    private List<String> superusers;
    boolean cellFeaturesEnabled;
    boolean shouldCheckExecPermission;
    boolean compatibleEarlyTermination;
    private volatile boolean initialized = false;
    private volatile boolean aclTabAvailable = false;

    public HRegion getRegion() {
        return this.regionEnv != null ? this.regionEnv.getRegion() : null;
    }

    public TableAuthManager getAuthManager() {
        return this.authManager;
    }

    void initialize(RegionCoprocessorEnvironment e) throws IOException {
        HRegion region = e.getRegion();
        Configuration conf = e.getConfiguration();
        Map<byte[], ListMultimap<String, TablePermission>> tables = AccessControlLists.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, TablePermission>> t : tables.entrySet()) {
            byte[] entry = t.getKey();
            ListMultimap<String, TablePermission> perms = t.getValue();
            byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
            this.authManager.getZKPermissionWatcher().writeToZookeeper(entry, serialized);
        }
        this.initialized = true;
    }

    void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<Cell>> familyMap) {
        TreeSet<byte[]> entries = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        for (Map.Entry<byte[], List<Cell>> f : familyMap.entrySet()) {
            List<Cell> cells = f.getValue();
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (!Bytes.equals((byte[])kv.getBuffer(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])AccessControlLists.ACL_LIST_FAMILY, (int)0, (int)AccessControlLists.ACL_LIST_FAMILY.length)) continue;
                entries.add(kv.getRow());
            }
        }
        ZKPermissionWatcher zkw = this.authManager.getZKPermissionWatcher();
        Configuration conf = this.regionEnv.getConfiguration();
        for (byte[] entry : entries) {
            try {
                ListMultimap<String, TablePermission> perms = AccessControlLists.getPermissions(conf, entry);
                byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
                zkw.writeToZookeeper(entry, serialized);
            }
            catch (IOException ex) {
                LOG.error((Object)("Failed updating permissions mirror for '" + Bytes.toString((byte[])entry) + "'"), (Throwable)ex);
            }
        }
    }

    AuthResult permissionGranted(String request, User user, Permission.Action permRequest, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families) {
        HRegionInfo hri = e.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (hri.isMetaRegion() && permRequest == Permission.Action.READ) {
            return AuthResult.allow(request, "All users allowed", user, permRequest, tableName, families);
        }
        if (user == null) {
            return AuthResult.deny(request, "No user associated with request!", null, permRequest, tableName, families);
        }
        if (permRequest == Permission.Action.WRITE && (hri.isMetaRegion() || Bytes.equals((byte[])tableName.getName(), (byte[])AccessControlLists.ACL_GLOBAL_NAME)) && (this.authManager.authorize(user, Permission.Action.CREATE) || this.authManager.authorize(user, Permission.Action.ADMIN))) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (this.authManager.authorize(user, tableName, (byte[])null, permRequest)) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.authManager.authorize(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.authManager.authorize(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), qualifier));
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List kvList = (List)family.getValue();
                    for (KeyValue kv : kvList) {
                        if (this.authManager.authorize(user, tableName, family.getKey(), kv.getQualifier(), permRequest)) continue;
                        return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), kv.getQualifier()));
                    }
                    continue;
                }
                return AuthResult.deny(request, "Failed family check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), null));
            }
            return AuthResult.allow(request, "All family checks passed", user, permRequest, tableName, families);
        }
        return AuthResult.deny(request, "No families to check and table permission failed", user, permRequest, tableName, families);
    }

    AuthResult permissionGranted(OpType opType, User user, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families, Permission.Action ... actions) {
        AuthResult result = null;
        for (Permission.Action action : actions) {
            result = this.permissionGranted(opType.toString(), user, action, e, families);
            if (result.isAllowed()) continue;
            return result;
        }
        return result;
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            RequestContext ctx = RequestContext.get();
            InetAddress remoteAddr = null;
            if (ctx != null) {
                remoteAddr = ctx.getRemoteAddress();
            }
            AUDITLOG.trace((Object)("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString()));
        }
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    private void requirePermission(String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requirePermission(String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(request, perm, null, null);
    }

    private void requirePermission(String request, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> families) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = this.permissionGranted(request, user, perm, env, families);
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + env.getRegion().getTableDesc().getTableName() + (families != null && families.size() > 0 ? ", family: " + result.toFamilyString() : "") + ", action=" + perm.toString() + ")");
        }
    }

    private void requireGlobalPermission(String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        User user = this.getActiveUser();
        if (!(this.authManager.authorize(user, perm) || tableName != null && this.authManager.authorize(user, tableName.getNamespaceAsString(), perm))) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap));
    }

    private void requireGlobalPermission(String request, Permission.Action perm, String namespace) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, namespace));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, namespace));
    }

    private boolean hasFamilyQualifierPermission(User user, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        HRegionInfo hri = env.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (user == null) {
            return false;
        }
        if (familyMap != null && familyMap.size() > 0) {
            for (Map.Entry<byte[], ? extends Collection<byte[]>> family : familyMap.entrySet()) {
                if (family.getValue() != null && !family.getValue().isEmpty()) {
                    for (byte[] qualifier : family.getValue()) {
                        if (!this.authManager.matchPermission(user, tableName, family.getKey(), qualifier, perm)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.authManager.matchPermission(user, tableName, family.getKey(), perm)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Empty family map passed for permission check");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCoveringPermission(OpType request, RegionCoprocessorEnvironment e, byte[] row, Map<byte[], ? extends Collection<?>> familyMap, long opTs, Permission.Action ... actions) throws IOException {
        boolean considerCellTs;
        if (!this.cellFeaturesEnabled) {
            return false;
        }
        long cellGrants = 0L;
        User user = this.getActiveUser();
        long latestCellTs = 0L;
        Get get = new Get(row);
        boolean bl = considerCellTs = request == OpType.PUT || request == OpType.DELETE;
        if (considerCellTs) {
            get.setMaxVersions();
        } else {
            get.setMaxVersions(1);
        }
        boolean diffCellTsFromOpTs = false;
        for (Map.Entry<byte[], Collection<?>> entry : familyMap.entrySet()) {
            byte[] col = entry.getKey();
            if (entry.getValue() instanceof Set) {
                Set set = (Set)entry.getValue();
                if (set == null || set.isEmpty()) {
                    get.addFamily(col);
                    continue;
                }
                for (byte[] qual : set) {
                    get.addColumn(col, qual);
                }
                continue;
            }
            if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                if (list == null || list.isEmpty()) {
                    get.addFamily(col);
                    continue;
                }
                for (Cell cell : list) {
                    if (cell.getQualifierLength() == 0 && (cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode())) {
                        get.addFamily(col);
                    } else {
                        get.addColumn(col, CellUtil.cloneQualifier((Cell)cell));
                    }
                    if (!considerCellTs) continue;
                    long cellTs = cell.getTimestamp();
                    latestCellTs = Math.max(latestCellTs, cellTs);
                    diffCellTsFromOpTs = diffCellTsFromOpTs || opTs != cellTs;
                }
                continue;
            }
            throw new RuntimeException("Unhandled collection type " + entry.getValue().getClass().getName());
        }
        long latestTs = Math.max(opTs, latestCellTs);
        if (latestTs == 0L || latestTs == Long.MAX_VALUE) {
            latestTs = EnvironmentEdgeManager.currentTimeMillis();
        }
        get.setTimeRange(0L, latestTs + 1L);
        if (!diffCellTsFromOpTs && request == OpType.PUT) {
            get.setMaxVersions(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Scanning for cells with " + get));
        }
        HashMap<SimpleByteRange, List> familyMap1 = new HashMap<SimpleByteRange, List>();
        for (Map.Entry<byte[], Collection<?>> entry : familyMap.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            familyMap1.put(new SimpleByteRange(entry.getKey()), (List)entry.getValue());
        }
        RegionScanner scanner = this.getRegion(e).getScanner(new Scan(get));
        ArrayList cells = Lists.newArrayList();
        Cell prevCell = null;
        SimpleByteRange curFam = new SimpleByteRange();
        boolean curColAllVersions = request == OpType.DELETE;
        long curColCheckTs = opTs;
        boolean foundColumn = false;
        try {
            boolean more = false;
            do {
                cells.clear();
                more = scanner.next(cells, 1);
                for (Cell cell : cells) {
                    boolean colChange;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Found cell " + cell));
                    }
                    boolean bl2 = colChange = prevCell == null || !CellUtil.matchingColumn(prevCell, (Cell)cell);
                    if (colChange) {
                        foundColumn = false;
                    }
                    prevCell = cell;
                    if (!curColAllVersions && foundColumn) continue;
                    if (colChange && considerCellTs) {
                        curFam.set(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
                        List cols = (List)familyMap1.get(curFam);
                        for (Cell col : cols) {
                            if ((col.getQualifierLength() != 0 || request != OpType.DELETE) && !CellUtil.matchingQualifier((Cell)cell, (Cell)col)) continue;
                            byte type = col.getTypeByte();
                            if (considerCellTs) {
                                curColCheckTs = col.getTimestamp();
                            }
                            curColAllVersions = KeyValue.Type.DeleteColumn.getCode() == type || KeyValue.Type.DeleteFamily.getCode() == type;
                            break;
                        }
                    }
                    if (cell.getTimestamp() > curColCheckTs) continue;
                    foundColumn = true;
                    for (Permission.Action action : actions) {
                        if (this.authManager.authorize(user, this.getTableName(e), cell, action)) continue;
                        boolean bl3 = false;
                        return bl3;
                    }
                    ++cellGrants;
                }
            } while (more);
        }
        catch (AccessDeniedException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error((Object)"Exception while getting cells to calculate covering permission", (Throwable)ex);
        }
        finally {
            scanner.close();
        }
        return cellGrants > 0L;
    }

    private static void addCellPermissions(byte[] perms, Map<byte[], List<Cell>> familyMap) {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            ArrayList newCells = Lists.newArrayList();
            for (Cell cell : e.getValue()) {
                ArrayList tags = Lists.newArrayList((Object[])new Tag[]{new Tag(1, perms)});
                Iterator tagIterator = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
                while (tagIterator.hasNext()) {
                    tags.add(tagIterator.next());
                }
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                byte[] bytes = kv.getBuffer();
                newCells.add(new KeyValue(bytes, kv.getRowOffset(), (int)kv.getRowLength(), bytes, kv.getFamilyOffset(), (int)kv.getFamilyLength(), bytes, kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType((byte)kv.getTypeByte()), bytes, kv.getValueOffset(), kv.getValueLength(), (List)tags));
            }
            e.setValue(newCells);
        }
    }

    private void checkForReservedTagPresence(User user, Mutation m) throws IOException {
        if (this.superusers.contains(user.getShortName())) {
            return;
        }
        if (m.getAttribute(TAG_CHECK_PASSED) != null) {
            return;
        }
        CellScanner cellScanner = m.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            if (cell.getTagsLengthUnsigned() <= 0) continue;
            Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
            while (tagsItr.hasNext()) {
                if (((Tag)tagsItr.next()).getType() != 1) continue;
                throw new AccessDeniedException("Mutation contains cell with reserved type tag");
            }
        }
        m.setAttribute(TAG_CHECK_PASSED, TRUE);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        CompoundConfiguration conf = new CompoundConfiguration();
        conf.add(env.getConfiguration());
        this.shouldCheckExecPermission = conf.getBoolean("hbase.security.exec.permission.checks", false);
        boolean bl = this.cellFeaturesEnabled = HFile.getFormatVersion((Configuration)conf) >= 3;
        if (!this.cellFeaturesEnabled) {
            LOG.info((Object)"A minimum HFile version of 3 is required to persist cell ACLs. Consider setting hfile.format.version accordingly.");
        }
        ZooKeeperWatcher zk = null;
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            zk = mEnv.getMasterServices().getZooKeeper();
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            RegionServerCoprocessorEnvironment rsEnv = (RegionServerCoprocessorEnvironment)env;
            zk = rsEnv.getRegionServerServices().getZooKeeper();
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            conf.addStringMap(this.regionEnv.getRegion().getTableDesc().getConfiguration());
            zk = this.regionEnv.getRegionServerServices().getZooKeeper();
            this.compatibleEarlyTermination = conf.getBoolean("hbase.security.access.early_out", false);
        }
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
        User user = this.userProvider.getCurrent();
        this.superusers = Lists.asList((Object)user.getShortName(), (Object[])conf.getStrings("hbase.superuser", new String[0]));
        if (zk != null) {
            try {
                this.authManager = TableAuthManager.get(zk, env.getConfiguration());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining TableAuthManager", ioe);
            }
        } else {
            throw new RuntimeException("Error obtaining TableAuthManager, zk found null.");
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        Set families = desc.getFamiliesKeys();
        TreeMap<byte[], Object> familyMap = new TreeMap<byte[], Object>(Bytes.BYTES_COMPARATOR);
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requireGlobalPermission("createTable", Permission.Action.CREATE, desc.getTableName(), familyMap);
    }

    @Override
    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void postCreateTableHandler(final ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (AccessControlLists.isAclTable(desc)) {
            this.aclTabAvailable = true;
        } else if (!TableName.NAMESPACE_TABLE_NAME.equals((Object)desc.getTableName())) {
            if (!this.aclTabAvailable) {
                LOG.warn((Object)("Not adding owner permission for table " + desc.getTableName() + ". " + AccessControlLists.ACL_TABLE_NAME + " is not yet created. " + this.getClass().getSimpleName() + " should be configured as the first Coprocessor"));
            } else {
                String owner = desc.getOwnerString();
                if (owner == null) {
                    owner = this.getActiveUser().getShortName();
                }
                final UserPermission userperm = new UserPermission(Bytes.toBytes((String)owner), desc.getTableName(), null, Permission.Action.values());
                User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        AccessControlLists.addUserPermission(((MasterCoprocessorEnvironment)c.getEnvironment()).getConfiguration(), userperm);
                        return null;
                    }
                });
            }
        }
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("deleteTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName);
    }

    @Override
    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        this.requirePermission("modifyTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        String owner = htd.getOwnerString();
        if (owner == null) {
            owner = this.getActiveUser().getShortName();
        }
        UserPermission userperm = new UserPermission(Bytes.toBytes((String)owner), htd.getTableName(), null, Permission.Action.values());
        AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
    }

    @Override
    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
        this.requirePermission("addColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        this.requirePermission("modifyColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        this.requirePermission("deleteColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
    }

    @Override
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName, col);
    }

    @Override
    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("enableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (Bytes.equals((byte[])tableName.getName(), (byte[])AccessControlLists.ACL_GLOBAL_NAME)) {
            throw new AccessDeniedException("Not allowed to disable " + AccessControlLists.ACL_TABLE_NAME + " table.");
        }
        this.requirePermission("disableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission("move", region.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("assign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission("unassign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("regionOffline", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("balance", Permission.Action.ADMIN);
    }

    @Override
    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> c, List<RegionPlan> plans) throws IOException {
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission("balanceSwitch", Permission.Action.ADMIN);
        return newValue;
    }

    @Override
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean oldValue, boolean newValue) throws IOException {
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("shutdown", Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("stopMaster", Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (!MetaReader.tableExists((CatalogTracker)ctx.getEnvironment().getMasterServices().getCatalogTracker(0), (TableName)AccessControlLists.ACL_TABLE_NAME)) {
            AccessControlLists.init(ctx.getEnvironment().getMasterServices());
        } else {
            this.aclTabAvailable = true;
        }
    }

    @Override
    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("snapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("clone", Permission.Action.ADMIN);
    }

    @Override
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("restore", Permission.Action.ADMIN);
    }

    @Override
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.requirePermission("deleteSnapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    @Override
    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("createNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission("deleteNamespace", Permission.Action.ADMIN, namespace);
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        AccessControlLists.removeNamespacePermissions(ctx.getEnvironment().getConfiguration(), namespace);
        LOG.info((Object)(namespace + "entry deleted in " + AccessControlLists.ACL_TABLE_NAME + " table."));
    }

    @Override
    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("modifyNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        RegionCoprocessorEnvironment env = e.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            HRegionInfo regionInfo = region.getRegionInfo();
            if (regionInfo.getTable().isSystemTable()) {
                this.isSystemOrSuperUser(this.regionEnv.getConfiguration());
            } else {
                this.requirePermission("preOpen", Permission.Action.ADMIN);
            }
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        if (AccessControlLists.isAclRegion(region)) {
            this.aclRegion = true;
            if (!region.isRecovering()) {
                try {
                    this.initialize(env);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to initialize permissions cache", ex);
                }
            }
        } else {
            this.initialized = true;
        }
    }

    @Override
    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (this.aclRegion) {
            try {
                this.initialize(c.getEnvironment());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        }
    }

    @Override
    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("flush", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e, byte[] splitRow) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        return scanner;
    }

    @Override
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        assert (family != null);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, null);
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.GET_CLOSEST_ROW_BEFORE, user, env, families, Permission.Action.READ);
        if (!authResult.isAllowed() && this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            authResult.setAllowed(this.checkCoveringPermission(OpType.GET_CLOSEST_ROW_BEFORE, env, row, families, Long.MAX_VALUE, Permission.Action.READ));
            authResult.setReason("Covering cell set");
        }
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
        }
    }

    private void internalPreRead(ObserverContext<RegionCoprocessorEnvironment> c, Query query, OpType opType) throws IOException {
        Filter filter = query.getFilter();
        if (filter != null && filter instanceof AccessControlFilter) {
            return;
        }
        User user = this.getActiveUser();
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map families = null;
        switch (opType) {
            case GET: 
            case EXISTS: {
                families = ((Get)query).getFamilyMap();
                break;
            }
            case SCAN: {
                families = ((Scan)query).getFamilyMap();
                break;
            }
            default: {
                throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
            }
        }
        AuthResult authResult = this.permissionGranted(opType, user, env, families, Permission.Action.READ);
        HRegion region = this.getRegion(env);
        TableName table = this.getTableName(region);
        HashMap cfVsMaxVersions = Maps.newHashMap();
        for (HColumnDescriptor hcd : region.getTableDesc().getFamilies()) {
            cfVsMaxVersions.put(new SimpleByteRange(hcd.getName()), hcd.getMaxVersions());
        }
        if (!authResult.isAllowed()) {
            AccessControlFilter ourFilter;
            if (!this.cellFeaturesEnabled || this.compatibleEarlyTermination) {
                if (this.hasFamilyQualifierPermission(user, Permission.Action.READ, env, families)) {
                    ourFilter = new AccessControlFilter(this.authManager, user, table, AccessControlFilter.Strategy.CHECK_TABLE_AND_CF_ONLY, cfVsMaxVersions);
                    if (filter != null) {
                        ourFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)Lists.newArrayList((Object[])new Filter[]{ourFilter, filter}));
                    }
                    authResult.setAllowed(true);
                    authResult.setReason("Access allowed with filter");
                    switch (opType) {
                        case GET: 
                        case EXISTS: {
                            ((Get)query).setFilter((Filter)ourFilter);
                            break;
                        }
                        case SCAN: {
                            ((Scan)query).setFilter((Filter)ourFilter);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
                        }
                    }
                }
            } else {
                ourFilter = new AccessControlFilter(this.authManager, user, table, AccessControlFilter.Strategy.CHECK_CELL_DEFAULT, cfVsMaxVersions);
                if (filter != null) {
                    ourFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)Lists.newArrayList((Object[])new Filter[]{ourFilter, filter}));
                }
                authResult.setAllowed(true);
                authResult.setReason("Access allowed with filter");
                switch (opType) {
                    case GET: 
                    case EXISTS: {
                        ((Get)query).setFilter((Filter)ourFilter);
                        break;
                    }
                    case SCAN: {
                        ((Scan)query).setFilter((Filter)ourFilter);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
                    }
                }
            }
        }
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + table + ", action=READ)");
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        this.internalPreRead(c, (Query)get, OpType.GET);
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.internalPreRead(c, (Query)get, OpType.EXISTS);
        return exists;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, (Mutation)put);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap families = put.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.PUT, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                put.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = put.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put.getFamilyCellMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on delete has no effect: " + delete.toString());
        }
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap families = delete.getFamilyCellMap();
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.DELETE, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                delete.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            for (int i = 0; i < miniBatchOp.size(); ++i) {
                OpType opType;
                Mutation m = miniBatchOp.getOperation(i);
                if (m.getAttribute(CHECK_COVERING_PERM) == null) continue;
                if (m instanceof Put) {
                    this.checkForReservedTagPresence(this.getActiveUser(), m);
                    opType = OpType.PUT;
                } else {
                    opType = OpType.DELETE;
                }
                AuthResult authResult = null;
                authResult = this.checkCoveringPermission(opType, c.getEnvironment(), m.getRow(), m.getFamilyCellMap(), m.getTimeStamp(), Permission.Action.WRITE) ? AuthResult.allow(opType.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, m.getFamilyCellMap()) : AuthResult.deny(opType.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, m.getFamilyCellMap());
                this.logResult(authResult);
                if (authResult.isAllowed()) continue;
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyCellMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, (Mutation)put);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        AuthResult authResult = this.permissionGranted(OpType.CHECK_AND_PUT, user, env, families, Permission.Action.READ, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                put.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = put.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        if (put.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.CHECK_AND_PUT, c.getEnvironment(), row, families, Long.MAX_VALUE, Permission.Action.READ) ? AuthResult.allow(OpType.CHECK_AND_PUT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families) : AuthResult.deny(OpType.CHECK_AND_PUT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families);
            this.logResult(authResult);
            if (!authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on checkAndDelete has no effect: " + delete.toString());
        }
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.CHECK_AND_DELETE, user, env, families, Permission.Action.READ, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                delete.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.CHECK_AND_DELETE, c.getEnvironment(), row, families, Long.MAX_VALUE, Permission.Action.READ) ? AuthResult.allow(OpType.CHECK_AND_DELETE.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families) : AuthResult.deny(OpType.CHECK_AND_DELETE.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families);
            this.logResult(authResult);
            if (!authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.INCREMENT_COLUMN_VALUE, user, env, families, Permission.Action.WRITE);
        if (!authResult.isAllowed() && this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            authResult.setAllowed(this.checkCoveringPermission(OpType.INCREMENT_COLUMN_VALUE, env, row, families, Long.MAX_VALUE, Permission.Action.WRITE));
            authResult.setReason("Covering cell set");
        }
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
        }
        return -1L;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, (Mutation)append);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap families = append.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.APPEND, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                append.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = append.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, append.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        if (append.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.APPEND, c.getEnvironment(), append.getRow(), append.getFamilyCellMap(), Long.MAX_VALUE, Permission.Action.WRITE) ? AuthResult.allow(OpType.APPEND.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, append.getFamilyCellMap()) : AuthResult.deny(OpType.APPEND.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, append.getFamilyCellMap());
            this.logResult(authResult);
            if (!authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, (Mutation)increment);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap families = increment.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.INCREMENT, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                increment.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = increment.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, increment.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        if (increment.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.INCREMENT, c.getEnvironment(), increment.getRow(), increment.getFamilyCellMap(), increment.getTimeRange().getMax(), Permission.Action.WRITE) ? AuthResult.allow(OpType.INCREMENT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, increment.getFamilyCellMap()) : AuthResult.deny(OpType.INCREMENT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, increment.getFamilyCellMap());
            this.logResult(authResult);
            if (!authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return null;
    }

    @Override
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        byte[] aclBytes;
        if (!this.cellFeaturesEnabled) {
            return newCell;
        }
        ArrayList tags = Lists.newArrayList();
        ArrayListMultimap perms = ArrayListMultimap.create();
        if (oldCell != null) {
            Iterator tagIterator = CellUtil.tagsIterator((byte[])oldCell.getTagsArray(), (int)oldCell.getTagsOffset(), (int)oldCell.getTagsLengthUnsigned());
            while (tagIterator.hasNext()) {
                Tag tag = (Tag)tagIterator.next();
                if (tag.getType() != 1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Carrying forward tag from " + oldCell + ": type " + tag.getType() + " length " + tag.getTagLength()));
                    }
                    tags.add(tag);
                    continue;
                }
                ListMultimap kvPerms = ProtobufUtil.toUsersAndPermissions((AccessControlProtos.UsersAndPermissions)((AccessControlProtos.UsersAndPermissions.Builder)AccessControlProtos.UsersAndPermissions.newBuilder().mergeFrom(tag.getBuffer(), tag.getTagOffset(), tag.getTagLength())).build());
                perms.putAll((Multimap)kvPerms);
            }
        }
        if ((aclBytes = mutation.getACL()) != null) {
            tags.add(new Tag(1, aclBytes));
        } else if (perms != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Carrying forward ACLs from " + oldCell + ": " + perms));
            }
            tags.add(new Tag(1, ProtobufUtil.toUsersAndPermissions((ListMultimap)perms).toByteArray()));
        }
        if (tags.isEmpty()) {
            return newCell;
        }
        KeyValue newKv = KeyValueUtil.ensureKeyValue((Cell)newCell);
        byte[] bytes = newKv.getBuffer();
        KeyValue rewriteKv = new KeyValue(bytes, newKv.getRowOffset(), (int)newKv.getRowLength(), bytes, newKv.getFamilyOffset(), (int)newKv.getFamilyLength(), bytes, newKv.getQualifierOffset(), newKv.getQualifierLength(), newKv.getTimestamp(), KeyValue.Type.codeToType((byte)newKv.getTypeByte()), bytes, newKv.getValueOffset(), newKv.getValueLength(), (List)tags);
        rewriteKv.setMvccVersion(newKv.getMvccVersion());
        return rewriteKv;
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.internalPreRead(c, (Query)scan, OpType.SCAN);
        return s;
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUserName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUserName)) {
                throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        for (Pair<byte[], String> el : familyPaths) {
            this.requirePermission("preBulkLoadHFile", ctx.getEnvironment().getRegion().getTableDesc().getTableName(), (byte[])el.getFirst(), null, Permission.Action.CREATE);
        }
    }

    private AuthResult hasSomeAccess(RegionCoprocessorEnvironment e, String method, Permission.Action action) throws IOException {
        User requestUser = this.getActiveUser();
        TableName tableName = e.getRegion().getTableDesc().getTableName();
        AuthResult authResult = this.permissionGranted(method, requestUser, action, e, Collections.EMPTY_MAP);
        if (!authResult.isAllowed()) {
            for (UserPermission userPerm : AccessControlLists.getUserTablePermissions(this.regionEnv.getConfiguration(), tableName)) {
                for (Permission.Action userAction : userPerm.getActions()) {
                    if (!userAction.equals((Object)action)) continue;
                    return AuthResult.allow(method, "Access allowed", requestUser, action, tableName, null, null);
                }
            }
        }
        return authResult;
    }

    @Override
    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.PrepareBulkLoadRequest request) throws IOException {
        RegionCoprocessorEnvironment e = ctx.getEnvironment();
        AuthResult authResult = this.hasSomeAccess(e, "prePrepareBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=WRITE)");
        }
    }

    @Override
    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.CleanupBulkLoadRequest request) throws IOException {
        RegionCoprocessorEnvironment e = ctx.getEnvironment();
        AuthResult authResult = this.hasSomeAccess(e, "preCleanupBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=WRITE)");
        }
    }

    @Override
    public Message preEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request) throws IOException {
        if (this.shouldCheckExecPermission && !(service instanceof AccessControlProtos.AccessControlService)) {
            this.requirePermission("invoke(" + service.getDescriptorForType().getName() + "." + methodName + ")", this.getTableName(ctx.getEnvironment()), null, null, Permission.Action.EXEC);
        }
        return request;
    }

    @Override
    public void postEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request, Message.Builder responseBuilder) throws IOException {
    }

    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        UserPermission perm = ProtobufUtil.toUserPermission((AccessControlProtos.UserPermission)request.getUserPermission());
        AccessControlProtos.GrantResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received request to grant access permission " + perm.toString()));
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("grant", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireGlobalPermission("grant", Permission.Action.ADMIN, perm.getNamespace());
                    }
                }
                AccessControlLists.addUserPermission(this.regionEnv.getConfiguration(), perm);
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace((Object)("Granted permission " + perm.toString()));
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.GrantResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        UserPermission perm = ProtobufUtil.toUserPermission((AccessControlProtos.UserPermission)request.getUserPermission());
        AccessControlProtos.RevokeResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received request to revoke access permission " + perm.toString()));
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("revoke", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireGlobalPermission("revoke", Permission.Action.ADMIN, perm.getNamespace());
                    }
                }
                AccessControlLists.removeUserPermission(this.regionEnv.getConfiguration(), perm);
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace((Object)("Revoked permission " + perm.toString()));
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.RevokeResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            List<UserPermission> perms;
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                perms = null;
                if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                    TableName table = null;
                    if (request.hasTableName()) {
                        table = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
                    }
                    this.requirePermission("userPermissions", table, null, null, Permission.Action.ADMIN);
                    perms = AccessControlLists.getUserTablePermissions(this.regionEnv.getConfiguration(), table);
                } else {
                    perms = request.getType() == AccessControlProtos.Permission.Type.Namespace ? AccessControlLists.getUserNamespacePermissions(this.regionEnv.getConfiguration(), request.getNamespaceName().toStringUtf8()) : AccessControlLists.getUserPermissions(this.regionEnv.getConfiguration(), null);
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = ResponseConverter.buildGetUserPermissionsResponse(perms);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        Permission[] permissions = new Permission[request.getPermissionCount()];
        for (int i = 0; i < request.getPermissionCount(); ++i) {
            permissions[i] = ProtobufUtil.toPermission((AccessControlProtos.Permission)request.getPermission(i));
        }
        AccessControlProtos.CheckPermissionsResponse response = null;
        try {
            TableName tableName = this.regionEnv.getRegion().getTableDesc().getTableName();
            for (Permission permission : permissions) {
                if (permission instanceof TablePermission) {
                    TablePermission tperm = (TablePermission)permission;
                    for (Permission.Action action : permission.getActions()) {
                        if (!tperm.getTableName().equals((Object)tableName)) {
                            throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", tableName, tperm.getTableName()));
                        }
                        TreeMap<byte[], TreeSet> familyMap = new TreeMap<byte[], TreeSet>(Bytes.BYTES_COMPARATOR);
                        if (tperm.getFamily() != null) {
                            if (tperm.getQualifier() != null) {
                                TreeSet qualifiers = Sets.newTreeSet((Comparator)Bytes.BYTES_COMPARATOR);
                                qualifiers.add(tperm.getQualifier());
                                familyMap.put(tperm.getFamily(), qualifiers);
                            } else {
                                familyMap.put(tperm.getFamily(), null);
                            }
                        }
                        this.requirePermission("checkPermissions", action, this.regionEnv, familyMap);
                    }
                    continue;
                }
                for (Permission.Action action : permission.getActions()) {
                    this.requirePermission("checkPermissions", action);
                }
            }
            response = AccessControlProtos.CheckPermissionsResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    @Override
    public Service getService() {
        return AccessControlProtos.AccessControlService.newReflectiveService((AccessControlProtos.AccessControlService.Interface)this);
    }

    private HRegion getRegion(RegionCoprocessorEnvironment e) {
        return e.getRegion();
    }

    private TableName getTableName(RegionCoprocessorEnvironment e) {
        HRegion region = e.getRegion();
        if (region != null) {
            return this.getTableName(region);
        }
        return null;
    }

    private TableName getTableName(HRegion region) {
        HRegionInfo regionInfo = region.getRegionInfo();
        if (regionInfo != null) {
            return regionInfo.getTable();
        }
        return null;
    }

    @Override
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission("preClose", Permission.Action.ADMIN);
    }

    private void isSystemOrSuperUser(Configuration conf) throws IOException {
        User user = this.userProvider.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        User activeUser = this.getActiveUser();
        if (!this.superusers.contains(activeUser.getShortName())) {
            throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + "is not system or super user.");
        }
    }

    @Override
    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission("preStopRegionServer", Permission.Action.ADMIN);
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        TreeMap<byte[], ImmutableSet> familyMap = new TreeMap<byte[], ImmutableSet>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, qualifier != null ? ImmutableSet.of((Object)qualifier) : null);
        return familyMap;
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        if (tableNamesList == null || tableNamesList.isEmpty()) {
            this.requireGlobalPermission("getTableDescriptors", Permission.Action.ADMIN, null, null);
        } else {
            MasterServices masterServices = ctx.getEnvironment().getMasterServices();
            for (TableName tableName : tableNamesList) {
                try {
                    masterServices.checkTableModifiable(tableName);
                }
                catch (TableNotFoundException ex) {
                    continue;
                }
                catch (TableNotDisabledException ex) {
                    // empty catch block
                }
                this.requirePermission("getTableDescriptors", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
        }
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
    }

    @Override
    public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
        this.requirePermission("mergeRegions", regionA.getTableDesc().getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
    }

    @Override
    public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB, List<Mutation> metaEntries) throws IOException {
    }

    @Override
    public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
    }

    @Override
    public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
    }

    @Override
    public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
    }

    private static enum OpType {
        GET_CLOSEST_ROW_BEFORE("getClosestRowBefore"),
        GET("get"),
        EXISTS("exists"),
        SCAN("scan"),
        PUT("put"),
        DELETE("delete"),
        CHECK_AND_PUT("checkAndPut"),
        CHECK_AND_DELETE("checkAndDelete"),
        INCREMENT_COLUMN_VALUE("incrementColumnValue"),
        APPEND("append"),
        INCREMENT("increment");

        private String type;

        private OpType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

