/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.cloudera.htrace.HTraceConfiguration;
import org.cloudera.htrace.SpanReceiver;
import org.cloudera.htrace.Trace;

public class SpanReceiverHost {
    public static final String SPAN_RECEIVERS_CONF_KEY = "hbase.trace.spanreceiver.classes";
    private static final Log LOG = LogFactory.getLog(SpanReceiverHost.class);
    private Collection<SpanReceiver> receivers = new HashSet<SpanReceiver>();
    private Configuration conf;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpanReceiverHost getInstance(Configuration conf) {
        Object object = SingleTonholder.INSTANCE.lock;
        synchronized (object) {
            if (SingleTonholder.INSTANCE.host != null) {
                return SingleTonholder.INSTANCE.host;
            }
            SpanReceiverHost host = new SpanReceiverHost(conf);
            host.loadSpanReceivers();
            SingleTonholder.INSTANCE.host = host;
            return SingleTonholder.INSTANCE.host;
        }
    }

    SpanReceiverHost(Configuration conf) {
        this.conf = conf;
    }

    public void loadSpanReceivers() {
        Class<?> implClass = null;
        String[] receiverNames = this.conf.getStrings(SPAN_RECEIVERS_CONF_KEY);
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        for (String className : receiverNames) {
            className = className.trim();
            try {
                implClass = Class.forName(className);
                SpanReceiver receiver = this.loadInstance(implClass);
                if (receiver == null) continue;
                this.receivers.add(receiver);
                LOG.info((Object)("SpanReceiver " + className + " was loaded successfully."));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Class " + className + " cannot be found. " + e.getMessage()));
            }
            catch (IOException e) {
                LOG.warn((Object)("Load SpanReceiver " + className + " failed. " + e.getMessage()));
            }
        }
        for (SpanReceiver rcvr : this.receivers) {
            Trace.addReceiver((SpanReceiver)rcvr);
        }
    }

    private SpanReceiver loadInstance(Class<?> implClass) throws IOException {
        SpanReceiver impl = null;
        try {
            Object o = implClass.newInstance();
            impl = (SpanReceiver)o;
            impl.configure((HTraceConfiguration)new HBaseHTraceConfiguration(this.conf));
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return impl;
    }

    public synchronized void closeReceivers() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SpanReceiver rcvr : this.receivers) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to close SpanReceiver correctly: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static enum SingleTonholder {
        INSTANCE;

        Object lock = new Object();
        SpanReceiverHost host = null;
    }
}

