/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.shim.spi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.hbase.shim.api.ColumnFilter;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;

public abstract class HBaseConnection {
    public static final String HBASE_VERSION_KEY = "hbase.defaults.for.version";
    public static final String DEFAULTS_KEY = "hbase.default";
    public static final String SITE_KEY = "hbase.site";
    public static final String ZOOKEEPER_QUORUM_KEY = "hbase.zookeeper.quorum";
    public static final String ZOOKEEPER_PORT_KEY = "hbase.zookeeper.property.clientPort";
    public static final String COL_DESCRIPTOR_MAX_VERSIONS_KEY = "col.descriptor.maxVersions";
    public static final String COL_DESCRIPTOR_COMPRESSION_KEY = "col.descriptor.compression";
    public static final String COL_DESCRIPTOR_IN_MEMORY_KEY = "col.descriptor.inMemory";
    public static final String COL_DESCRIPTOR_BLOCK_CACHE_ENABLED_KEY = "col.descriptor.blockCacheEnabled";
    public static final String COL_DESCRIPTOR_BLOCK_SIZE_KEY = "col.descriptor.blockSize";
    public static final String COL_DESCRIPTOR_TIME_TO_LIVE_KEY = "col.desciptor.timeToLive";
    public static final String COL_DESCRIPTOR_BLOOM_FILTER_KEY = "col.descriptor.bloomFilter";
    public static final String COL_DESCRIPTOR_SCOPE_KEY = "col.descriptor.scope";
    public static final String HTABLE_WRITE_BUFFER_SIZE_KEY = "htable.writeBufferSize";

    public abstract HBaseBytesUtilShim getBytesUtil() throws Exception;

    public abstract void configureConnection(Properties var1, List<String> var2) throws Exception;

    public abstract void checkHBaseAvailable() throws Exception;

    public abstract List<String> listTableNames() throws Exception;

    public abstract boolean tableExists(String var1) throws Exception;

    public abstract boolean isTableDisabled(String var1) throws Exception;

    public abstract boolean isTableAvailable(String var1) throws Exception;

    public abstract void disableTable(String var1) throws Exception;

    public abstract void enableTable(String var1) throws Exception;

    public abstract void deleteTable(String var1) throws Exception;

    public abstract void executeTargetTableDelete(byte[] var1) throws Exception;

    public abstract void createTable(String var1, List<String> var2, Properties var3) throws Exception;

    public abstract List<String> getTableFamiles(String var1) throws Exception;

    public abstract void newSourceTable(String var1) throws Exception;

    public abstract boolean sourceTableRowExists(byte[] var1) throws Exception;

    public abstract void newSourceTableScan(byte[] var1, byte[] var2, int var3) throws Exception;

    public abstract void newTargetTablePut(byte[] var1, boolean var2) throws Exception;

    public abstract boolean targetTableIsAutoFlush() throws Exception;

    public abstract void executeTargetTablePut() throws Exception;

    public abstract void flushCommitsTargetTable() throws Exception;

    public abstract void addColumnToTargetPut(String var1, String var2, boolean var3, byte[] var4) throws Exception;

    public abstract void addColumnFilterToScan(ColumnFilter var1, HBaseValueMeta var2, VariableSpace var3, boolean var4) throws Exception;

    public abstract void addColumnToScan(String var1, String var2, boolean var3) throws Exception;

    public abstract void executeSourceTableScan() throws Exception;

    public abstract boolean resultSetNextRow() throws Exception;

    public abstract byte[] getRowKey(Object var1) throws Exception;

    public abstract byte[] getResultSetCurrentRowKey() throws Exception;

    public abstract byte[] getRowColumnLatest(Object var1, String var2, String var3, boolean var4) throws Exception;

    public abstract boolean checkForHBaseRow(Object var1);

    public abstract byte[] getResultSetCurrentRowColumnLatest(String var1, String var2, boolean var3) throws Exception;

    public abstract NavigableMap<byte[], byte[]> getRowFamilyMap(Object var1, String var2) throws Exception;

    public abstract NavigableMap<byte[], byte[]> getResultSetCurrentRowFamilyMap(String var1) throws Exception;

    public abstract NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getRowMap(Object var1) throws Exception;

    public abstract NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getResultSetCurrentRowMap() throws Exception;

    public abstract void closeSourceTable() throws Exception;

    public abstract void closeSourceResultSet() throws Exception;

    public abstract void newTargetTable(String var1, Properties var2) throws Exception;

    public abstract void closeTargetTable() throws Exception;

    public abstract boolean isImmutableBytesWritable(Object var1);

    public static URL stringToURL(String pathOrURL) throws MalformedURLException {
        URL result = null;
        if (!HBaseConnection.isEmpty(pathOrURL)) {
            if (pathOrURL.toLowerCase().startsWith("http://") || pathOrURL.toLowerCase().startsWith("file://")) {
                result = new URL(pathOrURL);
            } else {
                String c = "file://" + pathOrURL;
                result = new URL(c);
            }
        }
        return result;
    }

    public static boolean isEmpty(String toCheck) {
        return toCheck == null || toCheck.length() == 0;
    }
}

