/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.InvokerGenerator;
import org.apache.pig.builtin.Nondeterministic;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFrontend;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.Util;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.LogicalPlanBuilder;
import org.apache.pig.parser.SourceLocation;
import org.python.google.common.base.Joiner;

public class UserFuncExpression
extends LogicalExpression {
    private FuncSpec mFuncSpec;
    private transient EvalFunc<?> ef = null;
    private String signature;
    private static int sigSeq = 0;
    private boolean viaDefine = false;
    private boolean lazilyInitializeInvokerFunction = false;
    private List<LogicalExpression> saveArgsForLater = null;
    private boolean invokerIsStatic = false;
    private String funcName = null;
    private String packageName = null;

    public UserFuncExpression(OperatorPlan plan, FuncSpec funcSpec) {
        super("UserFunc", plan);
        this.mFuncSpec = funcSpec;
        plan.add(this);
        if (this.signature == null) {
            this.signature = Integer.toString(sigSeq++);
        }
    }

    public UserFuncExpression(OperatorPlan plan, FuncSpec funcSpec, List<LogicalExpression> args) {
        this(plan, funcSpec);
        for (LogicalExpression arg : args) {
            plan.connect(this, arg);
        }
    }

    public UserFuncExpression(OperatorPlan plan, FuncSpec funcSpec, boolean viaDefine) {
        this(plan, funcSpec);
        this.viaDefine = viaDefine;
    }

    public UserFuncExpression(OperatorPlan plan, FuncSpec funcSpec, List<LogicalExpression> args, boolean viaDefine) {
        this(plan, funcSpec, args);
        this.viaDefine = viaDefine;
    }

    public UserFuncExpression(OperatorPlan plan, FuncSpec funcSpec, List<LogicalExpression> args, boolean viaDefine, boolean lazilyInitializeInvokerFunction, boolean invokerIsStatic, String packageName, String funcName) {
        this(plan, funcSpec, args, viaDefine);
        this.saveArgsForLater = args;
        this.lazilyInitializeInvokerFunction = lazilyInitializeInvokerFunction;
        this.packageName = packageName;
        this.funcName = funcName;
        this.invokerIsStatic = invokerIsStatic;
    }

    public FuncSpec getFuncSpec() {
        return this.mFuncSpec;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (!this.isDeterministic()) {
            return false;
        }
        if (other instanceof UserFuncExpression) {
            UserFuncExpression exp = (UserFuncExpression)other;
            if (!this.mFuncSpec.equals(exp.mFuncSpec)) {
                return false;
            }
            List<Operator> mySuccs = this.getPlan().getSuccessors(this);
            List<Operator> theirSuccs = other.getPlan().getSuccessors(other);
            if (mySuccs == null || theirSuccs == null) {
                return mySuccs == null && theirSuccs == null;
            }
            if (mySuccs.size() != theirSuccs.size()) {
                return false;
            }
            for (int i = 0; i < mySuccs.size(); ++i) {
                if (mySuccs.get(i).isEqual(theirSuccs.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isDeterministic() throws FrontendException {
        Class udfClass;
        try {
            udfClass = PigContext.resolveClassName(this.getFuncSpec().getClassName());
        }
        catch (IOException ioe) {
            throw new FrontendException("Cannot instantiate: " + this.getFuncSpec(), ioe);
        }
        return udfClass.getAnnotation(Nondeterministic.class) == null;
    }

    public List<LogicalExpression> getArguments() throws FrontendException {
        List<Operator> successors = null;
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        successors = this.plan.getSuccessors(this);
        if (successors == null) {
            return args;
        }
        for (Operator lo : successors) {
            args.add((LogicalExpression)lo);
        }
        return args;
    }

    public void setFuncSpec(FuncSpec funcSpec) {
        this.mFuncSpec = funcSpec;
        this.ef = (EvalFunc)PigContext.instantiateFuncFromSpec(this.mFuncSpec);
    }

    @Override
    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        LogicalSchema inputSchema = new LogicalSchema();
        List<Operator> succs = this.plan.getSuccessors(this);
        if (succs != null) {
            for (Operator lo : succs) {
                if (((LogicalExpression)lo).getFieldSchema() == null) {
                    inputSchema = null;
                    break;
                }
                inputSchema.addField(((LogicalExpression)lo).getFieldSchema());
            }
        }
        if (this.lazilyInitializeInvokerFunction) {
            this.initializeInvokerFunction();
        }
        if (this.ef == null) {
            this.ef = (EvalFunc)PigContext.instantiateFuncFromSpec(this.mFuncSpec);
        }
        this.ef.setUDFContextSignature(this.signature);
        Properties props = UDFContext.getUDFContext().getUDFProperties(this.ef.getClass());
        Schema translatedInputSchema = Util.translateSchema(inputSchema);
        if (translatedInputSchema != null) {
            props.put("pig.evalfunc.inputschema." + this.signature, translatedInputSchema);
        }
        this.ef.setInputSchema(translatedInputSchema);
        Schema udfSchema = this.ef.outputSchema(translatedInputSchema);
        if (udfSchema != null && udfSchema.size() > 1) {
            throw new FrontendException("Given UDF returns an improper Schema. Schema should only contain one field of a Tuple, Bag, or a single type. Returns: " + udfSchema);
        }
        SchemaTupleFrontend.registerToGenerateIfPossible(translatedInputSchema, false, SchemaTupleClassGenerator.GenContext.UDF);
        SchemaTupleFrontend.registerToGenerateIfPossible(udfSchema, false, SchemaTupleClassGenerator.GenContext.UDF);
        if (udfSchema != null) {
            Schema.FieldSchema fs = udfSchema.size() == 0 ? new Schema.FieldSchema(null, null, DataType.findType(this.ef.getReturnType())) : (udfSchema.size() == 1 ? new Schema.FieldSchema(udfSchema.getField(0)) : new Schema.FieldSchema(null, udfSchema, 110));
            this.fieldSchema = Util.translateFieldSchema(fs);
            this.fieldSchema.normalize();
        } else {
            this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, null, DataType.findType(this.ef.getReturnType()));
        }
        this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
        return this.fieldSchema;
    }

    private void initializeInvokerFunction() {
        int i;
        Class<?> funcClass;
        ArrayList fieldSchemas = Lists.newArrayList();
        for (LogicalExpression le : this.saveArgsForLater) {
            try {
                fieldSchemas.add(le.getFieldSchema());
            }
            catch (FrontendException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.invokerIsStatic) {
            try {
                funcClass = PigContext.resolveClassName(this.packageName);
            }
            catch (IOException e) {
                throw new RuntimeException("Invoker function name not found: " + this.packageName, e);
            }
        } else {
            funcClass = DataType.findTypeClass(((LogicalSchema.LogicalFieldSchema)fieldSchemas.get((int)0)).type);
            if (funcClass.isPrimitive()) {
                funcClass = LogicalPlanBuilder.typeToClass(funcClass);
            }
        }
        Class[] parameterTypes = new Class[fieldSchemas.size() - (this.invokerIsStatic ? 0 : 1)];
        int idx = 0;
        int n = i = this.invokerIsStatic ? 0 : 1;
        while (i < fieldSchemas.size()) {
            parameterTypes[idx++] = DataType.findTypeClass(((LogicalSchema.LogicalFieldSchema)fieldSchemas.get((int)i)).type);
            ++i;
        }
        ArrayList primitiveParameters = Lists.newArrayList();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (!parameterTypes[i2].isPrimitive()) continue;
            primitiveParameters.add(i2);
        }
        int tries = 1 << primitiveParameters.size();
        Method m = null;
        for (int i3 = 0; i3 < tries; ++i3) {
            Class[] tmpParameterTypes = new Class[parameterTypes.length];
            for (int j = 0; j < parameterTypes.length; ++j) {
                tmpParameterTypes[j] = parameterTypes[j];
            }
            int tmp = i3;
            int idx2 = 0;
            while (tmp > 0) {
                if (tmp % 2 == 1) {
                    int toFlip = (Integer)primitiveParameters.get(idx2);
                    tmpParameterTypes[toFlip] = LogicalPlanBuilder.typeToClass(tmpParameterTypes[toFlip]);
                }
                tmp >>= 1;
                ++idx2;
            }
            try {
                m = funcClass.getMethod(this.funcName, parameterTypes);
                if (m == null) continue;
                parameterTypes = tmpParameterTypes;
                break;
            }
            catch (SecurityException e) {
                throw new RuntimeException("Not allowed to access method [" + this.funcName + "] on class: " + funcClass, e);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (m == null) {
            throw new RuntimeException("Given method [" + this.funcName + "] does not exist on class: " + funcClass);
        }
        String[] ctorArgs = new String[]{funcClass.getName(), this.funcName, ""};
        ArrayList params = Lists.newArrayList();
        for (Class param : parameterTypes) {
            params.add(param.getName());
        }
        ctorArgs[2] = Joiner.on((String)",").join((Iterable)params);
        this.mFuncSpec = new FuncSpec(InvokerGenerator.class.getName(), ctorArgs);
        this.lazilyInitializeInvokerFunction = false;
    }

    @Override
    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        UserFuncExpression copy = null;
        try {
            copy = new UserFuncExpression((OperatorPlan)lgExpPlan, this.getFuncSpec().clone(), this.viaDefine);
            copy.signature = this.signature;
            List<Operator> inputs = this.plan.getSuccessors(this);
            if (inputs != null) {
                for (Operator op : inputs) {
                    LogicalExpression input = (LogicalExpression)op;
                    LogicalExpression inputCopy = input.deepCopy(lgExpPlan);
                    lgExpPlan.add(inputCopy);
                    lgExpPlan.connect(copy, inputCopy);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        copy.setLocation(new SourceLocation(this.location));
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: " + this.name + "(" + this.getFuncSpec() + ")" + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(")");
        return msg.toString();
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isViaDefine() {
        return this.viaDefine;
    }
}

