/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.shock;

import com.jcraft.jsch.SocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.shock.ChannelInputStream;
import org.apache.pig.shock.ChannelOutputStream;

class SSHSocketFactory
implements SocketFactory {
    private static final Log log = LogFactory.getLog(SSHSocketFactory.class);

    SSHSocketFactory() {
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket s;
        String socksHost = System.getProperty("socksProxyHost");
        InetSocketAddress addr = new InetSocketAddress(host, port);
        if (socksHost != null) {
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(socksHost, 1080));
            s = new Socket(proxy);
            s.connect(addr);
        } else {
            log.error((Object)addr);
            SocketChannel sc = SocketChannel.open(addr);
            s = sc.socket();
        }
        s.setTcpNoDelay(true);
        return s;
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        return new ChannelInputStream(socket.getChannel());
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        return new ChannelOutputStream(socket.getChannel());
    }
}

