/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundleloader;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleData;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadRepository;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class ZipResourceBundleLoader
implements ResourceBundleLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundleData loadBundle(ResourceManager resourceManager, ResourceKey key) throws ResourceLoadingException {
        RepositoryResourceBundleData repositoryResourceBundleData;
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        ResourceData rawData = resourceManager.loadRawData(key);
        byte[] buffer = new byte[2];
        rawData.getResource(resourceManager, buffer, 0L, 2);
        if (buffer[0] != 80 || buffer[1] != 75) {
            return null;
        }
        InputStream stream = rawData.getResourceAsStream(resourceManager);
        try {
            ZipReadRepository zipReadRepository = new ZipReadRepository(stream);
            String bundleType = BundleUtilities.getBundleType((Repository)zipReadRepository);
            String bundleMapping = BundleUtilities.getBundleMapping(bundleType);
            HashMap<FactoryParameterKey, Object> map = new HashMap<FactoryParameterKey, Object>();
            map.put(new FactoryParameterKey("repository"), zipReadRepository);
            map.put(new FactoryParameterKey("repository-loader"), this);
            ResourceKey mainKey = new ResourceKey(key, (Object)ZipResourceBundleLoader.class.getName(), (Object)bundleMapping, map);
            repositoryResourceBundleData = new RepositoryResourceBundleData(key, (Repository)zipReadRepository, mainKey, false);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (UnrecognizedLoaderException e) {
                return null;
            }
            catch (IOException ioe) {
                throw new ResourceLoadingException("IOError during load", (Exception)ioe);
            }
        }
        stream.close();
        return repositoryResourceBundleData;
    }

    public boolean isSupportedKey(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.getParent() == null) {
            return false;
        }
        return ZipResourceBundleLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map<? extends ParameterKey, ? extends Object> factoryKeys) throws ResourceKeyCreationException {
        HashMap<? extends ParameterKey, ? extends Object> map;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String identifier = (String)parent.getIdentifier();
        String entry = path != null ? (path.length() > 0 && path.charAt(0) == '/' ? LoaderUtils.stripLeadingSlashes((String)path) : LoaderUtils.mergePaths((String)identifier, (String)path)) : identifier;
        if (factoryKeys != null) {
            map = new HashMap<ParameterKey, Object>();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        if ("true".equals(LibDocBundleBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.docbundle.bundleloader.zip.StrictKeyCheck", "true"))) {
            try {
                ZipReadRepository repository = (ZipReadRepository)parent.getFactoryParameters().get(new FactoryParameterKey("repository"));
                if (!RepositoryUtilities.isExistsEntity((Repository)repository, (String[])RepositoryUtilities.split((String)entry, (String)"/"))) {
                    throw new ResourceKeyCreationException("The key does not exist: " + entry);
                }
            }
            catch (ContentIOException e) {
                throw new ResourceKeyCreationException("Failed to check for existing key", (Exception)((Object)e));
            }
        }
        return new ResourceKey(parent.getParent(), parent.getSchema(), (Object)entry, map);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        return null;
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        return null;
    }

    public boolean isSupportedDeserializer(String data) throws ResourceKeyCreationException {
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }
}

