/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class AuthContext {
    private LoginContext login;

    public AuthContext(LoginContext login) {
        this.login = login;
    }

    public <T> T doAs(PrivilegedAction<T> action) {
        if (this.login == null) {
            return action.run();
        }
        return Subject.doAs(this.login.getSubject(), action);
    }

    public <T> T doAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (this.login == null) {
            try {
                return action.run();
            }
            catch (Exception ex) {
                throw new PrivilegedActionException(ex);
            }
        }
        return Subject.doAs(this.login.getSubject(), action);
    }
}

