/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.KettleKerberosHelper;
import org.pentaho.mongo.wrapper.KerberosInvocationHandler;
import org.pentaho.mongo.wrapper.UsernamePasswordMongoClientWrapper;
import org.pentaho.mongo.wrapper.collection.KerberosMongoCollectionWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;

public class KerberosMongoClientWrapper
extends UsernamePasswordMongoClientWrapper {
    private final AuthContext authContext;

    public KerberosMongoClientWrapper(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log) throws KettleException {
        super(meta, vars, log);
        this.authContext = new AuthContext(KettleKerberosHelper.login(vars, this.getUser()));
    }

    public KerberosMongoClientWrapper(MongoClient client, LogChannelInterface log, String username, AuthContext authContext) {
        super(client, log, username, null);
        this.authContext = authContext;
    }

    @Override
    protected MongoCredential getCredential(MongoDbMeta meta, VariableSpace vars) {
        return MongoCredential.createGSSAPICredential((String)vars.environmentSubstitute(meta.getAuthenticationUser()));
    }

    @Override
    protected void authenticateWithDb(DB db) throws KettleException {
    }

    @Override
    protected MongoCollectionWrapper wrap(DBCollection collection) {
        return KerberosInvocationHandler.wrap(MongoCollectionWrapper.class, this.authContext, new KerberosMongoCollectionWrapper(collection, this.authContext));
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }
}

