/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.mongo.wrapper.NoAuthMongoClientWrapper;

public class UsernamePasswordMongoClientWrapper
extends NoAuthMongoClientWrapper {
    static Class<?> PKG = UsernamePasswordMongoClientWrapper.class;
    private final String user;
    private final String password;

    public UsernamePasswordMongoClientWrapper(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log) throws KettleException {
        super(meta, vars, log);
        this.user = vars.environmentSubstitute(meta.getAuthenticationUser());
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)vars.environmentSubstitute(meta.getAuthenticationPassword()));
    }

    public UsernamePasswordMongoClientWrapper(MongoClient mongo, LogChannelInterface log, String user, String password) {
        super(mongo, log);
        this.user = user;
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    protected MongoClient getClient(MongoDbMeta meta, VariableSpace vars, LogChannelInterface log, List<ServerAddress> repSet, boolean useAllReplicaSetMembers, MongoClientOptions opts) throws KettleException {
        try {
            ArrayList<MongoCredential> credList = new ArrayList<MongoCredential>();
            credList.add(this.getCredential(meta, vars));
            return repSet.size() > 1 || useAllReplicaSetMembers && repSet.size() >= 1 ? new MongoClient(repSet, credList, opts) : (repSet.size() == 1 ? new MongoClient(repSet.get(0), credList, opts) : new MongoClient(new ServerAddress("localhost"), credList, opts));
        }
        catch (UnknownHostException u) {
            throw new KettleException((Throwable)u);
        }
    }

    protected MongoCredential getCredential(MongoDbMeta meta, VariableSpace vars) {
        String dbName = vars.environmentSubstitute(meta.getDbName());
        dbName = dbName.trim().length() == 0 ? "admin" : dbName;
        return MongoCredential.createCredential((String)vars.environmentSubstitute(meta.getAuthenticationUser()), (String)dbName, (char[])Encr.decryptPasswordOptionallyEncrypted((String)vars.environmentSubstitute(meta.getAuthenticationPassword())).toCharArray());
    }

    @Override
    protected DB getDb(String dbName) throws KettleException {
        try {
            DB result = this.getMongo().getDB(dbName);
            if (!result.isAuthenticated()) {
                this.authenticateWithDb(result);
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException((Throwable)e);
        }
    }

    protected void authenticateWithDb(DB db) throws KettleException {
        CommandResult comResult = db.authenticateCommand(this.user, this.password.toCharArray());
        if (!comResult.ok()) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoUsernamePasswordWrapper.ErrorAuthenticating.Exception", (String[])new String[]{comResult.getErrorMessage()}));
        }
    }
}

