/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.googleanalytics;

import com.google.api.services.analytics.Analytics;
import com.google.api.services.analytics.model.Account;
import com.google.api.services.analytics.model.Accounts;
import com.google.api.services.analytics.model.GaData;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepData;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepMeta;
import org.pentaho.di.trans.steps.googleanalytics.GoogleAnalyticsApiFacade;

public class GaInputStep
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GaInputStepMeta.class;
    private GaInputStepData data;
    private GaInputStepMeta meta;
    private Analytics analytics;
    private String accountName;

    public GaInputStep(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.conversionMeta = new ValueMetaInterface[this.meta.getFeedField().length];
            for (int i = 0; i < this.meta.getFeedField().length; ++i) {
                ValueMetaInterface returnMeta = this.data.outputRowMeta.getValueMeta(i);
                ValueMetaInterface conversionMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)returnMeta, (int)2);
                conversionMeta.setConversionMask(this.meta.getConversionMask()[i]);
                conversionMeta.setDecimalSymbol(".");
                conversionMeta.setGroupingSymbol(null);
                this.data.conversionMeta[i] = conversionMeta;
            }
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        List<String> entry = this.getNextDataEntry();
        if (entry != null && (this.meta.getRowLimit() <= 0 || this.getLinesWritten() < (long)this.meta.getRowLimit())) {
            int j = 0;
            for (int i = 0; i < this.meta.getFeedField().length; ++i) {
                Object dataObject;
                String fieldName = this.environmentSubstitute(this.meta.getFeedField()[i]);
                String type = this.environmentSubstitute(this.meta.getFeedFieldType()[i]);
                if ("Data Source Property".equals(type)) {
                    dataObject = "ga:accountName".equals(fieldName) ? this.accountName : this.data.feed.getProfileInfo().get((Object)this.removeClassifier(fieldName));
                } else if ("Data Source Field".equals(type)) {
                    dataObject = "dxp:tableId".equals(fieldName) ? this.data.feed.getProfileInfo().get((Object)this.removeClassifier(fieldName)) : this.data.feed.getProfileInfo().getProfileName();
                } else if ("Confidence Interval for Metric".equals(type)) {
                    dataObject = null;
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Warn.FieldTypeNotSupported", (String[])new String[]{"Confidence Interval for Metric"}));
                    }
                } else {
                    dataObject = entry.get(j++);
                }
                outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], dataObject);
            }
            this.putRow(this.data.outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                this.logBasic("Linenr " + this.getLinesWritten());
            }
            return true;
        }
        this.setOutputDone();
        return false;
    }

    protected Analytics.Data.Ga.Get getQuery(Analytics analytics) {
        Analytics.Data dataApi = analytics.data();
        try {
            String metrics = this.environmentSubstitute(this.meta.getMetrics());
            if (Const.isEmpty((String)metrics)) {
                this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.NoMetricsSpecified.Message", (String[])new String[0]));
                return null;
            }
            Analytics.Data.Ga.Get query = dataApi.ga().get(this.meta.isUseCustomTableId() ? this.environmentSubstitute(this.meta.getGaCustomTableId()) : this.meta.getGaProfileTableId(), this.environmentSubstitute(this.meta.getStartDate()), this.environmentSubstitute(this.meta.getEndDate()), metrics);
            String dimensions = this.environmentSubstitute(this.meta.getDimensions());
            if (!Const.isEmpty((String)dimensions)) {
                query.setDimensions(dimensions);
            }
            if (this.meta.isUseSegment()) {
                if (this.meta.isUseCustomSegment()) {
                    query.setSegment(this.environmentSubstitute(this.meta.getCustomSegment()));
                } else {
                    query.setSegment(this.meta.getSegmentId());
                }
            }
            if (!Const.isEmpty((String)this.meta.getFilters())) {
                query.setFilters(this.environmentSubstitute(this.meta.getFilters()));
            }
            if (!Const.isEmpty((String)this.meta.getSort())) {
                query.setSort(this.environmentSubstitute(this.meta.getSort()));
            }
            return query;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        String[] types = this.environmentSubstitute(this.meta.getFeedFieldType());
        if (types != null) {
            for (String type : types) {
                if (!"Confidence Interval for Metric".equals(type)) continue;
                this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Warn.FieldTypeNotSupported", (String[])new String[]{"Confidence Interval for Metric"}));
            }
        }
        try {
            this.analytics = GoogleAnalyticsApiFacade.createFor(this.environmentSubstitute(this.meta.getGaAppName()), this.environmentSubstitute(this.meta.getOAuthServiceAccount()), this.environmentSubstitute(this.meta.getOAuthKeyFile())).getAnalytics();
            this.accountName = ((Account)((Accounts)this.analytics.management().accounts().list().execute()).getItems().iterator().next()).getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private List<String> getNextDataEntry() throws KettleException {
        if (this.data.query == null) {
            this.data.query = this.getQuery(this.analytics);
            if (this.log.isDetailed()) {
                this.logDetailed("querying google analytics: " + this.data.query.buildHttpRequestUrl().toURI().toString());
            }
            try {
                this.data.feed = (GaData)this.data.query.execute();
                this.data.entryIndex = 0;
            }
            catch (IOException e2) {
                throw new KettleException((Throwable)e2);
            }
        }
        if (this.data.entryIndex >= this.data.feed.getItemsPerPage()) {
            try {
                if (this.data.query.getStartIndex() + this.data.entryIndex <= this.data.feed.getTotalResults()) {
                    this.data.query.setStartIndex(Integer.valueOf(this.data.query.getStartIndex() + this.data.entryIndex));
                    this.data.feed = (GaData)this.data.query.execute();
                    this.data.entryIndex = 0;
                }
            }
            catch (IOException e2) {
                throw new KettleException((Throwable)e2);
            }
        }
        List entries = this.data.feed.getRows();
        if (this.data.entryIndex < entries.size()) {
            return (List)entries.get(this.data.entryIndex++);
        }
        return null;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        super.dispose(smi, sdi);
    }

    private String removeClassifier(String original) {
        int colonIndex = original.indexOf(":");
        return original.substring(colonIndex + 1);
    }
}

