/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.googleanalytics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStep;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="TypeExitGoogleAnalyticsInputStep", i18nPackageName="org.pentaho.di.trans.steps.googleanalytics", name="GoogleAnalytics.TypeLongDesc.GoogleAnalyticsStep", description="GoogleAnalytics.TypeTooltipDesc.GoogleAnalyticsStep", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Input", image="GAN.svg", documentationUrl="http://wiki.pentaho.com/display/EAI/Google+Analytics")
public class GaInputStepMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GaInputStepMeta.class;
    public static final String FIELD_TYPE_DIMENSION = "Dimension";
    public static final String FIELD_TYPE_METRIC = "Metric";
    public static final String FIELD_TYPE_DATA_SOURCE_PROPERTY = "Data Source Property";
    public static final String FIELD_TYPE_DATA_SOURCE_FIELD = "Data Source Field";
    public static final String FIELD_DATA_SOURCE_TABLE_ID = "dxp:tableId";
    public static final String FIELD_DATA_SOURCE_TABLE_NAME = "dxp:tableName";
    public static final String PROPERTY_DATA_SOURCE_PROFILE_ID = "ga:profileId";
    public static final String PROPERTY_DATA_SOURCE_WEBPROP_ID = "ga:webPropertyId";
    public static final String PROPERTY_DATA_SOURCE_ACCOUNT_NAME = "ga:accountName";
    public static final String DEFAULT_GA_APPLICATION_NAME = "pdi-google-analytics-app";
    public static final String DEPRECATED_FIELD_TYPE_CONFIDENCE_INTERVAL = "Confidence Interval for Metric";
    private String oauthServiceAccount;
    private String oauthKeyFile;
    private String gaAppName;
    private String gaProfileTableId;
    private String gaProfileName;
    private boolean useCustomTableId;
    private String gaCustomTableId;
    private String startDate;
    private String endDate;
    private String dimensions;
    private String metrics;
    private String filters;
    private String sort;
    private boolean useSegment;
    private boolean useCustomSegment;
    private int rowLimit;
    private String customSegment;
    private String segmentName;
    private String segmentId;
    private String[] feedField;
    private String[] feedFieldType;
    private String[] outputField;
    private int[] outputType;
    private String[] conversionMask;

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        if (rowLimit < 0) {
            rowLimit = 0;
        }
        this.rowLimit = rowLimit;
    }

    public String[] getConversionMask() {
        return this.conversionMask;
    }

    public String getGaAppName() {
        return this.gaAppName;
    }

    public void setGaAppName(String gaAppName) {
        this.gaAppName = gaAppName;
    }

    public boolean isUseCustomTableId() {
        return this.useCustomTableId;
    }

    public void setUseCustomTableId(boolean useCustomTableId) {
        this.useCustomTableId = useCustomTableId;
    }

    public String getGaCustomTableId() {
        return this.gaCustomTableId;
    }

    public void setGaCustomTableId(String gaCustomTableId) {
        this.gaCustomTableId = gaCustomTableId;
    }

    public boolean isUseSegment() {
        return this.useSegment;
    }

    public void setUseSegment(boolean useSegment) {
        this.useSegment = useSegment;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public boolean isUseCustomSegment() {
        return this.useCustomSegment;
    }

    public void setUseCustomSegment(boolean useCustomSegment) {
        this.useCustomSegment = useCustomSegment;
    }

    public String getCustomSegment() {
        return this.customSegment;
    }

    public void setCustomSegment(String customSegment) {
        this.customSegment = customSegment;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public String getMetrics() {
        return this.metrics;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getGaProfileTableId() {
        return this.gaProfileTableId;
    }

    public void setGaProfileTableId(String gaProfile) {
        this.gaProfileTableId = gaProfile;
    }

    public String getGaProfileName() {
        return this.gaProfileName;
    }

    public void setGaProfileName(String gaProfileName) {
        this.gaProfileName = gaProfileName;
    }

    public String[] getFeedFieldType() {
        return this.feedFieldType;
    }

    public String[] getFeedField() {
        return this.feedField;
    }

    public String[] getOutputField() {
        return this.outputField;
    }

    public int[] getOutputType() {
        return this.outputType;
    }

    public void setDefault() {
        this.oauthServiceAccount = "service.account@developer.gserviceaccount.com";
        this.oauthKeyFile = "";
        this.useSegment = true;
        this.segmentId = "gaid::-1";
        this.segmentName = "All Visits";
        this.dimensions = "ga:browser";
        this.metrics = "ga:visits";
        this.startDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        this.endDate = new String(this.startDate);
        this.sort = "-ga:visits";
        this.gaAppName = DEFAULT_GA_APPLICATION_NAME;
        this.rowLimit = 0;
        this.allocate(0);
    }

    public void allocate(int nrkeys) {
        this.feedField = new String[nrkeys];
        this.outputField = new String[nrkeys];
        this.outputType = new int[nrkeys];
        this.feedFieldType = new String[nrkeys];
        this.conversionMask = new String[nrkeys];
    }

    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        r.clear();
        for (int i = 0; i < this.outputField.length; ++i) {
            ValueMeta v = new ValueMeta(this.outputField[i], this.outputType[i]);
            v.setOrigin(origin);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    public Object clone() {
        GaInputStepMeta retval = (GaInputStepMeta)((Object)super.clone());
        int nrKeys = this.feedField.length;
        retval.allocate(nrKeys);
        for (int i = 0; i < nrKeys; ++i) {
            retval.feedField[i] = this.feedField[i];
            retval.outputField[i] = this.outputField[i];
            retval.outputType[i] = this.outputType[i];
            retval.feedFieldType[i] = this.feedFieldType[i];
            retval.conversionMask[i] = this.conversionMask[i];
        }
        return retval;
    }

    private boolean getBooleanAttributeFromNode(Node node, String tag) {
        String sValue = XMLHandler.getTagValue((Node)node, (String)tag);
        return sValue != null && sValue.equalsIgnoreCase("Y");
    }

    public String getXML() throws KettleValueException {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)"oauthServiceAccount", (String)this.oauthServiceAccount));
        retval.append("    ").append(XMLHandler.addTagValue((String)"appName", (String)this.gaAppName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"oauthKeyFile", (String)this.oauthKeyFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"profileName", (String)this.gaProfileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"profileTableId", (String)this.gaProfileTableId));
        retval.append("    ").append(XMLHandler.addTagValue((String)"customTableId", (String)this.gaCustomTableId));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useCustomTableId", (boolean)this.useCustomTableId));
        retval.append("    ").append(XMLHandler.addTagValue((String)"startDate", (String)this.startDate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"endDate", (String)this.endDate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dimensions", (String)this.dimensions));
        retval.append("    ").append(XMLHandler.addTagValue((String)"metrics", (String)this.metrics));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filters", (String)this.filters));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sort", (String)this.sort));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useSegment", (boolean)this.useSegment));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useCustomSegment", (boolean)this.useCustomSegment));
        retval.append("    ").append(XMLHandler.addTagValue((String)"customSegment", (String)this.customSegment));
        retval.append("    ").append(XMLHandler.addTagValue((String)"segmentId", (String)this.segmentId));
        retval.append("    ").append(XMLHandler.addTagValue((String)"segmentName", (String)this.segmentName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowLimit", (int)this.rowLimit));
        for (int i = 0; i < this.feedField.length; ++i) {
            retval.append("      <feedField>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"feedFieldType", (String)this.feedFieldType[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"feedField", (String)this.feedField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"outField", (String)this.outputField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.outputType[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"conversionMask", (String)this.conversionMask[i]));
            retval.append("      </feedField>").append(Const.CR);
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String user = XMLHandler.getTagValue((Node)stepnode, (String)"user");
            String pass = XMLHandler.getTagValue((Node)stepnode, (String)"pass");
            String apiKey = XMLHandler.getTagValue((Node)stepnode, (String)"apiKey");
            this.oauthServiceAccount = XMLHandler.getTagValue((Node)stepnode, (String)"oauthServiceAccount");
            this.oauthKeyFile = XMLHandler.getTagValue((Node)stepnode, (String)"oauthKeyFile");
            if ((user != null || pass != null || apiKey != null) && this.oauthServiceAccount == null && this.oauthKeyFile == null) {
                this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.TransformationUpdateNeeded", (String[])new String[0]));
            }
            this.gaAppName = XMLHandler.getTagValue((Node)stepnode, (String)"appName");
            this.gaProfileName = XMLHandler.getTagValue((Node)stepnode, (String)"profileName");
            this.gaProfileTableId = XMLHandler.getTagValue((Node)stepnode, (String)"profileTableId");
            this.gaCustomTableId = XMLHandler.getTagValue((Node)stepnode, (String)"customTableId");
            this.useCustomTableId = this.getBooleanAttributeFromNode(stepnode, "useCustomTableId");
            this.startDate = XMLHandler.getTagValue((Node)stepnode, (String)"startDate");
            this.endDate = XMLHandler.getTagValue((Node)stepnode, (String)"endDate");
            this.dimensions = XMLHandler.getTagValue((Node)stepnode, (String)"dimensions");
            this.metrics = XMLHandler.getTagValue((Node)stepnode, (String)"metrics");
            this.filters = XMLHandler.getTagValue((Node)stepnode, (String)"filters");
            this.sort = XMLHandler.getTagValue((Node)stepnode, (String)"sort");
            this.useSegment = XMLHandler.getTagValue((Node)stepnode, (String)"useSegment") == null ? true : this.getBooleanAttributeFromNode(stepnode, "useSegment");
            this.useCustomSegment = this.getBooleanAttributeFromNode(stepnode, "useCustomSegment");
            this.customSegment = XMLHandler.getTagValue((Node)stepnode, (String)"customSegment");
            this.segmentId = XMLHandler.getTagValue((Node)stepnode, (String)"segmentId");
            this.segmentName = XMLHandler.getTagValue((Node)stepnode, (String)"segmentName");
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"rowLimit"), (int)0);
            this.allocate(0);
            int nrFields = XMLHandler.countNodes((Node)stepnode, (String)"feedField");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"feedField", (int)i);
                this.feedFieldType[i] = XMLHandler.getTagValue((Node)knode, (String)"feedFieldType");
                this.feedField[i] = XMLHandler.getTagValue((Node)knode, (String)"feedField");
                this.outputField[i] = XMLHandler.getTagValue((Node)knode, (String)"outField");
                this.outputType[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)knode, (String)"type"));
                this.conversionMask[i] = XMLHandler.getTagValue((Node)knode, (String)"conversionMask");
                if (this.outputType[i] >= 0) continue;
                this.outputType[i] = 2;
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.UnableToReadFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            String user = rep.getStepAttributeString(id_step, "user");
            String pass = rep.getStepAttributeString(id_step, "pass");
            String apiKey = rep.getStepAttributeString(id_step, "apiKey");
            this.oauthServiceAccount = rep.getStepAttributeString(id_step, "oauthServiceAccount");
            this.oauthKeyFile = rep.getStepAttributeString(id_step, "oauthKeyFile");
            if ((user != null || pass != null || apiKey != null) && this.oauthServiceAccount == null && this.oauthKeyFile == null) {
                this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.TransformationUpdateNeeded", (String[])new String[0]));
            }
            this.gaProfileName = rep.getStepAttributeString(id_step, "profileName");
            this.gaAppName = rep.getStepAttributeString(id_step, "appName");
            this.gaProfileTableId = rep.getStepAttributeString(id_step, "profileTableId");
            this.gaCustomTableId = rep.getStepAttributeString(id_step, "customTableId");
            this.useCustomTableId = rep.getStepAttributeBoolean(id_step, "useCustomTableId");
            this.startDate = rep.getStepAttributeString(id_step, "startDate");
            this.endDate = rep.getStepAttributeString(id_step, "endDate");
            this.dimensions = rep.getStepAttributeString(id_step, "dimensions");
            this.metrics = rep.getStepAttributeString(id_step, "metrics");
            this.filters = rep.getStepAttributeString(id_step, "filters");
            this.sort = rep.getStepAttributeString(id_step, "sort");
            this.useSegment = rep.getStepAttributeBoolean(id_step, 0, "useSegment", true);
            this.useCustomSegment = rep.getStepAttributeBoolean(id_step, "useCustomSegment");
            this.customSegment = rep.getStepAttributeString(id_step, "customSegment");
            this.segmentId = rep.getStepAttributeString(id_step, "segmentId");
            this.segmentName = rep.getStepAttributeString(id_step, "segmentName");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "rowLimit");
            int nrFields = rep.countNrStepAttributes(id_step, "feedField");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                this.feedFieldType[i] = rep.getStepAttributeString(id_step, i, "feedFieldType");
                this.feedField[i] = rep.getStepAttributeString(id_step, i, "feedField");
                this.outputField[i] = rep.getStepAttributeString(id_step, i, "outField");
                this.outputType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "type"));
                this.conversionMask[i] = rep.getStepAttributeString(id_step, i, "conversionMask");
                if (this.outputType[i] >= 0) continue;
                this.outputType[i] = 2;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.UnableToReadFromRep", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "oauthServiceAccount", this.oauthServiceAccount);
            rep.saveStepAttribute(id_transformation, id_step, "oauthKeyFile", this.oauthKeyFile);
            rep.saveStepAttribute(id_transformation, id_step, "appName", this.gaAppName);
            rep.saveStepAttribute(id_transformation, id_step, "profileName", this.gaProfileName);
            rep.saveStepAttribute(id_transformation, id_step, "profileTableId", this.gaProfileTableId);
            rep.saveStepAttribute(id_transformation, id_step, "customTableId", this.gaCustomTableId);
            rep.saveStepAttribute(id_transformation, id_step, "useCustomTableId", this.useCustomTableId);
            rep.saveStepAttribute(id_transformation, id_step, "startDate", this.startDate);
            rep.saveStepAttribute(id_transformation, id_step, "endDate", this.endDate);
            rep.saveStepAttribute(id_transformation, id_step, "dimensions", this.dimensions);
            rep.saveStepAttribute(id_transformation, id_step, "metrics", this.metrics);
            rep.saveStepAttribute(id_transformation, id_step, "filters", this.filters);
            rep.saveStepAttribute(id_transformation, id_step, "sort", this.sort);
            rep.saveStepAttribute(id_transformation, id_step, "useSegment", this.useSegment);
            rep.saveStepAttribute(id_transformation, id_step, "useCustomSegment", this.useCustomSegment);
            rep.saveStepAttribute(id_transformation, id_step, "customSegment", this.customSegment);
            rep.saveStepAttribute(id_transformation, id_step, "segmentId", this.segmentId);
            rep.saveStepAttribute(id_transformation, id_step, "segmentName", this.segmentName);
            rep.saveStepAttribute(id_transformation, id_step, "rowLimit", (long)this.rowLimit);
            for (int i = 0; i < this.feedField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "feedFieldType", this.feedFieldType[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "feedField", this.feedField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "outField", this.outputField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "conversionMask", this.conversionMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "type", ValueMeta.getTypeDesc((int)this.outputType[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.UnableToSaveToRep", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GoogleAnalytics.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GoogleAnalytics.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GoogleAnalytics.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GoogleAnalytics.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new GaInputStep(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new GaInputStepData();
    }

    public String getOAuthKeyFile() {
        return this.oauthKeyFile;
    }

    public void setOAuthKeyFile(String oauthKeyFile) {
        this.oauthKeyFile = oauthKeyFile;
    }

    public String getOAuthServiceAccount() {
        return this.oauthServiceAccount;
    }

    public void setOauthServiceAccount(String oauthServiceAccount) {
        this.oauthServiceAccount = oauthServiceAccount;
    }
}

