/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Algebraic;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class EvalFunc<T> {
    protected PigProgressable reporter;
    protected Log log = LogFactory.getLog(this.getClass());
    protected PigLogger pigLogger;
    private static int nextSchemaId;
    protected Type returnType;

    protected String getSchemaName(String name, Schema input) {
        String alias = name + "_";
        if (input != null && input.getAliases().size() > 0) {
            alias = alias + input.getAliases().iterator().next() + "_";
        }
        alias = alias + ++nextSchemaId;
        return alias;
    }

    public EvalFunc() {
        Class<EvalFunc> superClass = this.getClass();
        Type superType = this.getClass();
        Stack geneticsStack = new Stack();
        while (!superClass.isAssignableFrom(EvalFunc.class)) {
            superType = superClass.getGenericSuperclass();
            superClass = superClass.getSuperclass();
            geneticsStack.push((Class<?>)superType);
        }
        Type materializedType = null;
        while (!geneticsStack.isEmpty()) {
            Type aType = (Type)geneticsStack.pop();
            if (aType instanceof ParameterizedType) {
                materializedType = ((ParameterizedType)aType).getActualTypeArguments()[0];
            }
            Type currentType = materializedType;
            while (currentType instanceof ParameterizedType) {
                currentType = ((ParameterizedType)currentType).getActualTypeArguments()[0];
            }
            if (!(currentType instanceof Class)) continue;
            this.returnType = materializedType;
            break;
        }
        String errMsg = this.getClass() + "extends the raw type EvalFunc. It should extend the parameterized type EvalFunc<T> instead.";
        if (this.returnType == null) {
            throw new RuntimeException(errMsg);
        }
        if (this instanceof Algebraic) {
            Algebraic a = (Algebraic)((Object)this);
            errMsg = "function of " + this.getClass().getName() + " is not of the expected type.";
            if (this.getReturnTypeFromSpec(new FuncSpec(a.getInitial())) != Tuple.class) {
                throw new RuntimeException("Initial " + errMsg);
            }
            if (this.getReturnTypeFromSpec(new FuncSpec(a.getIntermed())) != Tuple.class) {
                throw new RuntimeException("Intermediate " + errMsg);
            }
            if (this.getReturnTypeFromSpec(new FuncSpec(a.getFinal())) != this.returnType) {
                throw new RuntimeException("Final " + errMsg);
            }
        }
    }

    private Type getReturnTypeFromSpec(FuncSpec funcSpec) {
        try {
            return ((EvalFunc)PigContext.instantiateFuncFromSpec(funcSpec)).getReturnType();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(funcSpec + " does not specify an eval func", e);
        }
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public final void progress() {
        if (this.reporter != null) {
            this.reporter.progress();
        } else {
            this.warn("No reporter object provided to UDF.", PigWarning.PROGRESS_REPORTER_NOT_PROVIDED);
        }
    }

    public final void warn(String msg, Enum warningEnum) {
        if (this.pigLogger != null) {
            this.pigLogger.warn(this, msg, warningEnum);
        } else {
            this.log.warn((Object)("No logger object provided to UDF: " + this.getClass().getName() + ". " + msg));
        }
    }

    public void finish() {
    }

    public abstract T exec(Tuple var1) throws IOException;

    public Schema outputSchema(Schema input) {
        return null;
    }

    @Deprecated
    public boolean isAsynchronous() {
        return false;
    }

    public PigProgressable getReporter() {
        return this.reporter;
    }

    public final void setReporter(PigProgressable reporter) {
        this.reporter = reporter;
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        return null;
    }

    public PigLogger getPigLogger() {
        return this.pigLogger;
    }

    public final void setPigLogger(PigLogger pigLogger) {
        this.pigLogger = pigLogger;
    }

    public Log getLogger() {
        return this.log;
    }
}

