/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogicalToPhysicalTranslatorException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Add;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Divide;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GreaterThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LessThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Mod;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Multiply;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.NotEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POAnd;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POIsNull;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONegative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONot;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POOr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORegexp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Subtract;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.GFCross;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONative;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.DependencyOrderWalkerWOSeenChk;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CompilerUtils;
import org.apache.pig.impl.util.LinkedMultiMap;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogToPhyTranslationVisitor
extends LOVisitor {
    protected Map<LogicalOperator, PhysicalOperator> logToPhyMap;
    protected Stack<PhysicalPlan> currentPlans;
    protected PhysicalPlan currentPlan;
    protected NodeIdGenerator nodeGen = NodeIdGenerator.getGenerator();
    protected PigContext pc;

    public LogToPhyTranslationVisitor(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        this.currentPlans = new Stack();
        this.currentPlan = new PhysicalPlan();
        this.logToPhyMap = new HashMap<LogicalOperator, PhysicalOperator>();
    }

    public void setPigContext(PigContext pc) {
        this.pc = pc;
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.currentPlan;
    }

    @Override
    protected void visit(LOGreaterThan op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        GreaterThanExpr exprOp = new GreaterThanExpr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setOperandType(op.getLhsOperand().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOGreaterThan> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOLesserThan op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        LessThanExpr exprOp = new LessThanExpr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setOperandType(op.getLhsOperand().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOLesserThan> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOGreaterThanEqual op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        GTOrEqualToExpr exprOp = new GTOrEqualToExpr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setOperandType(op.getLhsOperand().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOGreaterThanEqual> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOLesserThanEqual op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        LTOrEqualToExpr exprOp = new LTOrEqualToExpr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setOperandType(op.getLhsOperand().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOLesserThanEqual> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOEqual op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        EqualToExpr exprOp = new EqualToExpr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setOperandType(op.getLhsOperand().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOEqual> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LONotEqual op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        NotEqualToExpr exprOp = new NotEqualToExpr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setOperandType(op.getLhsOperand().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LONotEqual> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LORegexp op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        PORegexp exprOp = new PORegexp(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LORegexp> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        int counter = 0;
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            if (from.getClass().getCanonicalName().compareTo(ConstantExpression.class.getCanonicalName()) == 0 && counter == 1) {
                exprOp.setConstExpr(true);
            }
            ++counter;
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOAdd op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        Add exprOp = new Add(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setResultType(op.getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOAdd> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOSubtract op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        Subtract exprOp = new Subtract(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setResultType(op.getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOSubtract> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOMultiply op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        Multiply exprOp = new Multiply(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setResultType(op.getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOMultiply> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LODivide op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        Divide exprOp = new Divide(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setResultType(op.getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LODivide> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOMod op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        Mod exprOp = new Mod(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setResultType(op.getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOMod> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOAnd op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POAnd exprOp = new POAnd(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOAnd> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOOr op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POOr exprOp = new POOr(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhsOperand()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhsOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LOOr> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LONot op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        PONot exprOp = new PONot(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setExpr((ExpressionOperator)this.logToPhyMap.get(op.getOperand()));
        LogicalPlan lp = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<LONot> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        PhysicalOperator from = this.logToPhyMap.get(predecessors.get(0));
        try {
            this.currentPlan.connect(from, exprOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOCross cs) throws VisitorException {
        PhysicalPlan fep1;
        String scope = cs.getOperatorKey().scope;
        List<LogicalOperator> inputs = cs.getInputs();
        POGlobalRearrange poGlobal = new POGlobalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism());
        poGlobal.setCustomPartitioner(cs.getCustomPartitioner());
        poGlobal.setAlias(cs.getAlias());
        POPackage poPackage = new POPackage(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism());
        poGlobal.setAlias(cs.getAlias());
        this.currentPlan.add(poGlobal);
        this.currentPlan.add(poPackage);
        int count = 0;
        try {
            this.currentPlan.connect(poGlobal, poPackage);
            List<Boolean> flattenLst = Arrays.asList(true, true);
            for (LogicalOperator op : inputs) {
                List<PhysicalOperator> pop = Arrays.asList(this.logToPhyMap.get(op));
                fep1 = new PhysicalPlan();
                ConstantExpression ce1 = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism());
                ce1.setValue(inputs.size());
                ce1.setResultType((byte)10);
                fep1.add(ce1);
                ConstantExpression ce2 = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism());
                ce2.setValue(count);
                ce2.setResultType((byte)10);
                fep1.add(ce2);
                POUserFunc gfc = new POUserFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism(), Arrays.asList(ce1, ce2), new FuncSpec(GFCross.class.getName()));
                gfc.setAlias(cs.getAlias());
                gfc.setResultType((byte)120);
                fep1.addAsLeaf(gfc);
                gfc.setInputs(Arrays.asList(ce1, ce2));
                PhysicalPlan fep2 = new PhysicalPlan();
                POProject feproj = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism());
                feproj.setAlias(cs.getAlias());
                feproj.setResultType((byte)110);
                feproj.setStar(true);
                feproj.setOverloaded(false);
                fep2.add(feproj);
                List<PhysicalPlan> fePlans = Arrays.asList(fep1, fep2);
                POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism(), fePlans, flattenLst);
                fe.setAlias(cs.getAlias());
                this.currentPlan.add(fe);
                this.currentPlan.connect(this.logToPhyMap.get(op), fe);
                POLocalRearrange physOp = new POLocalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism());
                physOp.setAlias(cs.getAlias());
                ArrayList<PhysicalPlan> lrPlans = new ArrayList<PhysicalPlan>();
                for (int i = 0; i < inputs.size(); ++i) {
                    PhysicalPlan lrp1 = new PhysicalPlan();
                    POProject lrproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism(), i);
                    lrproj1.setAlias(cs.getAlias());
                    lrproj1.setOverloaded(false);
                    lrproj1.setResultType((byte)10);
                    lrp1.add(lrproj1);
                    lrPlans.add(lrp1);
                }
                physOp.setCross(true);
                physOp.setIndex(count++);
                physOp.setKeyType((byte)110);
                physOp.setPlans(lrPlans);
                physOp.setResultType((byte)110);
                this.currentPlan.add(physOp);
                this.currentPlan.connect(fe, physOp);
                this.currentPlan.connect(physOp, poGlobal);
            }
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e1);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on newly create POLocalRearrange.";
            throw new VisitorException(msg, errCode, 4, e);
        }
        poPackage.setKeyType((byte)110);
        poPackage.setResultType((byte)110);
        poPackage.setNumInps(count);
        boolean[] inner = new boolean[count];
        for (int i = 0; i < count; ++i) {
            inner[i] = true;
        }
        poPackage.setInner(inner);
        ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
        ArrayList<Boolean> flattenLst = new ArrayList<Boolean>();
        for (int i = 1; i <= count; ++i) {
            fep1 = new PhysicalPlan();
            POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism(), i);
            feproj1.setAlias(cs.getAlias());
            feproj1.setResultType((byte)120);
            feproj1.setOverloaded(false);
            fep1.add(feproj1);
            fePlans.add(fep1);
            flattenLst.add(true);
        }
        POForEach fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), cs.getRequestedParallelism(), fePlans, flattenLst);
        fe.setAlias(cs.getAlias());
        this.currentPlan.add(fe);
        try {
            this.currentPlan.connect(poPackage, fe);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e1);
        }
        this.logToPhyMap.put(cs, fe);
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        switch (cg.getGroupType()) {
            case COLLECTED: {
                this.translateCollectedCogroup(cg);
                break;
            }
            case REGULAR: {
                POPackage poPackage = this.compileToLR_GR_PackTrio(cg.getOperatorKey().scope, cg.getInputs(), cg.getRequestedParallelism(), cg.getCustomPartitioner(), cg.getAlias(), cg.getInner(), cg.getGroupByPlans());
                poPackage.setPackageType(POPackage.PackageType.GROUP);
                this.logToPhyMap.put(cg, poPackage);
                break;
            }
            case MERGE: {
                if (!this.validateMergeCogrp(cg.getInner())) {
                    throw new LogicalToPhysicalTranslatorException("Inner is not supported for any relation on Merge Cogroup.");
                }
                String alias = cg.getAlias();
                List<LogicalOperator> inputs = cg.getInputs();
                this.validateMapSideMerge(inputs, cg.getPlan());
                POMergeCogroup poCogrp = this.compileToMergeCogrp(cg.getOperatorKey().scope, inputs, cg.getGroupByPlans(), alias, cg.getRequestedParallelism());
                poCogrp.setResultType((byte)110);
                poCogrp.setAlias(cg.getAlias());
                this.currentPlan.add(poCogrp);
                for (LogicalOperator op : inputs) {
                    try {
                        this.currentPlan.connect(this.logToPhyMap.get(op), poCogrp);
                    }
                    catch (PlanException e) {
                        int errCode = 2015;
                        String msg = "Invalid physical operators in the physical plan";
                        throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
                    }
                }
                this.logToPhyMap.put(cg, poCogrp);
                break;
            }
            default: {
                throw new LogicalToPhysicalTranslatorException("Unknown CoGroup Modifier", 4);
            }
        }
        this.translateSoftLinks(cg);
    }

    private boolean validateMergeCogrp(boolean[] innerFlags) {
        for (boolean flag : innerFlags) {
            if (!flag) continue;
            return false;
        }
        return true;
    }

    private POMergeCogroup compileToMergeCogrp(String scope, List<LogicalOperator> inputs, MultiMap<LogicalOperator, LogicalPlan> innerPlans, String alias, int parallel) throws VisitorException {
        POLocalRearrange[] innerLRs = new POLocalRearrange[inputs.size()];
        int count = 0;
        ArrayList<PhysicalOperator> inpPOs = new ArrayList<PhysicalOperator>(inputs.size());
        for (LogicalOperator op : inputs) {
            String msg;
            PhysicalOperator physOp = this.logToPhyMap.get(op);
            inpPOs.add(physOp);
            Collection<LogicalPlan> plans = innerPlans.get(op);
            POLocalRearrange poInnerLR = new POLocalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
            poInnerLR.setAlias(alias);
            ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
            this.currentPlans.push(this.currentPlan);
            for (LogicalPlan lp : plans) {
                this.currentPlan = new PhysicalPlan();
                PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(lp);
                this.pushWalker(childWalker);
                this.mCurrentWalker.walk(this);
                exprPlans.add(this.currentPlan);
                this.popWalker();
            }
            this.currentPlan = this.currentPlans.pop();
            try {
                poInnerLR.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                msg = "Problem with setting up local rearrange's plans.";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, pe);
            }
            innerLRs[count] = poInnerLR;
            try {
                poInnerLR.setIndex(count++);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, e1);
            }
            poInnerLR.setKeyType(plans.size() > 1 ? (byte)110 : ((PhysicalOperator)((PhysicalPlan)exprPlans.get(0)).getLeaves().get(0)).getResultType());
            poInnerLR.setResultType((byte)110);
        }
        POMergeCogroup poCogrp = new POMergeCogroup(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), inpPOs, innerLRs, parallel);
        return poCogrp;
    }

    private POPackage compileToLR_GR_PackTrio(String scope, List<LogicalOperator> inputs, int parallel, String customPartitioner, String alias, boolean[] innerFlags, MultiMap<LogicalOperator, LogicalPlan> innerPlans) throws VisitorException {
        POGlobalRearrange poGlobal = new POGlobalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel);
        poGlobal.setAlias(alias);
        poGlobal.setCustomPartitioner(customPartitioner);
        POPackage poPackage = new POPackage(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel);
        poPackage.setAlias(alias);
        this.currentPlan.add(poGlobal);
        this.currentPlan.add(poPackage);
        try {
            this.currentPlan.connect(poGlobal, poPackage);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e1);
        }
        int count = 0;
        Byte type = null;
        for (LogicalOperator op : inputs) {
            String msg;
            Collection<LogicalPlan> plans = innerPlans.get(op);
            POLocalRearrange physOp = new POLocalRearrange(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel);
            physOp.setAlias(alias);
            ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
            this.currentPlans.push(this.currentPlan);
            for (LogicalPlan lp : plans) {
                this.currentPlan = new PhysicalPlan();
                PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(lp);
                this.pushWalker(childWalker);
                this.mCurrentWalker.walk(this);
                exprPlans.add(this.currentPlan);
                this.popWalker();
            }
            this.currentPlan = this.currentPlans.pop();
            try {
                physOp.setPlans(exprPlans);
            }
            catch (PlanException pe) {
                int errCode = 2071;
                msg = "Problem with setting up local rearrange's plans.";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, pe);
            }
            try {
                physOp.setIndex(count++);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, e1);
            }
            if (plans.size() > 1) {
                type = 110;
                physOp.setKeyType(type);
            } else {
                type = ((PhysicalOperator)((PhysicalPlan)exprPlans.get(0)).getLeaves().get(0)).getResultType();
                physOp.setKeyType(type);
            }
            physOp.setResultType((byte)110);
            this.currentPlan.add(physOp);
            try {
                this.currentPlan.connect(this.logToPhyMap.get(op), physOp);
                this.currentPlan.connect(physOp, poGlobal);
            }
            catch (PlanException e) {
                int errCode = 2015;
                msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
        poPackage.setKeyType(type);
        poPackage.setResultType((byte)110);
        poPackage.setNumInps(count);
        poPackage.setInner(innerFlags);
        return poPackage;
    }

    private void translateCollectedCogroup(LOCogroup cg) throws VisitorException {
        String scope = cg.getOperatorKey().scope;
        List<LogicalOperator> inputs = cg.getInputs();
        LogicalOperator op = inputs.get(0);
        List plans = (List)cg.getGroupByPlans().get(op);
        POCollectedGroup physOp = new POCollectedGroup(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        physOp.setAlias(cg.getAlias());
        ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
        this.currentPlans.push(this.currentPlan);
        for (LogicalPlan lp : plans) {
            this.currentPlan = new PhysicalPlan();
            PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(lp);
            this.pushWalker(childWalker);
            this.mCurrentWalker.walk(this);
            exprPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        try {
            physOp.setPlans(exprPlans);
        }
        catch (PlanException pe) {
            int errCode = 2071;
            String msg = "Problem with setting up map group's plans.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, pe);
        }
        Byte type = null;
        if (plans.size() > 1) {
            type = 110;
            physOp.setKeyType(type);
        } else {
            type = ((PhysicalOperator)((PhysicalPlan)exprPlans.get(0)).getLeaves().get(0)).getResultType();
            physOp.setKeyType(type);
        }
        physOp.setResultType((byte)110);
        this.currentPlan.add(physOp);
        try {
            this.currentPlan.connect(this.logToPhyMap.get(op), physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        this.logToPhyMap.put(cg, physOp);
    }

    @Override
    protected void visit(LOJoin loj) throws VisitorException {
        String msg;
        String msg2;
        String scope = loj.getOperatorKey().scope;
        List<LogicalOperator> inputs = loj.getInputs();
        LinkedMultiMap<PhysicalOperator, PhysicalPlan> joinPlans = new LinkedMultiMap<PhysicalOperator, PhysicalPlan>();
        ArrayList<List<PhysicalPlan>> ppLists = new ArrayList<List<PhysicalPlan>>();
        ArrayList<PhysicalOperator> inp = new ArrayList<PhysicalOperator>();
        ArrayList<List<Byte>> keyTypes = new ArrayList<List<Byte>>();
        boolean[] innerFlags = loj.getInnerFlags();
        String alias = loj.getAlias();
        int parallel = loj.getRequestedParallelism();
        for (LogicalOperator op : inputs) {
            PhysicalOperator physOp = this.logToPhyMap.get(op);
            inp.add(physOp);
            List plans = (List)loj.getJoinPlans().get(op);
            ArrayList<PhysicalPlan> exprPlans = new ArrayList<PhysicalPlan>();
            this.currentPlans.push(this.currentPlan);
            for (LogicalPlan lp : plans) {
                this.currentPlan = new PhysicalPlan();
                PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(lp);
                this.pushWalker(childWalker);
                this.mCurrentWalker.walk(this);
                exprPlans.add(this.currentPlan);
                this.popWalker();
            }
            this.currentPlan = this.currentPlans.pop();
            ppLists.add(exprPlans);
            joinPlans.put(physOp, exprPlans);
            ArrayList<Byte> tupleKeyMemberTypes = new ArrayList<Byte>();
            for (PhysicalPlan exprPlan : exprPlans) {
                tupleKeyMemberTypes.add(((PhysicalOperator)exprPlan.getLeaves().get(0)).getResultType());
            }
            keyTypes.add(tupleKeyMemberTypes);
        }
        if (loj.getJoinType() == LOJoin.JOINTYPE.SKEWED) {
            String msg3;
            POSkewedJoin skj;
            try {
                skj = new POSkewedJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, innerFlags);
                skj.setAlias(alias);
                skj.setJoinPlans(joinPlans);
            }
            catch (Exception e) {
                int errCode = 2015;
                String msg4 = "Skewed Join creation failed";
                throw new LogicalToPhysicalTranslatorException(msg4, errCode, 4, e);
            }
            skj.setResultType((byte)110);
            for (int i = 0; i < inputs.size(); ++i) {
                LogicalOperator op = inputs.get(i);
                if (!innerFlags[i]) {
                    try {
                        Schema s = op.getSchema();
                        if (s == null) {
                            throw new FrontendException();
                        }
                        skj.addSchema(s);
                        continue;
                    }
                    catch (FrontendException e) {
                        int errCode = 2015;
                        msg3 = "Couldn't set the schema for outer join";
                        throw new LogicalToPhysicalTranslatorException(msg3, errCode, 4, e);
                    }
                }
                skj.addSchema(null);
            }
            this.currentPlan.add(skj);
            for (LogicalOperator op : inputs) {
                try {
                    this.currentPlan.connect(this.logToPhyMap.get(op), skj);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    msg3 = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg3, errCode, 4, e);
                }
            }
            this.logToPhyMap.put(loj, skj);
        } else if (loj.getJoinType() == LOJoin.JOINTYPE.REPLICATED) {
            POFRJoin pfrj;
            int fragment = 0;
            try {
                boolean isLeftOuter = false;
                isLeftOuter = !innerFlags[1];
                Tuple nullTuple = null;
                if (isLeftOuter) {
                    try {
                        Schema inputSchema = inputs.get(1).getSchema();
                        if (inputSchema == null) {
                            int errCode = 1109;
                            msg2 = "Input (" + inputs.get(1).getAlias() + ") " + "on which outer join is desired should have a valid schema";
                            throw new LogicalToPhysicalTranslatorException(msg2, errCode, 2);
                        }
                        nullTuple = TupleFactory.getInstance().newTuple(inputSchema.size());
                        for (int j = 0; j < inputSchema.size(); ++j) {
                            nullTuple.set(j, null);
                        }
                    }
                    catch (FrontendException e) {
                        int errCode = 2104;
                        msg2 = "Error while determining the schema of input";
                        throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, e);
                    }
                }
                pfrj = new POFRJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, ppLists, keyTypes, null, fragment, isLeftOuter, nullTuple);
                pfrj.setAlias(alias);
            }
            catch (ExecException e1) {
                int errCode = 2058;
                msg = "Unable to set index on newly create POLocalRearrange.";
                throw new VisitorException(msg, errCode, 4, e1);
            }
            pfrj.setResultType((byte)110);
            this.currentPlan.add(pfrj);
            for (LogicalOperator op : inputs) {
                try {
                    this.currentPlan.connect(this.logToPhyMap.get(op), pfrj);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    msg2 = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, e);
                }
            }
            this.logToPhyMap.put(loj, pfrj);
        } else {
            if (loj.getJoinType() == LOJoin.JOINTYPE.MERGE && this.validateMapSideMerge(inputs, loj.getPlan())) {
                PhysicalOperator smj;
                boolean usePOMergeJoin;
                boolean bl = usePOMergeJoin = inputs.size() == 2 && innerFlags[0] && innerFlags[1];
                if (usePOMergeJoin) {
                    try {
                        smj = new POMergeJoin(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, inp, joinPlans, keyTypes);
                    }
                    catch (PlanException e) {
                        int errCode = 2042;
                        msg = "Merge Join creation failed";
                        throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
                    }
                    this.logToPhyMap.put(loj, smj);
                } else {
                    smj = this.compileToMergeCogrp(scope, inputs, loj.getJoinPlans(), alias, parallel);
                }
                smj.setResultType((byte)110);
                this.currentPlan.add(smj);
                smj.setAlias(alias);
                for (LogicalOperator op : inputs) {
                    try {
                        this.currentPlan.connect(this.logToPhyMap.get(op), smj);
                    }
                    catch (PlanException e) {
                        int errCode = 2015;
                        msg2 = "Invalid physical operators in the physical plan";
                        throw new LogicalToPhysicalTranslatorException(msg2, errCode, 4, e);
                    }
                }
                if (!usePOMergeJoin) {
                    POForEach fe = this.compileFE4Flattening(innerFlags, scope, parallel, alias, inputs);
                    this.currentPlan.add(fe);
                    try {
                        this.currentPlan.connect(smj, fe);
                    }
                    catch (PlanException e) {
                        throw new LogicalToPhysicalTranslatorException(e.getMessage(), e.getErrorCode(), e.getErrorSource(), e);
                    }
                    this.logToPhyMap.put(loj, fe);
                }
                return;
            }
            if (loj.getJoinType() == LOJoin.JOINTYPE.HASH) {
                POPackage poPackage = this.compileToLR_GR_PackTrio(scope, inputs, parallel, loj.getCustomPartitioner(), alias, innerFlags, loj.getJoinPlans());
                POForEach fe = this.compileFE4Flattening(innerFlags, scope, parallel, alias, inputs);
                this.currentPlan.add(fe);
                try {
                    this.currentPlan.connect(poPackage, fe);
                }
                catch (PlanException e) {
                    throw new LogicalToPhysicalTranslatorException(e.getDetailedMessage(), e.getErrorCode(), e.getErrorSource(), e);
                }
                this.logToPhyMap.put(loj, fe);
                poPackage.setPackageType(POPackage.PackageType.JOIN);
            }
        }
        this.translateSoftLinks(loj);
    }

    private POForEach compileFE4Flattening(boolean[] innerFlags, String scope, int parallel, String alias, List<LogicalOperator> inputs) throws LogicalToPhysicalTranslatorException {
        POForEach fe;
        ArrayList<PhysicalPlan> fePlans = new ArrayList<PhysicalPlan>();
        ArrayList<Boolean> flattenLst = new ArrayList<Boolean>();
        try {
            for (int i = 0; i < inputs.size(); ++i) {
                PhysicalPlan fep1 = new PhysicalPlan();
                POProject feproj1 = new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, i + 1);
                feproj1.setAlias(alias);
                feproj1.setResultType((byte)120);
                feproj1.setOverloaded(false);
                fep1.add(feproj1);
                fePlans.add(fep1);
                if (!innerFlags[i]) {
                    LogicalOperator joinInput = inputs.get(i);
                    LogToPhyTranslationVisitor.updateWithEmptyBagCheck(fep1, joinInput);
                }
                flattenLst.add(true);
            }
            fe = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), parallel, fePlans, flattenLst);
            fe.setAlias(alias);
        }
        catch (PlanException e1) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e1);
        }
        return fe;
    }

    public static void updateWithEmptyBagCheck(PhysicalPlan fePlan, LogicalOperator joinInput) throws PlanException, LogicalToPhysicalTranslatorException {
        Schema inputSchema = null;
        try {
            inputSchema = joinInput.getSchema();
            if (inputSchema == null) {
                int errCode = 1109;
                String msg = "Input (" + joinInput.getAlias() + ") " + "on which outer join is desired should have a valid schema";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 2);
            }
        }
        catch (FrontendException e) {
            int errCode = 2104;
            String msg = "Error while determining the schema of input";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        CompilerUtils.addEmptyBagOuterJoin(fePlan, inputSchema);
    }

    private boolean validateMapSideMerge(List<LogicalOperator> preds, LogicalPlan lp) throws LogicalToPhysicalTranslatorException {
        int errCode = 1103;
        String errMsg = "Merge join/Cogroup only supports Filter, Foreach, filter and Load as its predecessor. Found : ";
        if (preds != null && !preds.isEmpty()) {
            for (LogicalOperator lo : preds) {
                if (!(lo instanceof LOFilter || lo instanceof LOForEach || lo instanceof LOLoad || lo instanceof LONative)) {
                    throw new LogicalToPhysicalTranslatorException(errMsg, errCode);
                }
                this.validateMapSideMerge(lp.getPredecessors(lo), lp);
            }
        }
        return true;
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        String scope = filter.getOperatorKey().scope;
        POFilter poFilter = new POFilter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), filter.getRequestedParallelism());
        poFilter.setAlias(filter.getAlias());
        poFilter.setResultType(filter.getType());
        this.currentPlan.add(poFilter);
        this.logToPhyMap.put(filter, poFilter);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(filter.getComparisonPlan());
        this.pushWalker(childWalker);
        this.mCurrentWalker.walk(this);
        this.popWalker();
        poFilter.setPlan(this.currentPlan);
        this.currentPlan = this.currentPlans.pop();
        List<LOFilter> op = filter.getPlan().getPredecessors(filter);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Filter.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFilter);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        this.translateSoftLinks(filter);
    }

    @Override
    protected void visit(LOStream stream) throws VisitorException {
        String scope = stream.getOperatorKey().scope;
        POStream poStream = new POStream(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), stream.getExecutableManager(), stream.getStreamingCommand(), this.pc.getProperties());
        poStream.setAlias(stream.getAlias());
        this.currentPlan.add(poStream);
        this.logToPhyMap.put(stream, poStream);
        List<LOStream> op = stream.getPlan().getPredecessors(stream);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Stream.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poStream);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOProject op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POProject exprOp = op.isSendEmptyBagOnEOP() ? new PORelationToExprProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism()) : new POProject(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        exprOp.setAlias(op.getAlias());
        exprOp.setResultType(op.getType());
        exprOp.setColumns((ArrayList)op.getProjection());
        exprOp.setStar(op.isStar());
        exprOp.setOverloaded(op.getOverloaded());
        LogicalPlan lp = op.getPlan();
        this.logToPhyMap.put(op, exprOp);
        this.currentPlan.add(exprOp);
        List<LOProject> predecessors = lp.getPredecessors(op);
        if (predecessors == null) {
            return;
        }
        for (LogicalOperator logicalOperator : predecessors) {
            PhysicalOperator from = this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LOForEach g) throws VisitorException {
        String scope = g.getOperatorKey().scope;
        ArrayList<PhysicalPlan> innerPlans = new ArrayList<PhysicalPlan>();
        ArrayList<LogicalPlan> plans = g.getForEachPlans();
        this.currentPlans.push(this.currentPlan);
        for (LogicalPlan plan : plans) {
            this.currentPlan = new PhysicalPlan();
            DependencyOrderWalkerWOSeenChk<LogicalOperator, LogicalPlan> childWalker = new DependencyOrderWalkerWOSeenChk<LogicalOperator, LogicalPlan>(plan);
            this.pushWalker(childWalker);
            ((PlanWalker)childWalker).walk(this);
            innerPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        POForEach poFE = new POForEach(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), g.getRequestedParallelism(), innerPlans, g.getFlatten());
        poFE.setAlias(g.getAlias());
        poFE.setResultType(g.getType());
        this.logToPhyMap.put(g, poFE);
        this.currentPlan.add(poFE);
        List<LOForEach> op = g.getPlan().getPredecessors(g);
        if (op == null) {
            return;
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poFE);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        this.translateSoftLinks(g);
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
        POSort sort;
        String scope = s.getOperatorKey().scope;
        List<LogicalPlan> logPlans = s.getSortColPlans();
        ArrayList<PhysicalPlan> sortPlans = new ArrayList<PhysicalPlan>(logPlans.size());
        this.currentPlans.push(this.currentPlan);
        for (LogicalPlan plan : logPlans) {
            this.currentPlan = new PhysicalPlan();
            PlanWalker<LogicalOperator, LogicalPlan> childWalker = this.mCurrentWalker.spawnChildWalker(plan);
            this.pushWalker(childWalker);
            childWalker.walk(this);
            sortPlans.add(this.currentPlan);
            this.popWalker();
        }
        this.currentPlan = this.currentPlans.pop();
        if (s.getUserFunc() == null) {
            sort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), s.getRequestedParallelism(), null, sortPlans, s.getAscendingCols(), null);
        } else {
            POUserComparisonFunc comparator = new POUserComparisonFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), s.getRequestedParallelism(), null, s.getUserFunc());
            sort = new POSort(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), s.getRequestedParallelism(), null, sortPlans, s.getAscendingCols(), comparator);
        }
        sort.setAlias(s.getAlias());
        sort.setLimit(s.getLimit());
        this.logToPhyMap.put(s, sort);
        this.currentPlan.add(sort);
        List<LOSort> op = s.getPlan().getPredecessors(s);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Sort.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, sort);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        sort.setResultType(s.getType());
        try {
            sort.setSortInfo(s.getSortInfo());
        }
        catch (FrontendException e) {
            throw new LogicalToPhysicalTranslatorException(e);
        }
    }

    @Override
    protected void visit(LODistinct op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        PODistinct physOp = new PODistinct(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        physOp.setAlias(op.getAlias());
        physOp.setResultType(op.getType());
        this.logToPhyMap.put(op, physOp);
        this.currentPlan.add(physOp);
        List<LODistinct> inputs = op.getPlan().getPredecessors(op);
        if (inputs == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Distinct.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(inputs.get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
        FileSpec splStrFile;
        String scope = split.getOperatorKey().scope;
        POSplit physOp = new POSplit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), split.getRequestedParallelism());
        physOp.setAlias(split.getAlias());
        try {
            splStrFile = new FileSpec(FileLocalizer.getTemporaryPath(this.pc).toString(), new FuncSpec(Utils.getTmpFileCompressorName(this.pc)));
        }
        catch (IOException e1) {
            byte errSrc = this.pc.getErrorSource();
            int errCode = 0;
            switch (errSrc) {
                case 4: {
                    errCode = 2016;
                    break;
                }
                case 16: {
                    errCode = 6002;
                    break;
                }
                case 8: {
                    errCode = 4003;
                }
            }
            String msg = "Unable to obtain a temporary path.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, errSrc, e1);
        }
        physOp.setSplitStore(splStrFile);
        this.logToPhyMap.put(split, physOp);
        this.currentPlan.add(physOp);
        List<LOSplit> op = split.getPlan().getPredecessors(split);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Split.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOSplitOutput split) throws VisitorException {
        String scope = split.getOperatorKey().scope;
        POFilter physOp = new POFilter(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), split.getRequestedParallelism());
        physOp.setAlias(split.getAlias());
        this.logToPhyMap.put(split, physOp);
        this.currentPlan.add(physOp);
        this.currentPlans.push(this.currentPlan);
        this.currentPlan = new PhysicalPlan();
        PlanWalker childWalker = this.mCurrentWalker.spawnChildWalker(split.getConditionPlan());
        this.pushWalker(childWalker);
        this.mCurrentWalker.walk(this);
        this.popWalker();
        physOp.setPlan(this.currentPlan);
        this.currentPlan = this.currentPlans.pop();
        this.currentPlan.add(physOp);
        List<LOSplitOutput> op = split.getPlan().getPredecessors(split);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Split Output.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        this.translateSoftLinks(split);
    }

    @Override
    protected void visit(LOUserFunc func) throws VisitorException {
        String scope = func.getOperatorKey().scope;
        Object f = PigContext.instantiateFuncFromSpec(func.getFuncSpec());
        ExpressionOperator p = f instanceof EvalFunc ? new POUserFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), func.getRequestedParallelism(), null, func.getFuncSpec(), (EvalFunc)f) : new POUserComparisonFunc(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), func.getRequestedParallelism(), null, func.getFuncSpec(), (ComparisonFunc)((Object)f));
        p.setAlias(func.getAlias());
        p.setResultType(func.getType());
        this.currentPlan.add(p);
        List<org.apache.pig.impl.logicalLayer.ExpressionOperator> fromList = func.getArguments();
        if (fromList != null) {
            for (org.apache.pig.impl.logicalLayer.ExpressionOperator op : fromList) {
                PhysicalOperator from = this.logToPhyMap.get(op);
                try {
                    this.currentPlan.connect(from, p);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    String msg = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
                }
            }
        }
        this.logToPhyMap.put(func, p);
        if (func.getImplicitReferencedOperator() != null) {
            PhysicalOperator referredOp = this.logToPhyMap.get(func.getImplicitReferencedOperator());
            ((POUserFunc)p).setReferencedOperator(referredOp);
        }
    }

    @Override
    protected void visit(LOLoad loLoad) throws VisitorException {
        String scope = loLoad.getOperatorKey().scope;
        POLoad load = new POLoad(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), loLoad.getLoadFunc());
        load.setAlias(loLoad.getAlias());
        load.setLFile(loLoad.getInputFile());
        load.setPc(this.pc);
        load.setResultType(loLoad.getType());
        load.setSignature(loLoad.getAlias());
        this.currentPlan.add(load);
        this.logToPhyMap.put(loLoad, load);
        List<LOLoad> op = loLoad.getPlan().getPredecessors(loLoad);
        if (op != null) {
            PhysicalOperator from = this.logToPhyMap.get(op.get(0));
            try {
                this.currentPlan.connect(from, load);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LONative loNative) throws VisitorException {
        String scope = loNative.getOperatorKey().scope;
        PONative poNative = new PONative(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        poNative.setAlias(loNative.getAlias());
        poNative.setNativeMRjar(loNative.getNativeMRJar());
        poNative.setParams(loNative.getParams());
        poNative.setResultType((byte)120);
        this.logToPhyMap.put(loNative, poNative);
        this.currentPlan.add(poNative);
        List<LONative> op = loNative.getPlan().getPredecessors(loNative);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Native.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poNative);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOStore loStore) throws VisitorException {
        String scope = loStore.getOperatorKey().scope;
        POStore store = new POStore(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        store.setAlias(((LogicalOperator)loStore.getPlan().getPredecessors(loStore).get(0)).getAlias());
        store.setSFile(loStore.getOutputFile());
        store.setInputSpec(loStore.getInputSpec());
        store.setSignature(loStore.getSignature());
        store.setSortInfo(loStore.getSortInfo());
        store.setIsTmpStore(loStore.isTmpStore());
        try {
            store.setSchema(new Schema(loStore.getSchema()));
        }
        catch (FrontendException e1) {
            int errorCode = 1060;
            String message = "Cannot resolve Store output schema";
            throw new VisitorException(message, errorCode, 4, e1);
        }
        this.currentPlan.add(store);
        PhysicalOperator from = this.logToPhyMap.get(loStore.getPlan().getPredecessors(loStore).get(0));
        try {
            this.currentPlan.connect(from, store);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        this.logToPhyMap.put(loStore, store);
    }

    @Override
    protected void visit(LOConst op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        ConstantExpression ce = new ConstantExpression(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)));
        ce.setAlias(op.getAlias());
        ce.setValue(op.getValue());
        ce.setResultType(op.getType());
        this.currentPlan.add(ce);
        this.logToPhyMap.put(op, ce);
    }

    @Override
    public void visit(LOBinCond op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POBinCond physOp = new POBinCond(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        physOp.setAlias(op.getAlias());
        this.logToPhyMap.put(op, physOp);
        POBinCond phy = physOp;
        ExpressionOperator cond = (ExpressionOperator)this.logToPhyMap.get(op.getCond());
        phy.setCond(cond);
        ExpressionOperator lhs = (ExpressionOperator)this.logToPhyMap.get(op.getLhsOp());
        phy.setLhs(lhs);
        ExpressionOperator rhs = (ExpressionOperator)this.logToPhyMap.get(op.getRhsOp());
        phy.setRhs(rhs);
        phy.setResultType(op.getType());
        this.currentPlan.add(physOp);
        List<LOBinCond> ops = op.getPlan().getPredecessors(op);
        for (LogicalOperator logicalOperator : ops) {
            ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(logicalOperator);
            try {
                this.currentPlan.connect(from, physOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    @Override
    protected void visit(LONegative op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        PONegative physOp = new PONegative(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism(), null);
        physOp.setAlias(op.getAlias());
        this.currentPlan.add(physOp);
        this.logToPhyMap.put(op, physOp);
        List<LONegative> inputs = op.getPlan().getPredecessors(op);
        if (inputs == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Negative.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(inputs.get(0));
        physOp.setExpr(from);
        physOp.setResultType(op.getType());
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOIsNull op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POIsNull physOp = new POIsNull(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism(), null);
        physOp.setAlias(op.getAlias());
        List<LOIsNull> inputs = op.getPlan().getPredecessors(op);
        if (inputs == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Null.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(inputs.get(0));
        physOp.setOperandType(op.getOperand().getType());
        this.currentPlan.add(physOp);
        this.logToPhyMap.put(op, physOp);
        physOp.setExpr(from);
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOMapLookup op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POMapLookUp physOp = new POMapLookUp(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism(), op.getLookUpKey());
        physOp.setResultType(op.getType());
        physOp.setAlias(op.getAlias());
        this.currentPlan.add(physOp);
        this.logToPhyMap.put(op, physOp);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getMap());
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOCast op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POCast physOp = new POCast(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        physOp.setAlias(op.getAlias());
        this.currentPlan.add(physOp);
        this.logToPhyMap.put(op, physOp);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getExpression());
        physOp.setResultType(op.getType());
        try {
            if (op.getType() == 120 || op.getType() == 110) {
                physOp.setFieldSchema(new ResourceSchema.ResourceFieldSchema(op.getFieldSchema()));
            }
        }
        catch (FrontendException e) {
            int errCode = 2216;
            String msg = "Cannot get field schema for " + op;
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
        FuncSpec lfSpec = op.getLoadFuncSpec();
        if (null != lfSpec) {
            try {
                physOp.setFuncSpec(lfSpec);
            }
            catch (IOException e) {
                int errCode = 1053;
                String msg = "Cannot resolve load function to use for casting from " + DataType.findTypeName(op.getExpression().getType()) + " to " + DataType.findTypeName(op.getType());
                throw new LogicalToPhysicalTranslatorException(msg, errCode, -1, e);
            }
        }
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOLimit limit) throws VisitorException {
        String scope = limit.getOperatorKey().scope;
        POLimit poLimit = new POLimit(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), limit.getRequestedParallelism());
        poLimit.setResultType(limit.getType());
        poLimit.setLimit(limit.getLimit());
        poLimit.setAlias(limit.getAlias());
        this.currentPlan.add(poLimit);
        this.logToPhyMap.put(limit, poLimit);
        List<LOLimit> op = limit.getPlan().getPredecessors(limit);
        if (op == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Limit.";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4);
        }
        PhysicalOperator from = this.logToPhyMap.get(op.get(0));
        try {
            this.currentPlan.connect(from, poLimit);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOUnion op) throws VisitorException {
        String scope = op.getOperatorKey().scope;
        POUnion physOp = new POUnion(new OperatorKey(scope, this.nodeGen.getNextNodeId(scope)), op.getRequestedParallelism());
        physOp.setAlias(op.getAlias());
        this.currentPlan.add(physOp);
        physOp.setResultType(op.getType());
        this.logToPhyMap.put(op, physOp);
        List<LogicalOperator> ops = op.getInputs();
        for (LogicalOperator l : ops) {
            PhysicalOperator from = this.logToPhyMap.get(l);
            try {
                this.currentPlan.connect(from, physOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, e);
            }
        }
    }

    private void translateSoftLinks(LogicalOperator op) throws VisitorException {
        List<LogicalOperator> preds = op.getPlan().getSoftLinkPredecessors(op);
        if (preds == null) {
            return;
        }
        try {
            for (LogicalOperator pred : preds) {
                PhysicalOperator from = this.logToPhyMap.get(pred);
                this.currentPlan.createSoftLink(from, (Operator)this.logToPhyMap.get(op));
            }
        }
        catch (PlanException e) {
            int errorCode = 2015;
            String msg = "Cannot translate soft link";
            throw new VisitorException(msg, errorCode, 4, e);
        }
    }
}

