/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POFilter
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    PhysicalPlan plan;
    PhysicalOperator comOp;
    byte compOperandType;

    public POFilter(OperatorKey k) {
        this(k, -1, null);
    }

    public POFilter(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POFilter(OperatorKey k, List<PhysicalOperator> inputs) {
        this(k, -1, inputs);
    }

    public POFilter(OperatorKey k, int rp, List<PhysicalOperator> inputs) {
        super(k, rp, inputs);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result inp;
        block3: {
            Result res = null;
            inp = null;
            while (true) {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block3;
                if (inp.returnStatus == 1) continue;
                this.plan.attachInput((Tuple)inp.result);
                res = this.comOp.getNext(dummyBool);
                this.plan.detachInput();
                if (res.returnStatus != 0 && res.returnStatus != 1) {
                    return res;
                }
                if (res.result != null && ((Boolean)res.result).booleanValue()) break;
            }
            if (this.lineageTracer != null) {
                ExampleTuple tIn = (ExampleTuple)inp.result;
                this.lineageTracer.insert(tIn);
                this.lineageTracer.union(tIn, tIn);
            }
            return inp;
        }
        return inp;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Filter" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitFilter(this);
    }

    public void setPlan(PhysicalPlan plan) {
        this.plan = plan;
        this.comOp = (PhysicalOperator)plan.getLeaves().get(0);
    }

    public PhysicalPlan getPlan() {
        return this.plan;
    }
}

