/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DataByteArray
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    byte[] mData = null;

    public DataByteArray() {
    }

    public DataByteArray(byte[] b) {
        this.mData = b;
    }

    public DataByteArray(DataByteArray b, DataByteArray c) {
        int i;
        byte[] ba = b == null ? null : b.get();
        byte[] ca = c == null ? null : c.get();
        int baLength = ba == null ? 0 : ba.length;
        int caLength = ca == null ? 0 : ca.length;
        int totalSize = baLength + caLength;
        if (totalSize == 0) {
            return;
        }
        this.mData = new byte[totalSize];
        for (i = 0; i < baLength; ++i) {
            this.mData[i] = ba[i];
        }
        int j = 0;
        while (j < caLength) {
            this.mData[i] = ca[j];
            ++j;
            ++i;
        }
    }

    public DataByteArray(byte[] b, int start, int end) {
        this.mData = new byte[end - start];
        for (int i = start; i < end; ++i) {
            this.mData[i - start] = b[i];
        }
    }

    public DataByteArray(String s) {
        try {
            this.mData = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.mData.length;
    }

    public byte[] get() {
        return this.mData;
    }

    public void set(byte[] b) {
        this.mData = b;
    }

    public void set(String s) {
        this.mData = s.getBytes();
    }

    public void append(DataByteArray b) {
        int i;
        byte[] ba;
        int baLength;
        int mDataLength = this.mData == null ? 0 : this.mData.length;
        int totalSize = mDataLength + (baLength = (ba = b == null ? null : b.get()) == null ? 0 : ba.length);
        if (totalSize == 0) {
            return;
        }
        byte[] oldData = this.mData == null ? new byte[]{} : (byte[])this.mData.clone();
        this.mData = new byte[totalSize];
        for (i = 0; i < mDataLength; ++i) {
            this.mData[i] = oldData[i];
        }
        int j = 0;
        while (j < baLength) {
            this.mData[i] = ba[j];
            ++j;
            ++i;
        }
    }

    public String toString() {
        String r = "";
        try {
            r = new String(this.mData, "UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    public int compareTo(Object other) {
        if (other instanceof DataByteArray) {
            DataByteArray dba = (DataByteArray)other;
            return DataByteArray.compare(this.mData, dba.mData);
        }
        return DataType.compare(this, other);
    }

    public static int compare(byte[] b1, byte[] b2) {
        int i;
        for (i = 0; i < b1.length; ++i) {
            if (i >= b2.length) {
                return 1;
            }
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (i < b2.length) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.mData.length; ++i) {
            hash = 29 * hash + this.mData[i];
        }
        return hash;
    }
}

