/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class LOCast
extends ExpressionOperator {
    private static final long serialVersionUID = 2L;
    private FuncSpec mLoadFuncSpec = null;
    private Schema.FieldSchema userSpecifiedFieldSchema;

    public LOCast(LogicalPlan plan, OperatorKey k, byte type) {
        super(plan, k);
        this.mType = type;
    }

    public ExpressionOperator getExpression() {
        List<LOCast> preds = this.getPlan().getPredecessors(this);
        if (preds == null) {
            return null;
        }
        return preds.get(0);
    }

    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public void setFieldSchema(Schema.FieldSchema fs) throws FrontendException {
        super.setFieldSchema(fs);
        this.userSpecifiedFieldSchema = new Schema.FieldSchema(fs);
    }

    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        if (!this.mIsFieldSchemaComputed) {
            this.mFieldSchema = this.userSpecifiedFieldSchema != null ? new Schema.FieldSchema(this.userSpecifiedFieldSchema) : new Schema.FieldSchema(null, this.mType);
            Schema.FieldSchema parFs = this.getExpression().getFieldSchema();
            String canonicalName = parFs != null ? parFs.canonicalName : null;
            this.mFieldSchema.setParent(canonicalName, this.getExpression());
            this.mIsFieldSchemaComputed = true;
        }
        return this.mFieldSchema;
    }

    public String name() {
        return "Cast " + this.mKey.scope + "-" + this.mKey.id;
    }

    public boolean supportsMultipleInputs() {
        return false;
    }

    public FuncSpec getLoadFuncSpec() {
        return this.mLoadFuncSpec;
    }

    public void setLoadFuncSpec(FuncSpec loadFuncSpec) {
        this.mLoadFuncSpec = loadFuncSpec;
    }

    protected Object clone() throws CloneNotSupportedException {
        LOCast clone = (LOCast)super.clone();
        if (this.mLoadFuncSpec != null) {
            clone.mLoadFuncSpec = this.mLoadFuncSpec.clone();
        }
        return clone;
    }
}

