/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.logicalLayer.ProjectFixerUpper;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaRemover;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOCogroup
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private boolean[] mIsInner;
    private static Log log = LogFactory.getLog(LOCogroup.class);
    private MultiMap<LogicalOperator, LogicalPlan> mGroupByPlans;
    private GROUPTYPE mGroupType;
    public static final Integer OPTION_GROUPTYPE = 1;

    public LOCogroup(LogicalPlan plan, OperatorKey k, MultiMap<LogicalOperator, LogicalPlan> groupByPlans, boolean[] isInner) {
        this(plan, k, groupByPlans, GROUPTYPE.REGULAR, isInner);
    }

    public LOCogroup(LogicalPlan plan, OperatorKey k, MultiMap<LogicalOperator, LogicalPlan> groupByPlans, GROUPTYPE type, boolean[] isInner) {
        super(plan, k);
        this.mGroupByPlans = groupByPlans;
        if (isInner != null) {
            this.mIsInner = Arrays.copyOf(isInner, isInner.length);
        }
        this.mGroupType = type;
    }

    public List<LogicalOperator> getInputs() {
        return this.mPlan.getPredecessors(this);
    }

    public MultiMap<LogicalOperator, LogicalPlan> getGroupByPlans() {
        return this.mGroupByPlans;
    }

    public void setGroupByPlans(MultiMap<LogicalOperator, LogicalPlan> groupByPlans) {
        this.mGroupByPlans = groupByPlans;
    }

    public boolean[] getInner() {
        return this.mIsInner;
    }

    public void setInner(boolean[] inner) {
        this.mIsInner = inner;
    }

    public GROUPTYPE getGroupType() {
        return this.mGroupType;
    }

    @Override
    public String name() {
        return this.getAliasString() + "CoGroup " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Schema getSchema() throws FrontendException {
        List<LOCogroup> inputs = this.mPlan.getPredecessors(this);
        if (!this.mIsSchemaComputed) {
            void var10_13;
            ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>(inputs.size() + 1);
            Schema groupBySchema = null;
            ArrayList<Schema.FieldSchema> groupByFss = new ArrayList<Schema.FieldSchema>();
            HashMap<String, Boolean> aliasLookup = new HashMap<String, Boolean>();
            MultiMap<String, ExpressionOperator> aliasExop = new MultiMap<String, ExpressionOperator>();
            MultiMap<Integer, String> positionAlias = new MultiMap<Integer, String>();
            MultiMap<Integer, ExpressionOperator> positionOperators = new MultiMap<Integer, ExpressionOperator>();
            for (LogicalOperator logicalOperator : inputs) {
                int n = 0;
                for (LogicalPlan plan : this.mGroupByPlans.get(logicalOperator)) {
                    for (LogicalOperator eOp : plan.getLeaves()) {
                        Schema.FieldSchema fs = ((ExpressionOperator)eOp).getFieldSchema();
                        if (null != fs) {
                            String alias = fs.alias;
                            if (null != alias) {
                                aliasLookup.put(alias, false);
                                aliasExop.put(alias, (ExpressionOperator)eOp);
                                positionAlias.put(Integer.valueOf(n), alias);
                            }
                        } else {
                            log.warn((Object)"Field Schema of an expression operator cannot be null");
                        }
                        positionOperators.put((Integer)n, (ExpressionOperator)eOp);
                    }
                    ++n;
                }
            }
            int arity = this.mGroupByPlans.get(inputs.get(0)).size();
            boolean bl = false;
            while (var10_13 < arity) {
                Collection cAliases = positionAlias.get((int)var10_13);
                if (null != cAliases) {
                    Object[] aliases = cAliases.toArray();
                    for (int j = 0; j < aliases.length; ++j) {
                        String alias = (String)aliases[j];
                        if (null != alias) {
                            Collection cEops = positionOperators.get((int)var10_13);
                            if (null != cEops) {
                                ExpressionOperator eOp = (ExpressionOperator)cEops.toArray()[0];
                                if (null != eOp) {
                                    Schema.FieldSchema fs;
                                    if (!((Boolean)aliasLookup.get(alias)).booleanValue()) {
                                        void var11_21;
                                        fs = eOp.getFieldSchema();
                                        if (null != fs) {
                                            Schema.FieldSchema fieldSchema = new Schema.FieldSchema(alias, fs.schema, fs.type);
                                            groupByFss.add(fieldSchema);
                                            aliasLookup.put(alias, true);
                                        } else {
                                            Schema.FieldSchema fieldSchema = new Schema.FieldSchema(alias, null, 50);
                                            groupByFss.add(fieldSchema);
                                        }
                                        this.setFieldSchemaParent((Schema.FieldSchema)var11_21, positionOperators, (int)var10_13);
                                    } else {
                                        void var11_24;
                                        if (j + 1 < aliases.length) continue;
                                        fs = eOp.getFieldSchema();
                                        if (null != fs) {
                                            Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, fs.schema, fs.type);
                                            groupByFss.add(fieldSchema);
                                            for (ExpressionOperator op : cEops) {
                                                Schema.FieldSchema opFs = op.getFieldSchema();
                                                if (null != opFs) {
                                                    fieldSchema.setParent(opFs.canonicalName, eOp);
                                                    continue;
                                                }
                                                fieldSchema.setParent(null, eOp);
                                            }
                                        } else {
                                            Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, null, 50);
                                            groupByFss.add(fieldSchema);
                                        }
                                        this.setFieldSchemaParent((Schema.FieldSchema)var11_24, positionOperators, (int)var10_13);
                                    }
                                    break;
                                }
                                log.debug((Object)"Cannot be here: we cannot have a collection of null expression operators");
                                continue;
                            }
                            log.debug((Object)"Cannot be here: we should have an expression operator at each position");
                            continue;
                        }
                        log.debug((Object)"Cannot be here: we cannot have a collection of null aliases ");
                    }
                } else {
                    void var11_31;
                    Collection cEops = positionOperators.get((int)var10_13);
                    if (null != cEops) {
                        ExpressionOperator eOp = (ExpressionOperator)cEops.toArray()[0];
                        if (null != eOp) {
                            Schema.FieldSchema fs = eOp.getFieldSchema();
                            if (null != fs) {
                                Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, fs.schema, fs.type);
                                groupByFss.add(fieldSchema);
                            } else {
                                Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, null, 50);
                                groupByFss.add(fieldSchema);
                            }
                        } else {
                            Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, 50);
                            groupByFss.add(fieldSchema);
                        }
                    } else {
                        Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, 50);
                        groupByFss.add(fieldSchema);
                    }
                    this.setFieldSchemaParent((Schema.FieldSchema)var11_31, positionOperators, (int)var10_13);
                }
                ++var10_13;
            }
            groupBySchema = new Schema(groupByFss);
            if (1 == arity) {
                byte by = this.getAtomicGroupByType();
                Schema schema = ((Schema.FieldSchema)groupByFss.get((int)0)).schema;
                Schema.FieldSchema groupByFs = new Schema.FieldSchema("group", schema, by);
                this.setFieldSchemaParent(groupByFs, positionOperators, 0);
                fss.add(groupByFs);
            } else {
                void var11_35;
                Schema schema = this.getTupleGroupBySchema();
                if (schema.size() != groupBySchema.size()) {
                    this.mSchema = null;
                    this.mIsSchemaComputed = false;
                    int n = 2000;
                    String msg = "Internal error. Mismatch in group by arities. Expected: " + schema + ". Found: " + groupBySchema;
                    throw new FrontendException(msg, n, 4, false, null);
                }
                boolean bl2 = false;
                while (var11_35 < schema.size()) {
                    Schema.FieldSchema mergedFs = schema.getField((int)var11_35);
                    Schema.FieldSchema groupFs = groupBySchema.getField((int)var11_35);
                    mergedFs.alias = groupFs.alias;
                    schema.addAlias(mergedFs.alias, mergedFs);
                    ++var11_35;
                }
                Schema.FieldSchema fieldSchema = new Schema.FieldSchema("group", schema);
                fss.add(fieldSchema);
                for (int i = 0; i < arity; ++i) {
                    this.setFieldSchemaParent(fieldSchema, positionOperators, i);
                }
            }
            for (LogicalOperator logicalOperator : inputs) {
                try {
                    Schema.FieldSchema bagFs = new Schema.FieldSchema(logicalOperator.getAlias(), logicalOperator.getSchema(), 120);
                    fss.add(bagFs);
                    this.setFieldSchemaParent(bagFs, logicalOperator);
                }
                catch (FrontendException ioe) {
                    this.mIsSchemaComputed = false;
                    this.mSchema = null;
                    throw ioe;
                }
            }
            this.mIsSchemaComputed = true;
            this.mSchema = new Schema(fss);
            this.mType = (byte)120;
        }
        return this.mSchema;
    }

    public boolean isTupleGroupCol() {
        List<LOCogroup> inputs = this.mPlan.getPredecessors(this);
        if (inputs == null || inputs.size() == 0) {
            throw new AssertionError((Object)"COGroup.isTupleGroupCol() can be called after it has an input only");
        }
        return this.mGroupByPlans.get(inputs.get(0)).size() > 1;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public void switchGroupByPlanOp(LogicalOperator oldOp, LogicalOperator newOp) {
        Collection<LogicalPlan> innerPlans = this.mGroupByPlans.removeKey(oldOp);
        this.mGroupByPlans.put(newOp, innerPlans);
    }

    @Override
    public void unsetSchema() throws VisitorException {
        for (LogicalOperator input : this.getInputs()) {
            for (LogicalPlan plan : this.mGroupByPlans.get(input)) {
                SchemaRemover sr = new SchemaRemover(plan);
                sr.visit();
            }
        }
        super.unsetSchema();
    }

    public byte getAtomicGroupByType() throws FrontendException {
        if (this.isTupleGroupCol()) {
            int errCode = 1010;
            String msg = "getAtomicGroupByType is used only when dealing with atomic group col";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        byte groupType = 50;
        for (int i = 0; i < this.getInputs().size(); ++i) {
            LogicalOperator input = this.getInputs().get(i);
            ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(this.getGroupByPlans().get(input));
            if (innerPlans.size() != 1) {
                int errCode = 1012;
                String msg = "Each COGroup input has to have the same number of inner plans";
                throw new FrontendException(msg, errCode, 2, false, null);
            }
            byte innerType = ((LogicalPlan)innerPlans.get(0)).getSingleLeafPlanOutputType();
            if ((groupType = DataType.mergeType(groupType, innerType)) != -1) continue;
            int errCode = 1107;
            String msg = "Cannot merge cogroup keys, incompatible types";
            throw new FrontendException(msg, errCode, 2);
        }
        return groupType;
    }

    public Schema getTupleGroupBySchema() throws FrontendException {
        int i;
        if (!this.isTupleGroupCol()) {
            int errCode = 1011;
            String msg = "getTupleGroupBySchema is used only when dealing with tuple group col";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        ArrayList<Schema.FieldSchema> fsList = new ArrayList<Schema.FieldSchema>();
        int outputSchemaSize = this.getGroupByPlans().get(this.getInputs().get(0)).size();
        for (i = 0; i < outputSchemaSize; ++i) {
            fsList.add(new Schema.FieldSchema(null, 50));
        }
        for (i = 0; i < this.getInputs().size(); ++i) {
            LogicalOperator input = this.getInputs().get(i);
            ArrayList<LogicalPlan> innerPlans = new ArrayList<LogicalPlan>(this.getGroupByPlans().get(input));
            boolean seenProjectStar = false;
            for (int j = 0; j < innerPlans.size(); ++j) {
                byte innerType = ((LogicalPlan)innerPlans.get(j)).getSingleLeafPlanOutputType();
                ExpressionOperator eOp = (ExpressionOperator)((LogicalPlan)innerPlans.get(j)).getSingleLeafPlanOutputOp();
                if (eOp instanceof LOProject && ((LOProject)eOp).isStar()) {
                    seenProjectStar = true;
                }
                Schema.FieldSchema groupFs = (Schema.FieldSchema)fsList.get(j);
                byte dt = groupFs.type;
                groupFs.type = DataType.mergeType(groupFs.type, innerType);
                if (!DataType.isUsableType(groupFs.type)) {
                    int errCode = 1110;
                    String msg = "Cogroup column " + j + " has incompatible types: " + DataType.findTypeName(dt) + " versus " + DataType.findTypeName(innerType);
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                Schema.FieldSchema fs = eOp.getFieldSchema();
                if (null != fs) {
                    groupFs.setParent(eOp.getFieldSchema().canonicalName, eOp);
                    continue;
                }
                groupFs.setParent(null, eOp);
            }
            if (!seenProjectStar) continue;
            int errCode = 1013;
            String msg = "Grouping attributes can either be star (*) or a list of expressions, but not both.";
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        return new Schema(fsList);
    }

    private void setFieldSchemaParent(Schema.FieldSchema fs, MultiMap<Integer, ExpressionOperator> positionOperators, int position) throws FrontendException {
        for (ExpressionOperator op : positionOperators.get(position)) {
            Schema.FieldSchema opFs = op.getFieldSchema();
            if (null != opFs) {
                fs.setParent(opFs.canonicalName, op);
                continue;
            }
            fs.setParent(null, op);
        }
    }

    private void setFieldSchemaParent(Schema.FieldSchema fs, LogicalOperator op) throws FrontendException {
        Schema s = op.getSchema();
        if (null != s) {
            for (Schema.FieldSchema inputFs : s.getFields()) {
                if (null != inputFs) {
                    fs.setParent(inputFs.canonicalName, op);
                    continue;
                }
                fs.setParent(null, op);
            }
        } else {
            fs.setParent(null, op);
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOCogroup cogroupClone = (LOCogroup)super.clone();
        cogroupClone.mIsInner = new boolean[this.mIsInner.length];
        for (int i = 0; i < this.mIsInner.length; ++i) {
            cogroupClone.mIsInner[i] = this.mIsInner[i];
        }
        cogroupClone.mGroupByPlans = new MultiMap();
        for (LogicalOperator relOp : this.mGroupByPlans.keySet()) {
            Collection<LogicalPlan> values = this.mGroupByPlans.get(relOp);
            Iterator<LogicalPlan> planIterator = values.iterator();
            while (planIterator.hasNext()) {
                LogicalPlanCloneHelper lpCloneHelper = new LogicalPlanCloneHelper(planIterator.next());
                cogroupClone.mGroupByPlans.put(relOp, lpCloneHelper.getClonedPlan());
            }
        }
        return cogroupClone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (outputSchema == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        MultiMap<LogicalOperator, LogicalPlan> groupByPlans = this.getGroupByPlans();
        boolean groupByAdded = false;
        MultiMap<Integer, ProjectionMap.Column> mapFields = new MultiMap<Integer, ProjectionMap.Column>();
        ArrayList<Pair<Integer, Integer>> removedFields = new ArrayList<Pair<Integer, Integer>>();
        for (int inputNum = 0; inputNum < predecessors.size() && !groupByAdded; ++inputNum) {
            Schema inputSchema;
            LogicalOperator predecessor = (LogicalOperator)predecessors.get(inputNum);
            ArrayList predecessorPlans = (ArrayList)groupByPlans.get(predecessor);
            int inputColumn = -1;
            for (LogicalPlan predecessorPlan : predecessorPlans) {
                List leaves = predecessorPlan.getLeaves();
                if (leaves == null || leaves.size() > 1) {
                    groupByAdded = true;
                    break;
                }
                if (leaves.get(0) instanceof LOProject) {
                    LOProject topProject;
                    Pair<LOProject, LOCast> pair = LogicalPlan.chainOfProjects(predecessorPlan);
                    if (pair == null || (topProject = (LOProject)pair.first) == null) continue;
                    inputColumn = topProject.getCol();
                    LOCast cast = (LOCast)pair.second;
                    if (cast != null) {
                        mapFields.put((Integer)0, new ProjectionMap.Column(new Pair<Integer, Integer>(inputNum, inputColumn), true, cast.getType()));
                        continue;
                    }
                    mapFields.put((Integer)0, new ProjectionMap.Column(new Pair<Integer, Integer>(inputNum, inputColumn)));
                    continue;
                }
                groupByAdded = true;
            }
            try {
                inputSchema = predecessor.getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            if (inputSchema == null) continue;
            for (int column = 0; column < inputSchema.size(); ++column) {
                if (groupByAdded || inputColumn == column) continue;
                removedFields.add(new Pair<Integer, Integer>(inputNum, column));
            }
        }
        ArrayList<Integer> addedFields = new ArrayList<Integer>();
        if (groupByAdded) {
            addedFields.add(0);
            mapFields = null;
        }
        for (int i = 0; i < groupByPlans.keySet().size(); ++i) {
            addedFields.add(i + 1);
        }
        if (removedFields.size() == 0) {
            removedFields = null;
        }
        this.mProjectionMap = new ProjectionMap(mapFields, removedFields, addedFields);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        List<LOCogroup> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            HashSet<Pair<Integer, Integer>> fields = new HashSet<Pair<Integer, Integer>>();
            HashSet<LOProject> projectSet = new HashSet<LOProject>();
            boolean groupByStar = false;
            for (LogicalPlan plan : this.getGroupByPlans().get(predecessors.get(inputNum))) {
                TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
                try {
                    projectFinder.visit();
                }
                catch (VisitorException ve) {
                    requiredFields.clear();
                    requiredFields.add(null);
                    return requiredFields;
                }
                projectSet.addAll(projectFinder.getProjectSet());
                if (projectFinder.getProjectStarSet() == null) continue;
                groupByStar = true;
            }
            if (groupByStar) {
                requiredFields.add(new RequiredFields(true));
                continue;
            }
            for (LOProject project : projectSet) {
                for (int inputColumn : project.getProjection()) {
                    fields.add(new Pair<Integer, Integer>(inputNum, inputColumn));
                }
            }
            if (fields.size() == 0) {
                requiredFields.add(new RequiredFields(false, true));
                continue;
            }
            requiredFields.add(new RequiredFields(new ArrayList<Pair<Integer, Integer>>(fields)));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public void rewire(Operator<LOVisitor> oldPred, int oldPredIndex, Operator<LOVisitor> newPred, boolean useOldPred) throws PlanException {
        super.rewire(oldPred, oldPredIndex, newPred, useOldPred);
        if (newPred == null) {
            int errCode = 1097;
            String msg = "Replacement node cannot be null.";
            throw new PlanException(msg, errCode, 2);
        }
        LogicalOperator previous = (LogicalOperator)oldPred;
        LogicalOperator current = (LogicalOperator)newPred;
        HashSet<LogicalOperator> cogroupInputs = new HashSet<LogicalOperator>(this.mGroupByPlans.keySet());
        for (LogicalOperator input : cogroupInputs) {
            if (!input.equals(previous)) continue;
            for (LogicalPlan plan : this.mGroupByPlans.get(input)) {
                try {
                    ProjectFixerUpper projectFixer = new ProjectFixerUpper(plan, previous, oldPredIndex, current, useOldPred, this);
                    projectFixer.visit();
                }
                catch (VisitorException ve) {
                    int errCode = 2144;
                    String msg = "Problem while fixing project inputs during rewiring.";
                    throw new PlanException(msg, errCode, 4, ve);
                }
            }
            List plans = (List)this.mGroupByPlans.get(previous);
            this.mGroupByPlans.removeKey(previous);
            this.mGroupByPlans.put(current, plans);
        }
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return null;
        }
        if (column > predecessors.size()) {
            return null;
        }
        if (column == 0) {
            return this.getRequiredFields();
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        for (int inputNum = 0; inputNum < predecessors.size(); ++inputNum) {
            if (inputNum == column - 1) {
                result.add(new RequiredFields(true));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (this.mSchema == null) {
            log.warn((Object)"Cannot prune columns in cogroup, no schema information found");
            return false;
        }
        List<LOCogroup> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            int errCode = 2190;
            throw new FrontendException("Cannot find predecessors for cogroup", errCode, 4);
        }
        for (int i = columns.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> column = columns.get(i);
            if ((Integer)column.first < 0 || (Integer)column.first > predecessors.size()) {
                int errCode = 2191;
                throw new FrontendException("No input " + column.first + " to prune in cocogroup", errCode, 4);
            }
            if ((Integer)column.second < 0) {
                int errCode = 2192;
                throw new FrontendException("column to prune does not exist", errCode, 4);
            }
            for (LogicalPlan plan : this.getGroupByPlans().get(predecessors.get((Integer)column.first))) {
                this.pruneColumnInPlan(plan, (Integer)column.second);
            }
        }
        super.pruneColumns(columns);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GROUPTYPE {
        REGULAR,
        COLLECTED,
        MERGE;

    }
}

