/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.logicalLayer.ProjectFixerUpper;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.optimizer.SchemaRemover;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOForEach
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private ArrayList<LogicalPlan> mForEachPlans;
    private ArrayList<Boolean> mFlatten;
    private ArrayList<Schema> mUserDefinedSchema = null;
    private static Log log = LogFactory.getLog(LOForEach.class);
    private List<LogicalPlan> mSchemaPlanMapping = new ArrayList<LogicalPlan>();

    public LOForEach(LogicalPlan plan, OperatorKey k, ArrayList<LogicalPlan> foreachPlans, ArrayList<Boolean> flattenList) {
        super(plan, k);
        this.mForEachPlans = foreachPlans;
        this.mFlatten = flattenList;
    }

    public LOForEach(LogicalPlan plan, OperatorKey k, ArrayList<LogicalPlan> foreachPlans, ArrayList<Boolean> flattenList, ArrayList<Schema> userDefinedSchemaList) {
        super(plan, k);
        this.mForEachPlans = foreachPlans;
        this.mFlatten = flattenList;
        this.mUserDefinedSchema = userDefinedSchemaList;
    }

    public ArrayList<LogicalPlan> getForEachPlans() {
        return this.mForEachPlans;
    }

    public void setForEachPlans(ArrayList<LogicalPlan> foreachPlans) {
        this.mForEachPlans = foreachPlans;
    }

    public List<Boolean> getFlatten() {
        return this.mFlatten;
    }

    public void setFlatten(ArrayList<Boolean> flattenList) {
        this.mFlatten = flattenList;
    }

    public List<Schema> getUserDefinedSchema() {
        return this.mUserDefinedSchema;
    }

    public void setUserDefinedSchema(ArrayList<Schema> userDefinedSchema) {
        this.mUserDefinedSchema = userDefinedSchema;
    }

    @Override
    public String name() {
        return this.getAliasString() + "ForEach " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public byte getType() {
        return 120;
    }

    private void updateAliasCount(Map<String, Integer> aliases, String alias) {
        if (null == aliases || null == alias) {
            return;
        }
        Integer count = aliases.get(alias);
        if (null == count) {
            aliases.put(alias, 1);
        } else {
            aliases.put(alias, count + 1);
        }
    }

    @Override
    public Schema getSchema() throws FrontendException {
        log.debug((Object)"Entering getSchema");
        if (!this.mIsSchemaComputed) {
            ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>(this.mForEachPlans.size());
            this.mSchemaPlanMapping = new ArrayList<LogicalPlan>();
            for (LogicalPlan plan : this.mForEachPlans) {
                log.debug((Object)("Number of leaves in " + plan + " = " + plan.getLeaves().size()));
                for (int i = 0; i < plan.getLeaves().size(); ++i) {
                    log.debug((Object)("Leaf" + i + "= " + plan.getLeaves().get(i)));
                }
                LogicalOperator op = (LogicalOperator)plan.getLeaves().get(0);
                log.debug((Object)("op: " + op.getClass().getName() + " " + op));
            }
            log.debug((Object)"Printed the leaves of the generate plans");
            HashMap<Schema.FieldSchema, String> flattenAlias = new HashMap<Schema.FieldSchema, String>();
            HashMap<String, Boolean> inverseFlattenAlias = new HashMap<String, Boolean>();
            HashMap<String, Integer> aliases = new HashMap<String, Integer>();
            for (int planCtr = 0; planCtr < this.mForEachPlans.size(); ++planCtr) {
                LogicalPlan plan = this.mForEachPlans.get(planCtr);
                LogicalOperator op = (LogicalOperator)plan.getLeaves().get(0);
                log.debug((Object)("op: " + op.getClass().getName() + " " + op));
                log.debug((Object)("Flatten: " + this.mFlatten.get(planCtr)));
                if (op instanceof LOProject && ((LOProject)op).isStar() && ((LOProject)op).getType() == 110) {
                    this.mSchema = null;
                    this.mIsSchemaComputed = true;
                    return this.mSchema;
                }
                try {
                    String outerCanonicalAlias;
                    Schema.FieldSchema planFs = ((ExpressionOperator)op).getFieldSchema();
                    log.debug((Object)("planFs: " + planFs));
                    Schema userDefinedSchema = null;
                    if (null != this.mUserDefinedSchema) {
                        userDefinedSchema = this.mUserDefinedSchema.get(planCtr);
                    }
                    if (null != planFs) {
                        String msg;
                        outerCanonicalAlias = op.getAlias();
                        if (null == outerCanonicalAlias) {
                            outerCanonicalAlias = planFs.alias;
                        }
                        log.debug((Object)("Outer canonical alias: " + outerCanonicalAlias));
                        if (this.mFlatten.get(planCtr).booleanValue()) {
                            Schema s = planFs.schema;
                            if (null != s && s.isTwoLevelAccessRequired()) {
                                if (s.getFields().size() != 1) {
                                    int errCode = 1008;
                                    String msg2 = "Expected a bag schema with a single element of type " + DataType.findTypeName((byte)110) + " but got a bag schema with multiple elements.";
                                    throw new FrontendException(msg2, errCode, 2, false, null);
                                }
                                Schema.FieldSchema tupleFS = s.getField(0);
                                if (tupleFS.type != 110) {
                                    int errCode = 1009;
                                    msg = "Expected a bag schema with a single element of type " + DataType.findTypeName((byte)110) + " but got an element of type " + DataType.findTypeName(tupleFS.type);
                                    throw new FrontendException(msg, errCode, 2, false, null);
                                }
                                s = tupleFS.schema;
                            }
                            if (null != s && s.size() != 0) {
                                for (int i = 0; i < s.size(); ++i) {
                                    Schema.FieldSchema newFs;
                                    Schema.FieldSchema fs = Schema.FieldSchema.copyAndLink(s.getField(i), op);
                                    log.debug((Object)("fs: " + fs));
                                    if (null != userDefinedSchema) {
                                        try {
                                            if (i < userDefinedSchema.size()) {
                                                Schema.FieldSchema userDefinedFieldSchema = userDefinedSchema.getField(i);
                                                fs = fs.mergePrefixFieldSchema(userDefinedFieldSchema);
                                            }
                                        }
                                        catch (SchemaMergeException sme) {
                                            int errCode = 1016;
                                            String msg3 = "Problems in merging user defined schema";
                                            throw new FrontendException(msg3, errCode, 2, false, null, sme);
                                        }
                                        outerCanonicalAlias = null;
                                    }
                                    String innerCanonicalAlias = fs.alias;
                                    if (null != outerCanonicalAlias && null != innerCanonicalAlias) {
                                        String disambiguatorAlias = outerCanonicalAlias + "::" + innerCanonicalAlias;
                                        newFs = new Schema.FieldSchema(disambiguatorAlias, fs.schema, fs.type);
                                        newFs.setParent(s.getField((int)i).canonicalName, op);
                                        fss.add(newFs);
                                        this.mSchemaPlanMapping.add(plan);
                                        this.updateAliasCount(aliases, disambiguatorAlias);
                                    } else {
                                        newFs = new Schema.FieldSchema(fs);
                                        newFs.setParent(s.getField((int)i).canonicalName, op);
                                        fss.add(newFs);
                                        this.mSchemaPlanMapping.add(plan);
                                    }
                                    this.updateAliasCount(aliases, innerCanonicalAlias);
                                    flattenAlias.put(newFs, innerCanonicalAlias);
                                    inverseFlattenAlias.put(innerCanonicalAlias, true);
                                }
                                continue;
                            }
                            if (null != userDefinedSchema) {
                                if (!DataType.isSchemaType(planFs.type)) {
                                    if (userDefinedSchema.size() > 1) {
                                        int errCode = 1017;
                                        msg = "Schema mismatch. A basic type on flattening cannot have more than one column. User defined schema: " + userDefinedSchema;
                                        throw new FrontendException(msg, errCode, 2, false, null);
                                    }
                                    Schema.FieldSchema newFs = new Schema.FieldSchema(null, planFs.type);
                                    try {
                                        newFs = newFs.mergePrefixFieldSchema(userDefinedSchema.getField(0));
                                    }
                                    catch (SchemaMergeException sme) {
                                        int errCode = 1016;
                                        String msg4 = "Problems in merging user defined schema";
                                        throw new FrontendException(msg4, errCode, 2, false, null, sme);
                                    }
                                    this.updateAliasCount(aliases, newFs.alias);
                                    fss.add(newFs);
                                    this.mSchemaPlanMapping.add(plan);
                                    newFs.setParent(planFs.canonicalName, op);
                                    continue;
                                }
                                for (Schema.FieldSchema ufs : userDefinedSchema.getFields()) {
                                    Schema.FieldSchema.setFieldSchemaDefaultType(ufs, (byte)50);
                                    Schema.FieldSchema newFs = new Schema.FieldSchema(ufs);
                                    fss.add(newFs);
                                    this.mSchemaPlanMapping.add(plan);
                                    newFs.setParent(null, op);
                                    this.updateAliasCount(aliases, ufs.alias);
                                }
                                continue;
                            }
                            Schema.FieldSchema newFs = !DataType.isSchemaType(planFs.type) ? new Schema.FieldSchema(planFs.alias, planFs.type) : new Schema.FieldSchema(null, 50);
                            fss.add(newFs);
                            this.mSchemaPlanMapping.add(plan);
                            newFs.setParent(planFs.canonicalName, op);
                            continue;
                        }
                        Schema.FieldSchema newFs = Schema.FieldSchema.copyAndLink(planFs, op);
                        if (null != userDefinedSchema) {
                            try {
                                newFs = newFs.mergePrefixFieldSchema(userDefinedSchema.getField(0));
                                this.updateAliasCount(aliases, newFs.alias);
                            }
                            catch (SchemaMergeException sme) {
                                int errCode = 1016;
                                msg = "Problems in merging user defined schema";
                                throw new FrontendException(msg, errCode, 2, false, null, sme);
                            }
                        }
                        newFs.setParent(planFs.canonicalName, op);
                        fss.add(newFs);
                        this.mSchemaPlanMapping.add(plan);
                        continue;
                    }
                    outerCanonicalAlias = null;
                    if (null != userDefinedSchema) {
                        Schema.FieldSchema userDefinedFieldSchema = new Schema.FieldSchema(userDefinedSchema.getField(0));
                        fss.add(userDefinedFieldSchema);
                        this.mSchemaPlanMapping.add(plan);
                        userDefinedFieldSchema.setParent(null, op);
                        this.updateAliasCount(aliases, userDefinedFieldSchema.alias);
                        continue;
                    }
                    this.mSchema = null;
                    this.mIsSchemaComputed = true;
                    return this.mSchema;
                }
                catch (FrontendException fee) {
                    this.mSchema = null;
                    this.mIsSchemaComputed = false;
                    throw fee;
                }
            }
            log.debug((Object)(" flattenAlias: " + flattenAlias));
            log.debug((Object)(" inverseFlattenAlias: " + inverseFlattenAlias));
            log.debug((Object)(" aliases: " + aliases));
            log.debug((Object)(" fss.size: " + fss.size()));
            boolean duplicates = false;
            HashMap duplicateAliases = new HashMap();
            for (Map.Entry e : aliases.entrySet()) {
                Integer count = (Integer)e.getValue();
                if (count <= 1) continue;
                Boolean inFlatten = false;
                log.debug((Object)("inFlatten: " + inFlatten + " inverseFlattenAlias: " + inverseFlattenAlias));
                inFlatten = (Boolean)inverseFlattenAlias.get(e.getKey());
                log.debug((Object)("inFlatten: " + inFlatten + " inverseFlattenAlias: " + inverseFlattenAlias));
                if (null != inFlatten && inFlatten.booleanValue()) continue;
                duplicates = true;
                duplicateAliases.put(e.getKey(), count);
            }
            if (duplicates) {
                StringBuffer sb = new StringBuffer("Found duplicates in schema. ");
                if (duplicateAliases.size() > 0) {
                    Set es = duplicateAliases.entrySet();
                    Iterator iter = es.iterator();
                    Map.Entry e = iter.next();
                    sb.append(": ");
                    sb.append(e.getValue());
                    sb.append(" columns");
                    while (iter.hasNext()) {
                        e = iter.next();
                        sb.append(", ");
                        sb.append((String)e.getKey());
                        sb.append(": ");
                        sb.append(e.getValue());
                        sb.append(" columns");
                    }
                }
                sb.append(". Please alias the columns with unique names.");
                String errMessage = sb.toString();
                log.debug((Object)errMessage);
                int errCode = 1007;
                throw new FrontendException(errMessage, errCode, 2, false, null);
            }
            this.mSchema = new Schema(fss);
            for (int i = 0; i < this.mSchema.getFields().size(); ++i) {
                Schema.FieldSchema fs = this.mSchema.getFields().get(i);
                String alias = (String)flattenAlias.get(fs);
                Integer count = (Integer)aliases.get(alias);
                if (null == count) {
                    count = 1;
                }
                log.debug((Object)("alias: " + alias));
                if (null == alias || count != 1) continue;
                this.mSchema.addAlias(alias, fs);
            }
            this.mIsSchemaComputed = true;
        }
        log.debug((Object)"Exiting getSchema");
        return this.mSchema;
    }

    @Override
    public void unsetSchema() throws VisitorException {
        for (LogicalPlan plan : this.mForEachPlans) {
            SchemaRemover sr = new SchemaRemover(plan);
            sr.visit();
        }
        super.unsetSchema();
        this.mSchemaPlanMapping = new ArrayList<LogicalPlan>();
    }

    private void doAllSuccessors(LogicalPlan lp, LogicalOperator node, Set<LogicalOperator> seen, Collection<LogicalOperator> fifo) throws VisitorException {
        if (!seen.contains(node)) {
            List<LogicalOperator> succs = lp.getSuccessors(node);
            if (succs != null && succs.size() > 0) {
                for (LogicalOperator op : succs) {
                    this.doAllSuccessors(lp, op, seen, fifo);
                }
            }
            seen.add(node);
            fifo.add(node);
        }
    }

    public Schema dumpNestedSchema(String alias, String nestedAlias) throws IOException {
        boolean found = false;
        for (LogicalPlan lp : this.mForEachPlans) {
            ArrayList<LogicalOperator> fifo = new ArrayList<LogicalOperator>();
            HashSet<LogicalOperator> seen = new HashSet<LogicalOperator>();
            for (LogicalOperator op : lp.getRoots()) {
                this.doAllSuccessors(lp, op, seen, fifo);
            }
            for (LogicalOperator op : fifo) {
                if (op instanceof LOProject || !nestedAlias.equalsIgnoreCase(op.mAlias)) continue;
                found = true;
                if (op instanceof RelationalOperator) {
                    Schema nestedSc = op.getSchema();
                    if (nestedSc == null) {
                        System.out.println("Schema for " + alias + "::" + nestedAlias + " unknown.");
                    } else {
                        System.out.println(alias + "::" + nestedAlias + ": " + nestedSc.toString());
                    }
                    return nestedSc;
                }
                int errCode = 1113;
                String msg = "Describe nested expression is not supported";
                throw new FrontendException(msg, errCode, 2, false, null);
            }
        }
        if (!found) {
            int errCode = 1114;
            String msg = "Unable to find schema for nested alias " + nestedAlias;
            throw new FrontendException(msg, errCode, 2, false, null);
        }
        return null;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Iterator<Serializable> it;
        LOForEach forEachClone = (LOForEach)super.clone();
        if (this.mFlatten != null) {
            forEachClone.mFlatten = new ArrayList();
            it = this.mFlatten.iterator();
            while (it.hasNext()) {
                forEachClone.mFlatten.add((boolean)((Boolean)it.next()));
            }
        }
        if (this.mForEachPlans != null) {
            forEachClone.mForEachPlans = new ArrayList();
            it = this.mForEachPlans.iterator();
            while (it.hasNext()) {
                LogicalPlanCloneHelper lpCloneHelper = new LogicalPlanCloneHelper((LogicalPlan)it.next());
                forEachClone.mForEachPlans.add(lpCloneHelper.getClonedPlan());
            }
        }
        if (this.mUserDefinedSchema != null) {
            forEachClone.mUserDefinedSchema = new ArrayList();
            for (Schema s : this.mUserDefinedSchema) {
                forEachClone.mUserDefinedSchema.add(s != null ? s.clone() : null);
            }
        }
        return forEachClone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema inputSchema;
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (outputSchema == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        LogicalOperator predecessor = (LogicalOperator)predecessors.get(0);
        try {
            inputSchema = predecessor.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        ArrayList<LogicalPlan> foreachPlans = this.getForEachPlans();
        List<Boolean> flattenList = this.getFlatten();
        MultiMap<Integer, ProjectionMap.Column> mapFields = new MultiMap<Integer, ProjectionMap.Column>();
        ArrayList<Integer> addedFields = new ArrayList<Integer>();
        int outputColumn = 0;
        for (int i = 0; i < foreachPlans.size(); ++i) {
            Schema.FieldSchema leafFS;
            Pair<LOProject, LOCast> pair;
            LogicalPlan foreachPlan = (LogicalPlan)foreachPlans.get(i);
            List leaves = foreachPlan.getLeaves();
            if (leaves == null || leaves.size() > 1) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            int inputColumn = -1;
            boolean mapped = false;
            LOCast cast = null;
            if ((leaves.get(0) instanceof LOProject || leaves.get(0) instanceof LOCast) && (pair = LogicalPlan.chainOfProjects(foreachPlan)) != null) {
                LOProject topProject = (LOProject)pair.first;
                cast = (LOCast)pair.second;
                if (topProject != null) {
                    inputColumn = topProject.getCol();
                    mapped = true;
                }
            }
            try {
                leafFS = ((ExpressionOperator)leaves.get(0)).getFieldSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            if (leafFS == null) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
            if (flattenList.get(i).booleanValue()) {
                Schema innerSchema = leafFS.schema;
                if (innerSchema != null) {
                    if (innerSchema.isTwoLevelAccessRequired()) {
                        Schema.FieldSchema tupleFS;
                        if (innerSchema.getFields().size() != 1) {
                            this.mProjectionMap = null;
                            return this.mProjectionMap;
                        }
                        try {
                            tupleFS = innerSchema.getField(0);
                        }
                        catch (FrontendException fee) {
                            this.mProjectionMap = null;
                            return this.mProjectionMap;
                        }
                        if (tupleFS.type != 110) {
                            this.mProjectionMap = null;
                            return this.mProjectionMap;
                        }
                        innerSchema = tupleFS.schema;
                    }
                    if (innerSchema != null) {
                        for (int j = 0; j < innerSchema.size(); ++j) {
                            if (mapped) {
                                if (cast != null) {
                                    mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn), true, cast.getType()));
                                    continue;
                                }
                                mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn)));
                                continue;
                            }
                            addedFields.add(outputColumn++);
                        }
                        continue;
                    }
                    if (mapped) {
                        if (cast != null) {
                            mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn), true, cast.getType()));
                            continue;
                        }
                        mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn)));
                        continue;
                    }
                    addedFields.add(outputColumn++);
                    continue;
                }
                if (mapped) {
                    if (cast != null) {
                        mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn), true, cast.getType()));
                        continue;
                    }
                    mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn)));
                    continue;
                }
                addedFields.add(outputColumn++);
                continue;
            }
            if (mapped) {
                if (cast != null) {
                    mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn), true, cast.getType()));
                    continue;
                }
                mapFields.put((Integer)outputColumn++, new ProjectionMap.Column(new Pair<Integer, Integer>(0, inputColumn)));
                continue;
            }
            addedFields.add(outputColumn++);
        }
        ArrayList<Pair<Integer, Integer>> removedFields = new ArrayList<Pair<Integer, Integer>>();
        if (mapFields.size() == 0) {
            mapFields = null;
        }
        if (addedFields.size() == 0) {
            addedFields = null;
        }
        if (inputSchema == null) {
            removedFields = null;
        } else {
            HashSet<Integer> removedSet = new HashSet<Integer>();
            for (int i = 0; i < inputSchema.size(); ++i) {
                removedSet.add(i);
            }
            if (mapFields != null) {
                HashSet mappedSet = new HashSet();
                for (Integer key : mapFields.keySet()) {
                    ArrayList values = (ArrayList)mapFields.get(key);
                    for (ProjectionMap.Column value : values) {
                        mappedSet.add(value.getInputColumn().second);
                    }
                }
                removedSet.removeAll(mappedSet);
            }
            if (removedSet.size() == 0) {
                removedFields = null;
            } else {
                for (Integer i : removedSet) {
                    removedFields.add(new Pair<Integer, Integer>(0, i));
                }
            }
        }
        this.mProjectionMap = new ProjectionMap(mapFields, removedFields, addedFields);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        HashSet<Pair<Integer, Integer>> fields = new HashSet<Pair<Integer, Integer>>();
        HashSet<LOProject> projectSet = new HashSet<LOProject>();
        boolean starRequired = false;
        for (LogicalPlan plan : this.getForEachPlans()) {
            TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
            try {
                projectFinder.visit();
            }
            catch (VisitorException ve) {
                requiredFields.clear();
                requiredFields.add(null);
                return requiredFields;
            }
            projectSet.addAll(projectFinder.getProjectSet());
            if (projectFinder.getProjectStarSet() == null) continue;
            starRequired = true;
        }
        if (starRequired) {
            requiredFields.add(new RequiredFields(true));
            return requiredFields;
        }
        for (LOProject project : projectSet) {
            for (int inputColumn : project.getProjection()) {
                fields.add(new Pair<Integer, Integer>(0, inputColumn));
            }
        }
        if (fields.size() == 0) {
            requiredFields.add(new RequiredFields(false, true));
        } else {
            requiredFields.add(new RequiredFields(new ArrayList<Pair<Integer, Integer>>(fields)));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public void rewire(Operator<LOVisitor> oldPred, int oldPredIndex, Operator<LOVisitor> newPred, boolean useOldPred) throws PlanException {
        super.rewire(oldPred, oldPredIndex, newPred, useOldPred);
        LogicalOperator previous = (LogicalOperator)oldPred;
        LogicalOperator current = (LogicalOperator)newPred;
        for (LogicalPlan plan : this.mForEachPlans) {
            try {
                ProjectFixerUpper projectFixer = new ProjectFixerUpper(plan, previous, oldPredIndex, current, useOldPred, this);
                projectFixer.visit();
            }
            catch (VisitorException ve) {
                int errCode = 2144;
                String msg = "Problem while fixing project inputs during rewiring.";
                throw new PlanException(msg, errCode, 4, ve);
            }
        }
    }

    public Pair<Boolean, List<Integer>> hasFlatten() {
        boolean hasFlatten = false;
        ArrayList<Integer> flattenedColumns = new ArrayList<Integer>();
        for (int i = 0; i < this.mFlatten.size(); ++i) {
            Boolean b = this.mFlatten.get(i);
            if (!b.equals(true)) continue;
            hasFlatten = true;
            flattenedColumns.add(i);
        }
        return new Pair<Boolean, List<Integer>>(hasFlatten, flattenedColumns);
    }

    public LogicalPlan getRelevantPlan(int column) {
        if (column < 0) {
            return null;
        }
        if (this.mSchema == null) {
            return null;
        }
        return this.mSchemaPlanMapping.get(column);
    }

    public boolean isInputFlattened(int column) throws FrontendException {
        for (int i = 0; i < this.mForEachPlans.size(); ++i) {
            LogicalPlan forEachPlan = this.mForEachPlans.get(i);
            TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(forEachPlan);
            projectFinder.visit();
            for (LOProject project : projectFinder.getProjectList()) {
                if (project.getCol() != column || !this.mFlatten.get(i).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        if (this.mSchema == null) {
            return null;
        }
        if (this.mSchema.size() <= column) {
            return null;
        }
        LogicalPlan plan = this.getRelevantPlan(column);
        TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
        try {
            projectFinder.visit();
        }
        catch (VisitorException ve) {
            return null;
        }
        if (projectFinder.getProjectStarSet() != null) {
            result.add(new RequiredFields(true));
            return result;
        }
        ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
        for (LOProject project : projectFinder.getProjectSet()) {
            for (int inputColumn : project.getProjection()) {
                if (inputList.contains(new Pair<Integer, Integer>(0, inputColumn))) continue;
                inputList.add(new Pair<Integer, Integer>(0, inputColumn));
            }
        }
        if (inputList.size() == 0) {
            return null;
        }
        result.add(new RequiredFields(inputList));
        return result;
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        int i;
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (this.mSchema == null) {
            log.warn((Object)"Cannot prune columns in foreach, no schema information found");
            return false;
        }
        List<LOForEach> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            int errCode = 2190;
            throw new FrontendException("Cannot find predecessors for foreach", errCode, 4);
        }
        if (predecessors.size() != 1) {
            int errCode = 2193;
            throw new FrontendException("Foreach can only have 1 predecessor", errCode, 4);
        }
        if (((LogicalOperator)predecessors.get(0)).getSchema() == null) {
            int errCode = 2194;
            throw new FrontendException("Expect schema", errCode, 4);
        }
        for (Pair<Integer, Integer> column : columns) {
            if ((Integer)column.first != 0) {
                int errCode = 2191;
                throw new FrontendException("foreach only take 1 input, cannot prune input with index " + column.first, errCode, 4);
            }
            if ((Integer)column.second >= 0) continue;
            int errCode = 2192;
            throw new FrontendException("Column to prune does not exist", errCode, 4);
        }
        ArrayList<Integer> planToRemove = new ArrayList<Integer>();
        for (i = 0; i < this.mForEachPlans.size(); ++i) {
            LogicalPlan plan = this.mForEachPlans.get(i);
            TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
            try {
                projectFinder.visit();
            }
            catch (VisitorException ve) {
                int errCode = 2195;
                throw new FrontendException("Fail to visit foreach inner plan", errCode, 4);
            }
            if (projectFinder.getProjectStarSet() != null || projectFinder.getProjectSet().size() == 0) continue;
            boolean anyPruned = false;
            for (LOProject loProject : projectFinder.getProjectSet()) {
                Pair<Integer, Integer> pair = new Pair<Integer, Integer>(0, loProject.getCol());
                if (!columns.contains(pair)) continue;
                anyPruned = true;
                break;
            }
            if (!anyPruned) continue;
            planToRemove.add(i);
        }
        while (planToRemove.size() > 0) {
            int index = (Integer)planToRemove.get(planToRemove.size() - 1);
            if (this.mUserDefinedSchema != null) {
                for (int i2 = this.mUserDefinedSchema.size() - 1; i2 >= 0; --i2) {
                    if (this.getRelevantPlan(i2) != this.mForEachPlans.get(index)) continue;
                    this.mUserDefinedSchema.remove(i2);
                }
            }
            this.mForEachPlans.remove(index);
            this.mFlatten.remove(index);
            planToRemove.remove(planToRemove.size() - 1);
        }
        for (i = columns.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> column = columns.get(i);
            for (LogicalPlan plan : this.mForEachPlans) {
                this.pruneColumnInPlan(plan, (Integer)column.second);
            }
        }
        super.pruneColumns(columns);
        return true;
    }
}

