/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOGenerate
extends LogicalOperator {
    private static final long serialVersionUID = 2L;
    private ArrayList<LogicalPlan> mGeneratePlans;
    private ArrayList<Boolean> mFlatten;
    private ArrayList<Schema> mUserDefinedSchema = null;
    private static Log log = LogFactory.getLog(LOGenerate.class);

    public LOGenerate(LogicalPlan plan, OperatorKey key, ArrayList<LogicalPlan> generatePlans, ArrayList<Boolean> flatten) {
        super(plan, key);
        this.mGeneratePlans = generatePlans;
        this.mFlatten = flatten;
    }

    public LOGenerate(LogicalPlan plan, OperatorKey key, ArrayList<LogicalPlan> generatePlans, ArrayList<Boolean> flatten, ArrayList<Schema> userDefinedSchemaList) {
        super(plan, key);
        this.mGeneratePlans = generatePlans;
        this.mFlatten = flatten;
        this.mUserDefinedSchema = userDefinedSchemaList;
    }

    public LOGenerate(LogicalPlan plan, OperatorKey key, LogicalPlan generatePlan, boolean flatten) {
        super(plan, key);
        this.mGeneratePlans = new ArrayList();
        this.mGeneratePlans.add(generatePlan);
        this.mFlatten = new ArrayList();
        this.mFlatten.add(flatten);
    }

    public List<LogicalPlan> getGeneratePlans() {
        return this.mGeneratePlans;
    }

    public List<Boolean> getFlatten() {
        return this.mFlatten;
    }

    public List<Schema> getUserDefinedSchema() {
        return this.mUserDefinedSchema;
    }

    @Override
    public String name() {
        return "Generate " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (!this.mIsSchemaComputed) {
            List<LOGenerate> s = this.mPlan.getPredecessors(this);
            ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>();
            try {
                LogicalOperator op = (LogicalOperator)s.iterator().next();
                if (null == op) {
                    int errCode = 1006;
                    String msg = "Could not find operator in plan";
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                if (op instanceof ExpressionOperator) {
                    fss.add(Schema.FieldSchema.copyAndLink(((ExpressionOperator)op).getFieldSchema(), op));
                    this.mSchema = new Schema(fss);
                } else {
                    this.mSchema = op.getSchema();
                }
                this.mIsSchemaComputed = true;
            }
            catch (FrontendException ioe) {
                this.mSchema = null;
                this.mIsSchemaComputed = false;
                throw ioe;
            }
        }
        return this.mSchema;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Iterator<Serializable> it;
        LOGenerate generateClone = (LOGenerate)super.clone();
        if (this.mFlatten != null) {
            generateClone.mFlatten = new ArrayList();
            it = this.mFlatten.iterator();
            while (it.hasNext()) {
                generateClone.mFlatten.add((boolean)((Boolean)it.next()));
            }
        }
        if (this.mGeneratePlans != null) {
            generateClone.mGeneratePlans = new ArrayList();
            it = this.mGeneratePlans.iterator();
            while (it.hasNext()) {
                LogicalPlanCloneHelper lpCloneHelper = new LogicalPlanCloneHelper((LogicalPlan)it.next());
                generateClone.mGeneratePlans.add(lpCloneHelper.getClonedPlan());
            }
        }
        if (this.mUserDefinedSchema != null) {
            generateClone.mUserDefinedSchema = new ArrayList();
            for (Schema s : this.mUserDefinedSchema) {
                generateClone.mUserDefinedSchema.add(s != null ? s.clone() : null);
            }
        }
        return generateClone;
    }
}

