/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.BinaryExpressionOperator;
import org.apache.pig.impl.logicalLayer.LOAdd;
import org.apache.pig.impl.logicalLayer.LOAnd;
import org.apache.pig.impl.logicalLayer.LOBinCond;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LODivide;
import org.apache.pig.impl.logicalLayer.LOEqual;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOGenerate;
import org.apache.pig.impl.logicalLayer.LOGreaterThan;
import org.apache.pig.impl.logicalLayer.LOGreaterThanEqual;
import org.apache.pig.impl.logicalLayer.LOIsNull;
import org.apache.pig.impl.logicalLayer.LOLesserThan;
import org.apache.pig.impl.logicalLayer.LOLesserThanEqual;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOMapLookup;
import org.apache.pig.impl.logicalLayer.LOMod;
import org.apache.pig.impl.logicalLayer.LOMultiply;
import org.apache.pig.impl.logicalLayer.LONegative;
import org.apache.pig.impl.logicalLayer.LONot;
import org.apache.pig.impl.logicalLayer.LONotEqual;
import org.apache.pig.impl.logicalLayer.LOOr;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LORegexp;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOSubtract;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOUserFunc;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.UnaryExpressionOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlanCloneHelper
extends LOVisitor {
    public static Map<LogicalOperator, LogicalOperator> mOpToCloneMap;

    public LogicalPlanCloneHelper(LogicalPlan plan) throws CloneNotSupportedException {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        this.mPlan = plan.clone();
        this.mCurrentWalker = new DependencyOrderWalker(this.mPlan);
    }

    public LogicalPlanCloneHelper(LogicalPlan plan, Map<LogicalOperator, LogicalOperator> origCloneMap) throws CloneNotSupportedException {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        mOpToCloneMap = origCloneMap;
        this.mPlan = plan.clone();
        this.mCurrentWalker = new DependencyOrderWalker(this.mPlan);
    }

    public LogicalPlan getClonedPlan() throws CloneNotSupportedException {
        PlanSetter ps = new PlanSetter((LogicalPlan)this.mPlan);
        try {
            ps.visit();
            this.visit();
        }
        catch (VisitorException e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to set plan correctly during cloning");
            cnse.initCause(e);
            throw cnse;
        }
        return (LogicalPlan)this.mPlan;
    }

    public static void resetState() {
        mOpToCloneMap.clear();
    }

    @Override
    public void visit(BinaryExpressionOperator binOp) {
    }

    @Override
    public void visit(LOAdd op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOAnd binOp) throws VisitorException {
        this.visit((BinaryExpressionOperator)binOp);
    }

    @Override
    protected void visit(LOBinCond binCond) throws VisitorException {
    }

    @Override
    protected void visit(LOCast cast) throws VisitorException {
    }

    @Override
    protected void visit(LOCogroup cg) throws VisitorException {
        MultiMap<LogicalOperator, LogicalPlan> groupByPlans = cg.getGroupByPlans();
        MultiMap<LogicalOperator, LogicalPlan> groupByPlansClone = new MultiMap<LogicalOperator, LogicalPlan>();
        for (LogicalOperator cgInput : groupByPlans.keySet()) {
            LogicalOperator cgInputClone = mOpToCloneMap.get(cgInput);
            if (cgInputClone != null) {
                groupByPlansClone.put(cgInputClone, groupByPlans.get(cgInput));
                continue;
            }
            groupByPlansClone.put(cgInput, groupByPlans.get(cgInput));
        }
        cg.setGroupByPlans(groupByPlansClone);
        super.visit(cg);
    }

    @Override
    protected void visit(LOConst constant) throws VisitorException {
    }

    @Override
    protected void visit(LOCross cs) throws VisitorException {
        super.visit(cs);
    }

    @Override
    protected void visit(LODistinct dt) throws VisitorException {
        super.visit(dt);
    }

    @Override
    public void visit(LODivide op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        super.visit(filter);
    }

    @Override
    protected void visit(LOForEach forEach) throws VisitorException {
        super.visit(forEach);
    }

    @Override
    protected void visit(LOGenerate g) throws VisitorException {
        super.visit(g);
    }

    @Override
    protected void visit(LogicalOperator op) throws VisitorException {
        super.visit(op);
    }

    @Override
    public void visit(LOGreaterThan op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOGreaterThanEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOIsNull uniOp) throws VisitorException {
        this.visit((UnaryExpressionOperator)uniOp);
    }

    @Override
    public void visit(LOLesserThan op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOLesserThanEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    protected void visit(LOLimit limOp) throws VisitorException {
        super.visit(limOp);
    }

    @Override
    protected void visit(LOLoad load) throws VisitorException {
    }

    @Override
    public void visit(LOMapLookup op) throws VisitorException {
    }

    @Override
    public void visit(LOMod op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOMultiply op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LONegative op) throws VisitorException {
        this.visit((UnaryExpressionOperator)op);
    }

    @Override
    public void visit(LONot uniOp) throws VisitorException {
        this.visit((UnaryExpressionOperator)uniOp);
    }

    @Override
    public void visit(LONotEqual op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    public void visit(LOOr binOp) throws VisitorException {
        this.visit((BinaryExpressionOperator)binOp);
    }

    @Override
    protected void visit(LOProject project) throws VisitorException {
        LogicalOperator projectInputClone = mOpToCloneMap.get(project.getExpression());
        if (projectInputClone != null) {
            project.setExpression(projectInputClone);
        }
    }

    @Override
    protected void visit(LORegexp binOp) throws VisitorException {
        this.visit((BinaryExpressionOperator)binOp);
    }

    @Override
    protected void visit(LOSort s) throws VisitorException {
        super.visit(s);
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
        List<LogicalOperator> splitOutputs = split.getOutputs();
        ArrayList<LogicalOperator> splitOutputClones = new ArrayList<LogicalOperator>(splitOutputs.size());
        for (LogicalOperator splitOutput : splitOutputs) {
            LogicalOperator splitOutputClone = mOpToCloneMap.get(splitOutput);
            if (splitOutputClone != null) {
                splitOutputClones.add(splitOutputClone);
                continue;
            }
            splitOutputClones.add(splitOutput);
        }
        split.setOutputs(splitOutputClones);
    }

    @Override
    protected void visit(LOSplitOutput sop) throws VisitorException {
        super.visit(sop);
    }

    @Override
    protected void visit(LOStore store) throws VisitorException {
    }

    @Override
    protected void visit(LOStream stream) throws VisitorException {
    }

    @Override
    public void visit(LOSubtract op) throws VisitorException {
        this.visit((BinaryExpressionOperator)op);
    }

    @Override
    protected void visit(LOUnion u) throws VisitorException {
        super.visit(u);
    }

    @Override
    protected void visit(LOUserFunc func) throws VisitorException {
    }

    @Override
    protected void visit(UnaryExpressionOperator uniOp) throws VisitorException {
    }
}

